<?php
define ("SESSION_EXPIRE_TIME_DEFAULT", 7200);   //in seconds
define ("WARNING_TIME", 6);                     //in minutes
define ("SESSION_EXPIRE_TIME_FN", "/tmp/docker_scripts/session_expiration_time");

Epygi\Auth::rejectUnlessAuth();

$output = array();
try {
    exec('ls -l /etc/fiad-conf/sysconfig/localtime | awk \'{print $11;}\'', $output);
}
catch(Exception $e) {
    
}

$path = isset($output[0]) ? $output[0] : realpath('/etc/localtime');
$path_elements = explode('/', $path);
$element_count = count($path_elements);
if ($element_count > 2) {
    $tz_name = $path_elements[$element_count - 2] . '/' . $path_elements[$element_count - 1];
}

$dateTime = new DateTime('now');
if (isset($tz_name)) {
    $dateTime->setTimeZone(new DateTimeZone($tz_name));
}

$time_str = $dateTime->format('D, d-M-Y H:i T');

$session_expiration_time = @file_get_contents(SESSION_EXPIRE_TIME_FN);
$session_expiration_time = intval($session_expiration_time) ? intval($session_expiration_time) : SESSION_EXPIRE_TIME_DEFAULT;

$this_file_name = basename($_SERVER['PHP_SELF']);
$creation_time = filemtime($this_file_name);
$expire_time = $creation_time + $session_expiration_time - time();
$expire_time = intval($expire_time / 60);

$blink = '';
$msg = "Your session expires in: $expire_time min";
if ($expire_time <= 0) {
    $msg = "Your session is expired";
} else if ($expire_time <= WARNING_TIME) {
    $blink = "text-decoration: blink; -webkit-animation: blink 1s step-end infinite; -moz-animation: blink 1s step-end infinite; -o-animation: blink 1s step-end infinite; animation: blink 1s step-end infinite;";
}

$time_str = "<text style='color: #FFAA00; font-size: large;".$blink."'>$msg</text>". "<span style='padding-left: 30px'>$time_str</span>";

echo $time_str;
?>

