<?php
namespace Epygi\Cgi;

use Epygi;
use Mvc;

class Wrapper
{
    const WRAPPER_URL = 'http://127.0.0.1:8080';

    // headers and body
    public $js = '';
    public $meta = '';

    // after parsing
    public $content = '';
    public $title = '';
    public $backButton = '';
    private $headers = array();
    private $body = '';

    private function curlRequest()
    {
        // current page
        $router = Mvc\Router::getInstance();
        $uri = $router->getUriWrapped();

        $params = $_GET;

        // selected
        $selected = Epygi\Selected\Extension::getInstance();

        // selected: extension
        if ($selected->getId()) {
            if ($selected->isExtension() || $selected->isTemplate( ) || $selected->isRecording() ) {
                $params['extension_name'] = $selected->getId();
            }
            elseif ($selected->isConference()) {
                $params['conference_name'] = $selected->getId();
            }
            elseif ($selected->isVoiceMailBox()) {
                $params['vmb_name'] = $selected->getId();
            }
        }

        // merge wrapped params
        $params = array_merge($params, $router->getWrappedParams());

        // which page are we wrapping?
        $script = $uri . '.cgi';
        $params = $params ? ('?' . http_build_query($params)) : '';
        $url = self::WRAPPER_URL . $script . $params;

        /**
         * We need to continue using the callerPath for a while longer because the vlan edit page will redirect
         * back to the caller path after submit and unless have the right caller path, it'll default to itself and
         * pages don't work correctly.  Here we decode the callerPath to fix encoding problems with the Pilcrow
         * character.  TODO: fix this or convert all CGIs to PHP :-)
         */
        if (isset ($_POST["callerPath"])) {
            $_POST["callerPath"] = utf8_decode($_POST["callerPath"]);
        }

        // open curl connection remote server
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FRESH_CONNECT, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_VERBOSE, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_AUTOREFERER, true);

        // we pass our authentication token as an epycookie (created by our LoginForm)
        curl_setopt($ch, CURLOPT_COOKIE, 'epycookie=' . Epygi\Auth::getCgiSessionId());

	//SPR 20437 , 20438		
        $postFileWithCurlFile=false;
        if($script == "/backuprestoreconfint.cgi"){
    	    $postFileWithCurlFile = true;
        }

        // pass through our POST data
        if (Mvc\Param::server('REQUEST_METHOD') == 'POST') {
            $postData = $_POST;
    	    $findex = 0;
            //by adding ths field in postdata, the CGI will be notified about already uploaded file
            $uploadedFile = "ep-php-wrapper-uploaded-file";
            // if File(s) uploaded prepare file to send Curl;
            if (isset ($_FILES) && count($_FILES) > 0) {
                $cfile = array();
                foreach ($_FILES as $key => $file) {
                    // Check if file selected for upload or no!
                    if (isset ($file['tmp_name']) && $file['error'] == 0 && !empty ($file['tmp_name'])) {
                        
			if($postFileWithCurlFile == true) {
			    //curl_file_create function exist (this is for php 5.5 version)
    		    	$cfile[$key] = curl_file_create($file['tmp_name'], $file['type'], $file['name']);
			}
			else {
			    // notify CGI that the file is uploaded
			    $val = "name=\"" . $key . "\" " . "filename=\"" . $file['tmp_name'] . "\" " . "type=\"" . $file['type'] . "\" "  . "postname=\"" . $file['name'] . "\" " ;
			    $postData[$uploadedFile . $findex] = $val;
			    $findex++;	
			}
                    }
                }

                // merge $_POST data array and uploaded files array
		if($postFileWithCurlFile == true){
            	    $postData = array_merge($postData, $cfile);
		}
            }
            else {
                $postData = http_build_query($postData);
            }

            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        }

        // execute the request
        $response = curl_exec($ch);

        // separate the header from the body
        $header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
        $header = substr($response, 0, $header_size);
        $body = substr($response, $header_size);

        // Close connection
        curl_close($ch);

        /**
         * Parse the Set-Cookie header.
         * If it is set to 'loggedOut' the cgi is logged out, so log out the PHP session too.
         */
	preg_match_all('|Set-Cookie: (.*);|U', $header, $content);   
	$ResponseCookie = implode(';', $content[1]);
	parse_str($ResponseCookie, $output);
	if( isset($output['epycookie'])){
	$cookiefound = strstr($output['epycookie'],'loggedOut');
	if ( !empty($cookiefound) ){
        	Epygi\Auth::logOut();
        	header('Location: /login');
	    exit();
	    }
	}
	
        /**
         * Parse the HTTP headers lightly.
         * We don't want to use a huge library which is RFC perfect. Just this
         * simple hack will cover 99.99999% of our needs. After all, we are trying to get rid of CGIs long-term.
         * From RFC 2616, "Hypertext Transfer Protocol -- HTTP/1.1", §4.2, "Message Headers":
         * Each header field consists of a name followed by a colon (":") and the field value. Field names are
         * case-insensitive.
         * http://stackoverflow.com/questions/5258977/are-http-headers-case-sensitive
         */
        $headers = array();
        $lines = preg_split('/\R/', $header, 0, PREG_SPLIT_NO_EMPTY);
        foreach ($lines as $line) {
            // separate key and value
            $parts = preg_split('/:\s*/', trim($line), 2);
            $key = strtolower(trim(array_shift($parts)));
            $value = trim(array_shift($parts));

            // save key and value in our array
            if ($key && $value) {
                $headers[$key] = $value;
            }
        }

        /**
         * If this is not Content-type: text/html, return only 'content-disposition' and 'content-type' (we can
         * just return the contents as-is without further modification).
         */
        $content_type = isset ($headers['content-type']) ? $headers['content-type'] : false;
        if (strpos($content_type, 'text/html') === false) {
            // send all the headers out
            if (isset ($headers['content-disposition'])) {
                header("content-disposition:" . $headers['content-disposition']);
            }
            if (isset ($headers['content-disposition'])) {
                header("content-type:" . $headers['content-type']);
            }

            // send the body out
            echo $body;
            exit ();
        }

        // return parsed headers array and body
        $this->headers = $headers;
        $this->body = $body;
    }

    private function extractJavaScript(&$head, $replace = false)
    {
        preg_match_all('#<script.*?</script>#si', $head, $regs);

        $out = array();
        foreach ($regs[0] as $js) {
            // remove leading whitespace
            $js = preg_replace('#^\s+#m', '', $js);

            // fix tag format
            $js = preg_replace('#<script\s+(type|language)=".*?">#i', '<script>', $js);
            $out[] = $js;
        }

        // remove from original HTML
        if ($replace) {
            $head = preg_replace('#<script.*?</script>#si', '', $head);
        }

        // join script blocks as a single string
        $sep = '<!-- ' . str_repeat('#', 80) . " -->\n";
        return $sep . join("\n", $out) . "\n" . $sep;
    }

    public function process()
    {
        // pass our GET or POST data through to the CGI layer using CURL ...
        $this->curlRequest();
        $js = null;
        $content = $this->body;
	
        // get header js
        preg_match('/<head[^>]*>[\s\S]*?<\\/head>/is', $content, $head);
        if ($head) {
            $js = $this->extractJavaScript($head[0]);
        }

        // get redirect meta
        preg_match_all('/<meta[\s\S]*?\>/is', $content, $metas);
        $meta = (isset ($metas[0]) && isset ($metas[0][0])) ? $metas[0][0] : '';

        foreach ($metas[0] as $m) {
            // remove leading whitespace
            $m = preg_replace('#^\s+#m', '', $m);
            $meta = $m . $meta;
        }

        //------------------------------
        /*
         * The Wrapper/theme.conf file has been modified to contain special {TAGNAME}...{/TAGNAME} delimiters.  This
         * callback function will extract those values as an array ($tags) while simultaneously removing the tags
         * from the content.
         */
        // start with blank tags
        $tags = array();

        // match and extract (at same time) tags from content (notice the regex is multiline)
        $content = preg_replace_callback(
            '/\{(title|hostname|charset|error|globalerror|info|oldmenu|backbutton)}(.*?){\/\\1}/s',
            function ($match) use (&$tags) {
                // capture the tag
		$val = trim($match[2]);
		if(!empty($val)){
            	    $tags[$match[1]] = trim($match[2]);
		}

                // remove the tag
                return '';
            },
            $content
        );

        //------------------------------

        // backButton
	 if( isset($tags['backbutton']) ) {
	    preg_match('/<input[\s\S]*?value=\"(.*?)\"/i', $tags['backbutton'], $match);
	    $this->backButton = $match[1];
	 }
	 else {
	        $this->backButton = '';
	 }

        // title
        $this->title = isset($tags['title']) ? $tags['title'] : null;

        // meta
        $this->meta = isset($tags['meta']) ? $tags['meta'] : null;

        $inlinejs = $this->extractJavaScript($content, true);

        // return Cgi HTML from body
        $content = $this->stripPageFrame($content);

        // global error: SUCCESS
        if (isset($tags['info'])) {
            $error = strip_tags($tags['info']);
            Epygi\View\GlobalError::info(html_entity_decode($error));
        }

        // global error: ERROR
        if (isset($tags['error'])) {
            $error = strip_tags($tags['error']);
            Epygi\View\GlobalError::error(html_entity_decode($error));
        }

        // global error: ERROR
        if (isset($tags['globalerror'])) {
            $error = strip_tags($tags['globalerror']);
            Epygi\View\GlobalError::error(html_entity_decode($error));
        }

        // save for the page
        $this->content = $meta . $content;
        $this->meta = $meta;
        $this->content = $js . $content;
        $this->js = $inlinejs;
    }

    private function stripPageFrame($html)
    {
        // remove header
        $html = preg_replace('#^.*?<wrapper>\s*#si', '', $html);

        // remove footer
        $html = preg_replace('#</wrapper>.*?$#si', '', $html);

        // cleaned html
        return $html;
    }
}