<?php

abstract class BaseModel {
    protected  $apiRequestObj;
    protected  $log;
    protected   $db;

    public function __construct( $apiRequestObj) {
      $this->apiRequestObj = $apiRequestObj;
      $this->log = $this->apiRequestObj->getLogObj();
      /*$this->db = $this->apiRequestObj->getDatabaseObj();*/
    }

    public function getClientIP() {
      if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
      } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
      } else {
        $ip = $_SERVER['REMOTE_ADDR'];
      }
      return $ip;
    }

    public function execute( $endpoint, $args) {
      $responseCode = ApiConstants::http_OK;
      try {
        $responseData = call_user_func(array($this, $endpoint), $args);
      }
      catch(EndpointException $e) {
        $responseCode = $e->getCode();
        $rawResponse = $e->getRawResponse();
        if (!$rawResponse) {
          $rawResponse = array(
          ApiConstants::KEY_SUCCESS => false,
            ApiConstants::KEY_ERROR => array(
              ApiConstants::KEY_CODE => $e->getCode(),
              ApiConstants::KEY_MESSAGE => $e->getMessage()
            )
          );
        }
        $responseData = array(ApiConstants::MESSAGE => $e->getMessage(), ApiConstants::KEY_RAW_RESPONSE => $rawResponse);
        $this->log->add(__FILE__ . ":" . __LINE__ ."\n". $e->getCode() . " : " . $e->getMessage() . "\n". print_r($e->getLogData(), true),
              $e->getCode()==ApiConstants::http_Internal_Server_Error ? LogMgmt::LVL_FATAL : LogMgmt::LVL_ERROR, $e->getSection() );
      }
      return array(ApiConstants::STATUS_CODE => $responseCode, ApiConstants::MESSAGE => $responseData);
    }
}
