/*
** this function calls a second window to display the help text
*/

function showhelp ( wH, isExt )
{
 if ((wH!='callcodes') && (wH!='confcallcodes') && (document.forms[0].helpButton)) {
  document.forms[0].helpButton.click();
 } else {
  sP = wH.lastIndexOf( "/" );
  if ( sP > 0 ) {
   wH = wH.substring ( sP + 1, wH.length );
  }
  cP = wH.lastIndexOf ( ".cgi" );
  if ( cP > 0 ) {
   wH = wH.substring ( 0, cP );
  }
  if ( wH == "" || wH == "rollback" ) {
   wH = "mainmenu";
  }
  var extNo="";
  if ( document.forms[0].extension_name ) {
   extNo=document.forms[0].extension_name.value;
  }
  if ( isExt==2 || ((isExt==1||(extNo!="")) && wH == "mainmenu" ) ) {
   wH = wH + "ext";
  }

  if (extNo=="" && document.forms[0].conference_name) {
   extNo=document.forms[0].conference_name.value;
  
   if (isExt==2||((isExt==1||(extNo!=""))&&(wH=="mainmenu"))) {
    wH=wH+"conf";
   }
  }

  if ((lG.length>0) && (lG!='C')) {
   wH="/help/"+lG+"/"+wH+".html";
  } else {
   wH="/help/C/"+wH+".html";
  }
  hW = window.open( wH, "EpyHelp", "height=400,location=no,menubar=no,resizable=yes,status=no,toolbar=no,scrollbars=yes,width=600" );
  hW.focus();
 }
}

/*
** small help functions for getting a random color
*/

var hexDigits = new Array("0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F");

function searchHexArray( value )
{
 for (var i = 0; i < hexDigits.length; i++) {
  if ( value == hexDigits[i] ) {
   break;
  }
 }
 return i;
}

function randomColor()
{
 var colorString = "#";
 for (var i = 0; i < 6; i++) {
  colorString += hexDigits[Math.floor(Math.random() * 16)];
 }
 return colorString;
}

/*
** the functions for the progress bar
*/

/*
** the construktor for the progress bar class
*/

function ProgressBar()
{
 var flagShowText = 0;
 // Properties
 this.mName   = 0;
 this.mWidth   = 0;
 this.mLeft   = 0;
 this.mDir   = 0;
 this.mStarted  = 0;
 this.mStopped  = 0;
 this.mType   = 0;
 this.mDuration  = 5000;
 this.mShowText  = 0;
 this.mStepCount  = 100;
 this.mStep   = 1;
 this.mFillLevel  = 0;
 this.mSpeed   = 25;
 this.mSpeedOffset = 1;
 this.mWaitString = "Process: idle";
 this.mActionString = "Process: uploading...";
 this.mFinishString = "Process: finished!";
 this.mSliderState = 0;
 switch( ProgressBar.arguments.length ) { // if you give less then 7 parameters the default-values are used
  case 7:
    this.mActionString = ProgressBar.arguments[6];
  case 6:
    this.mWaitString = ProgressBar.arguments[5];
  case 5:
    flagShowText = ProgressBar.arguments[4];
  case 4:
	this.mStepCount	= ( ProgressBar.arguments[3] < 180 ) ? ProgressBar.arguments[3] : 180;
  case 3:
    this.mDuration = ProgressBar.arguments[2];
  case 2:
    this.mType  = ProgressBar.arguments[1];
  case 1:
    this.mName  = ProgressBar.arguments[0];
 }
 // Methods
 this.Start   = Start;
 this.Stop   = Stop;
 this.MoveSquare  = MoveSquare;
 this.SizeSquare  = SizeSquare;
 this.SizeInTime  = SizeSquareInTime;
 this.SizeByCall  = SizeSquareByCall;
 this.SetPercentage = SetPercentage;
 this.ShowText  = ShowText;
 this.RefreshTxt  = RefreshTxt;
 this.RisingSlider = RisingSlider;
 this.CalcSpeedOff = CalculateSpeedOffset;
 this.CyclingSlider = CyclingSlider;
 if (this.mName != 0) {
  this.mObj			= document.getElementById(this.mName);
  if ( this.mObj != 0 ) {
   this.mProgressText	= document.createElement('div');
   this.mProgressText.className = 'ProgressbarText';
   this.mProgressLevel = this.mProgressText.cloneNode(true);
   this.mBackground	= document.createElement('div');
   this.mBackground.className = 'ProgressbarBackground';
   this.mObj.appendChild(this.mProgressText);
   this.mObj.appendChild(this.mBackground);
   this.mObj.appendChild(this.mProgressLevel);
   var divToClear		= document.createElement('div');
   divToClear.style.clear = 'both';
   if ( this.mObj.nextSibling ) {
    this.mObj.parentNode.insertBefore(divToClear, this.mObj.nextSibling);
   } else {
    this.mObj.parentNode.appendChild(divToClear);
   }
   this.mSlider		= document.createElement('div');
   this.mSlider.className = 'ProgressbarSlider';
   this.mBackground.appendChild(this.mSlider);
   this.mStep = ( 200 / this.mStepCount ); // a width of 200 pixel devided into mStepCount pieces, so every piece is mStep pixel big
   // inital settings
   this.ShowText(flagShowText);
   this.mProgressText.appendChild(document.createTextNode(this.mWaitString));
  }
 }
}

/*
* it devides the way of the slider into 5 parts and calculates for each part a speed offset
*/

function CalculateSpeedOffset(  )
{
 var maxValue, divisor, dependency;
 var calculate = 1;
 switch ( this.mType ) { // will only be calculated for certain progress bar types
  case 6:
   maxValue = 90;
   divisor  = 18;
   dependency = this.mLeft;
  break;
  case 9:
   maxValue = 100;
   divisor  = 20;
   dependency = this.mLeft + this.mWidth;
  break;
  default:
   calculate = 0;
  break;
 }
 if ( calculate ) { // the differences between the speed offsets --> fibonacci numbers
  switch( Math.floor( Math.abs( dependency - maxValue ) / divisor ) ) {
   case 0 :
   this.mSpeedOffset = 8;
   break;
   case 1 :
   this.mSpeedOffset = 5;
   break;
   case 2 :
   this.mSpeedOffset = 3;
   break;
   case 3 :
   this.mSpeedOffset = 2;
   break;
   case 4 :
   default:
   this.mSpeedOffset = 1;
   break;
  }
 }
 if ( this.mSpeedOffset < 1 ) {
  this.mSpeedOffset = 1;
 }
}

/*
** updates the text behind the progress bar, which shows the actual fill level of the progress bar
*/

function RefreshTxt(appendix)
{
 if ( this.mProgressLevel.firstChild ) {
  this.mProgressLevel.firstChild.nodeValue = this.mFillLevel + appendix;
 } else {
  this.mProgressLevel.appendChild(document.createTextNode(this.mFillLevel + appendix ));
 }
}

/*
** with this function the animation of the progress bar will be started
*/

function Start()
{
 if (this.mStarted == 0) {
  this.mStarted = 1;
  this.mProgressText.firstChild.nodeValue = this.mActionString;
  this.mBackground.style.visibility = "visible";
  this.mSlider.style.backgroundColor = "black";
  if ( this.mType == 13 ) {
   var randomTypes = new Array (0,6,8,9);
   this.mType = randomTypes[Math.floor(Math.random() * randomTypes.length)];
  }
  switch(this.mType) {
   case 6:
    this.mSpeed = 50;
   case 0:
    this.mStep = Math.ceil(180 / this.mStepCount);
    this.MoveSquare();
   break;
   case 1:
    this.SizeSquare();
   break;
   case 2:
    this.SizeByCall(0);
   break;
   case 4:
    this.mFillLevel = this.mDuration;
   case 3:
    this.mSpeed = this.mDuration / this.mStepCount;
    this.SizeInTime();
   break;
   case 5:
    this.SetPercentage(0);
   break;
   case 7:
   case 8:
    this.RisingSlider();
   break;
   case 9:
    this.mSpeed = 50;
    this.CyclingSlider();
   break;
   default:
   alert("Such a progress bar is not available");
   break;
  }
 }
}

/*
** here the animation will be stopped
*/

function Stop()
{
 if ( !this.mStopped ) {
  this.mStopped = 1;
  setTimeout(this.mName + ".Stop()", 250);
 } else {
  with ( this.mSlider ) {
   style.top = "0px";
   style.left = "0px";
   style.width = "200px";
  }
  this.mProgressText.firstChild.nodeValue = this.mFinishString;
 }
}

/*
** you can use this function also to manipulate the other progressbar, while they are running;
** But only with those types, where the bar is filled once from left to right;
*/

function SizeSquareByCall(step)
{
 if ( !this.mStopped && ( this.mType > 0 ) && ( this.mType < 6 ) ) {
  this.mWidth += ( 200 / this.mStepCount ) * step;
  if ( this.mWidth < 0 ) {
   this.mWidth = 0;
  }
  if ( this.mWidth >= 200 ) {
   this.mWidth = 200;
   this.mStopped = 1;
  }else {
   if (this.mType == 2) {
    this.mStarted = 0;
   }
  }
  this.mSlider.style.width = ( this.mWidth ) + "px";
  if ((this.mType == 2) || (this.mType == 5)) {
   this.mFillLevel = this.mWidth / 2;
   this.RefreshTxt(" %");
  }
 }
}

/*
** this function moves a square from side to side
*/

function MoveSquare()
{
 if (this.mDir == 0) {
  this.mLeft += this.mStep;
  this.mDir = (this.mLeft >= 180)? 1 : 0;
 } else {
  this.mLeft -= this.mStep;
  this.mDir = (this.mLeft <= 0)? 0 : 1;
 }
 if (this.mType == 6) {
  this.CalcSpeedOff();
 }
 var speed = Math.ceil( this.mSpeed / this.mSpeedOffset );
 this.mFillLevel += speed;
 this.RefreshTxt(" ms");
 this.mSlider.style.left = this.mLeft + "px";
 if ( !this.mStopped ) {
  setTimeout(this.mName + ".MoveSquare()", speed);
 }
}

/*
** here the bar is filled from left to right
*/

function SizeSquare()
{
 this.mWidth += this.mStep;
 this.mSlider.style.width = this.mWidth + "px";
 this.mFillLevel = this.mWidth / 2;
 this.RefreshTxt(" %");
 if ( this.mWidth < 200 ) {
  setTimeout (this.mName + ".SizeSquare()",this.mSpeed);
 } else {
  this.mProgressText.firstChild.nodeValue = this.mFinishString;
  this.mStopped = 1;
 }
}

/*
** the bar is filled in a certain time -> mDuration
*/

function SizeSquareInTime()
{
 this.mWidth += this.mStep;
 this.mSlider.style.width = ( ( this.mWidth < 200 ) ? ( this.mWidth ) : "200" ) + "px";
 if ( this.mType == 3 ) {
  this.mFillLevel += this.mSpeed;
 } else {
  this.mFillLevel -= this.mSpeed;
 }
 this.RefreshTxt(" ms");
 if ( this.mWidth < 200 ) {
  setTimeout (this.mName + ".SizeInTime()",this.mSpeed);
 } else {
  this.mStopped = 1;
 }
}

/*
** sets the bar to a fill level of percent %
*/

function SetPercentage(percent)
{
 // this function positions the progressbar at "percent" percent
 this.mWidth = 0;
 this.SizeByCall( ( percent / this.mStep ) * 2 );
}

/*
** switches the text infront and behind the progress bar on or off
*/

function ShowText(showText)
{
 var localShowText = showText % 4;
 if ( this.mShowText != localShowText ) {
  this.mShowText = localShowText;
  if ( this.mShowText & 1 ) {
   this.mProgressLevel.style.visibility = "visible";
  } else {
   this.mProgressLevel.style.visibility = "hidden";
  }
  if ( this.mShowText & 2 ) {
   this.mProgressText.style.visibility = "visible";
  } else {
   this.mProgressText.style.visibility = "hidden";
  }
 }
}

/*
** a small slider moves from left to right, when the right side is reached,
** it disappears on the right and appears on the left simultaneously
*/
function CyclingSlider()
{
 switch(this.mSliderState) {
  case 0:
   this.mSlider.style.backgroundColor = randomColor();
   this.mSlider.style.width = this.mWidth + "px";
   this.mSliderState = 1;
  case 1:
   this.mSlider.style.width = ++this.mWidth + "px";
   if ( this.mWidth == 20 ) {
    this.mSliderState = 2;
   }
  break;
  case 2:
   this.mSlider.style.left = ++this.mLeft + "px";
   if ( this.mLeft == 180 ) {
    this.mSliderState = 3;
   }
  break;
  case 3:
   var clone = this.mSlider.cloneNode(true);
   this.mWidth = 0;
   this.mLeft = 0;
   with(this.mSlider) {
    parentNode.appendChild(clone);
    style.backgroundColor = randomColor();
    style.width = this.mWidth + "px";
    style.left = this.mLeft + "px";
   }
   this.mSliderState = 4;
  case 4:
   this.mSlider.style.width = ++this.mWidth + "px";
   this.mSlider.nextSibling.style.width = (20 - this.mWidth) + "px";
   if (this.mWidth == 20) {
    this.mSliderState = 5;
   }
  break;
  case 5:
   this.mSlider.parentNode.removeChild(this.mSlider.nextSibling);
   this.mSlider.style.left = ++this.mLeft + "px";
   this.mSliderState = 2;
  break;
  default:
   alert("very bad fault with the cycling slider bar");
 }
 if (this.mType == 9) {
  this.CalcSpeedOff();
 }
 var speed = Math.ceil( this.mSpeed / this.mSpeedOffset );
 if ( !this.mStopped ) {
  setTimeout(this.mName + ".CyclingSlider()", speed);
 }
}

/*
** the slider moves from the left side to the right side, fills the bar 100% and disappears on the right side;
** when the slider is completly disappeared, it begins from left;
*/

function RisingSlider()
{
 if ( this.mDir == 0 ) {
  this.mWidth++;
  if ( this.mWidth >= 200 ) {
   this.mDir = 1;
  }
 } else {
  this.mWidth--;
  this.mLeft++;
  if ( this.mLeft >= 200 ) {
   this.mLeft = 0;
   this.mDir = 0;
   if (this.mType ==  8) {

    this.mSlider.style.backgroundColor = randomColor();
   }
  }
 }
 this.mSlider.style.width = this.mWidth + "px";
 this.mSlider.style.left = this.mLeft + "px";
 this.mFillLevel += this.mSpeed;
 this.RefreshTxt(" ms");
 if ( !this.mStopped ) {
  setTimeout(this.mName + ".RisingSlider()",this.mSpeed);
 }
}

/**
* the following is for the progress text iframe
*/

/*
** the member variables of the ProgressText-Class
*/

function ProgressText()
{
 // Properties
 this.mName = ( ProgressText.arguments.length > 0 ) ? ( ProgressText.arguments[0] ) : 0 ;
 if ( this.mName != 0 ) {
  this.mDiv = document.getElementById( this.mName );
  this.mDiv.style.zIndex = this.mDiv.parentNode.style.zIndex;
  this.mDiv.appendChild(document.createElement('pre'));
  this.mPre = this.mDiv.childNodes[0];
 }
}

/*
** the declaration of the member functions
*/

function insertReturn()
{
  this.InsertText(' ');	/* without this line the Microsoft IE ignores the BR */
  var m = document.createElement('br');
  this.mPre.appendChild(m);
  this.mDiv.scrollTop = this.mDiv.scrollHeight;
}

function insertText(text)
{
  var m = document.createTextNode(text);
  this.mPre.appendChild(m);
  this.mDiv.scrollTop = this.mDiv.scrollHeight;
}

/*
** the dummy objekt, because of JavaScript1.1 to get the prototype objekt
*/

new ProgressText();

/*
** here the functions were asigned to the ProgressText-Class as member functions
*/

ProgressText.prototype.InsertReturn = insertReturn;
ProgressText.prototype.InsertText = insertText;

/* end for the progress text iframe */
