<?php
use Epygi\Auth;
use Epygi\Enum\Role as ERole;
use Epygi\Locale;
use Mvc\Feature;
use Mvc\FeatureUtils;

/**
 * This next line is an ugly hack.  We have "Extensions" and "Conferences" as two separate tabs in the Extensions
 * section.  All of the links between conferences and extensions are shared, however.  So, dynamically, we will
 * move pages from one section of the tree to another section based on whether we have selected a conference to
 * view.
 */
$ext = Epygi\Selected\Extension::getInstance();
$extension_parent = $ext->isConference() ? 'userconferences' : ($ext->isAcdQueue() ? 'acdmanagement?page=acd_groups' : 'usermanagement');
$isadmin_no_cloud = ((Auth::isAdmin() || Auth::isLocalAdmin()) || (!Feature::hasCloudOwnService()));

return [
    //----------------------------------------------------------------------------------------------------
    // DASHBOARD
    //----------------------------------------------------------------------------------------------------
    'mainmenu' => [
        'condition' => Feature::hasTelephony(),
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'dashboard',
        'icon' => 'fa fa-tachometer',
        'label' => _('Dashboard'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'data',
    ],
    //----------------------------------------------------------------------------------------------------
    // SYSTEM SETUP
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.setup' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::SUPERADMIN,
        'helproot' => 'setup',
        'icon' => 'fa fa-cog',
        'label' => _('Setup'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // OVERVIEW
    'setup/overview' => [
        'label' => _('Overview'),
        'parent' => 'menu.tabs.setup',
        'type' => 'data',
    ],
    //--------------------
    // BASIC SETUP
    'menu.pills.setup-basic' => [
        'label' => _('Basic Setup'),
        'parent' => 'menu.tabs.setup',
        'type' => 'pills',
    ],
    // System (LAN)
    'syswizard' => [
        'condition' => !Feature::hasCloudOwnService(),
        'desc' => _('Configure LAN interface and regional settings.'),
        'label' => Feature::isPc() ? _('System Configuration Wizard') : _('System (LAN)'),
        'parent' => 'menu.pills.setup-basic',
        'type' => 'wizard',
    ],
    // Internet (WAN)
    'netwizard' => [
        'condition' => !Feature::isPc(),
        'desc' => _('Configure WAN interface settings and adjust connectivity with external network.'),
        'label' => _('Internet (WAN)'),
        'parent' => 'menu.pills.setup-basic',
        'type' => 'wizard',
    ],
    // Regional
    'regional' => [
        'condition' => Feature::hasCloudOwnService(),
        'desc' => _('Configure regional settings.'),
        'label' => ('Regional Settings'),
        'parent' => 'menu.pills.setup-basic',
        'type' => 'form',
    ],
    // Hostname
    'local' => [
        'condition' => Feature::hasCloudOwnService(),
        'desc' => _('Configure Host and Domain name settings.'),
        'label' => ('Hostname Settings'),
        'parent' => 'menu.pills.setup-basic',
        'type' => 'form',
    ],
    // Date and Time
    'timedate' => [
        'desc' => _('Configure time server and/or time client.'),
        'label' => _('Date and Time'),
        'parent' => 'menu.pills.setup-basic',
        'type' => 'form',
    ],
    'timedateadd' => [
        'label' => _('Date and Time - Add Entry'),
        'parent' => 'timedate',
        'type' => 'form',
    ],
    // EcMon (QX monitoring)
    'ecmon' => [
        'desc' => _('Send device monitoring data to ecMon cloud server for monitoring and analysis.'),
        'label' => _('ecMON'),
        'parent' => 'menu.pills.setup-basic',
        'type' => 'form',
    ],
    // MySQL Server
    'mysqlmanagement' => [
        'condition' => Feature::hasSqlServer(),
        'desc' => _('Manage internal MySQL server.'),
        'label' => _('MySQL Management'),
        'parent' => 'menu.pills.setup-basic',
        'type' => 'form',
    ],
    //--------------------
    // SECURITY
    'menu.pills.security' => [
        'condition' => Feature::hasTelephony(),
        'label' => _('System Security'),
        'parent' => 'menu.tabs.setup',
        'type' => 'pills',
    ],
    'security?SecurityPageState=SystemSecuritySettings' => [
        'default' => true,
        'desc' => _('Set security level to Low, Medium, or High for all passwords used in the system.'),
        'label' => _('Security Settings'),
        'parent' => 'menu.pills.security',
        'type' => 'form',
    ],
    'tlscertificates' => [
        'desc' => _('Install TLS Certicate.'),
        'label' => _('TLS Certificate'),
        'parent' => 'menu.pills.security',
        'type' => 'form',
    ],
    'security?SecurityPageState=EncryptionSettings' => [
        'desc' => _('Encrypt call recordings to send'),
        'label' => _('Encryption Settings'),
        'parent' => 'menu.pills.security',
        'type' => 'form',
    ],
    //--------------------
    // FEATURE KEYS
    'menu.pills.license' => [
        'condition' => Feature::hasFeature() && !Feature::isConfigEmulator(),
        'label' => _('Licensed Features'),
        'parent' => 'menu.tabs.setup',
        'type' => 'pills',
    ],
    'features' => [
        'condition' => Feature::hasFeature() && !Feature::isConfigEmulator(),
        'desc' => _('List of licensed features that may be activated by installing a software license key.'),
        'label' => _('Feature Keys'), // Install Feature Keys
        'parent' => 'menu.pills.license',
        'type' => 'grid',
    ],
    // Free Trial

    'featurestrial' => [
        'condition' => !Feature::hasCloudOwnService() && !Feature::hasPCOwnService()&& Feature::hasFeature() && !Feature::isConfigEmulator(),
        'desc' => _('Activate a one-time trial on one or many licensed features.'),
        'label' => _('Free Trial'),
        'parent' => 'menu.pills.license',
        'type' => 'form',
    ],

    // conversion keys
    'conversionkey' => [
        'condition' => ( Feature::isIsdnGateway() || Feature::isPhoneGateway() )&& !Feature::isConfigEmulator(),
        'label' => _('Conversion Key'),
        'parent' => 'menu.internal.setup',
        'type' => 'form',
    ],
    'cloudfeatures' => [
        'condition' => Feature::hasCloudOwnService() && Feature::hasFeature() && !Feature::isConfigEmulator(),
	'acl' => ERole::SUPERADMIN,
        'type' => 'form',
    ],
    //--------------------
    // Consumable Licenses
    'menu.pills.licenses.consumable' => [
        'condition' => Feature::hasFeature() && !Feature::isConfigEmulator(),
        'label' => _('Consumable Licenses'),
        'parent' => 'menu.tabs.setup',
        'type' => 'pills',
    ],
	'smsaccount' => [
        'condition' => Feature::hasSms() && Feature::isPbx() && Feature::hasIpLines(),
        'desc' => _('SMS/WhatsApp account settings to send and receive text messages to and from mobile phones.'),
        'label' => _('SMS/WhatsApp Account'),
        'parent' => 'menu.pills.licenses.consumable',
        'type' => 'form',
    ],
    //--------------------
    // REDUNDANCY
    'redundancy' => [
        'condition' => Feature::hasRedundancy(),
        'desc' => _(
            'Configure a redundant (high availability) system using a master and backup units connected through LAN ports.'
        ),
        'label' => _('Redundancy'),
        'parent' => 'menu.tabs.setup',
        'type' => 'form',
    ],

    // REDUNDANCY METHOD
    'redundancymethod' => [
        'condition' => Feature::hasRedundancy(),
        'desc' => _('Select Redundancy Method'),
        'label' => _('Redundancy Method'),
        'parent' => 'internal',
    ],

    //--------------------
    // LANGUAGE
    'menu.pills.language' => [
        'condition' => Feature::hasTelephony(),
        'label' => _('Language Pack'),
        'parent' => 'menu.tabs.setup',
        'type' => 'pills',
    ],
    'languageuploadint' => [
        'desc' => _('Upload a custom language for GUI, voice messages') . (Feature::isPbx() ? _(' and supported IP phones.') : _('.')),
        'label' => _('Language Pack'), // Language Pack Upload
        'parent' => 'menu.pills.language',
        'type' => 'form',
    ],
    'ipphonescustomlanguage' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig() && Locale::isLanguagePackInstalled(),
        'desc' => _('Upload manufacturer\'s language pack for supported IP phones.'),
        'label' => _(''),
        'parent' => 'languageuploadint',
        'type' => 'hidden',
    ],
    'aastracustomlanguage' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'ipphonescustomlanguage',
    ],
    'snomcustomlanguage' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'ipphonescustomlanguage',
    ],
    'gscustomlanguage' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'ipphonescustomlanguage',
    ],
    'polycomcustomlanguage' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'ipphonescustomlanguage',
    ],
    //----------------------------------------------------------------------------------------------------
    // EXTENSIONS
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.extensions' => [
        'condition' => Feature::hasTelephony(),
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'extension',
        'icon' => 'fa fa-book',
        'label' => _('Extensions'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // OVERVIEW
    'extension/overview' => [
        'label' => _('Overview'),
        'parent' => 'menu.tabs.extensions',
        'type' => 'data',
    ],
    //--------------------
    // EXTENSIONS
    'menu.pills.extensions' => [
        'label' => _('Extensions'),
        'parent' => 'menu.tabs.extensions',
        'type' => 'pills',
    ],
    // Extensions
    'usermanagement' => [
        'desc' => _('View and manage all extensions.'),
        'label' => _('Extensions'),
        'parent' => 'menu.pills.extensions',
        'type' => 'grid',
    ],
    'usermanagementadd' => [
        'default' => true,
        'desc' => _('Create a single extension.'),
        'label' => _('Add Extension'),
        'parent' => 'menu.pills.extensions',
        'type' => 'form',
    ],
    'usermanagementadd?param=multiple_add' => [
        'condition' => Feature::isPbx(),
        'desc' => _('Add many extensions at once.'),
        'label' => _('Add Multiple Extensions'),
        'parent' => 'menu.pills.extensions',
        'type' => 'form',
    ],
    // bulk import
    'userexttemplatemgmt' => [
        'condition' => Feature::hasExtensionBulk(),
        'desc' => _('Add many extensions at once from a preconfigured list in CSV format.'),
        'label' => _('Bulk Import'),
        'parent' => 'menu.pills.extensions',
    ],
    'userexttemplateadd' => [
        'condition' => Feature::hasExtensionBulk(),
        'label' => _('Extensions Template Management - Add Entry'),
        'parent' => 'userexttemplatemgmt'
    ],
    'changeextlength' => [
        'label' => _('Extensions Length'),
        'parent' => 'usermanagement',
    ],
    // 1 General
    'usermgmtgensettings' => [
        'label' => _('General'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'form',
    ],
    'accesslist' => [
        'condition' => !Feature::isPhoneGateway(),
        'label' => _('Access List for Pickup or Paging Groups'),
        'parent' => 'usermgmtgensettings',
    ],
    'bargeinaccesslist' => [
        'label' => _('Call Intercept Access List'),
        'parent' => 'usermgmtgensettings',
        'selected' => 'extension',
    ],
    'pickupgroup' => [
        'condition' => !Feature::isPhoneGateway(),
        'label' => _('Edit Pickup Group'),
        'parent' => 'usermgmtgensettings',
    ],
    'watchaccesslist' => [
        'condition' => Feature::hasPresence(),
        'label' => _('Watch Access List'),
        'parent' => 'usermgmtgensettings',
        'selected' => 'extension',
    ],
    'childextensions' => [
        'condition' => Feature::isPbx(),
        'label' => _('Child Extension List'),
        'parent' => 'usermgmtgensettings',
        'selected' => 'extension',
    ],
    // 2 Attendant Scenario
    'usermgmtattendanttype' => [
        'extension_type' => 'attendant',
        'label' => _('Attendant Settings'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'hidden',
    ],
    'usermgmtscenariosettings' => [
        'extension_type' => 'attendant',
        'label' => _('Attendant Scenario'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'hidden',
    ],
    'usermgmtnonworkinghoursscenario' => [
        'condition' => Feature::isPbx(),
        'extension_type' => 'attendant',
        'label' => _('Scenario - Non-Working Hours'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'hidden',
    ],
    'usermgmtholidaysscenario' => [
        'condition' => Feature::isPbx(),
        'extension_type' => 'attendant',
        'label' => _('Scenario - Holidays'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'hidden',
    ],
    'usermgmtringingannouncement' => [
        'label' => _('Ringing Announcement'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'form',
    ],
    'uploadfileint' => [
        'label' => _('Attendant - Upload Custom Scenario Voice Messages'),
        'parent' => 'usermgmtscenariosettings',
    ],
    // SMS Group
    'smsgroups' => [
        'condition' => Feature::hasSms() && Feature::isPbx() && Feature::hasIpLines(),
        'desc' => _('SMS groups settings.'),
        'label' => _('SMS Groups'),
        'parent' => 'menu.pills.extensions',
        'type' => 'form',
    ],
    'smsgroupsadd' => [
        'condition' => Feature::hasSms(),
        'label' => _('SMS Groups Add'),
        'parent' => 'smsgroups',
    ],
    'smsgroupsedit' => [
        'condition' => Feature::hasSms(),
        'label' => _('SMS Groups Edit'),
        'parent' => 'smsgroups',
    ],
    // 3 SIP
    'usermgmtsipsettings' => [
        'extension_type' => 'all',
        'label' => _('SIP'),
        'selected' => 'extension',
        'parent' => $extension_parent,
        'type' => 'hidden',
    ],
    // 4 SIP Advanced
    'usermgmtsipadvsettings' => [
        'extension_type' => 'all',
        'label' => _('SIP Advanced'),
        'selected' => 'extension',
        'parent' => $extension_parent,
        'type' => 'hidden',
    ],
    // 5 Remote
    'usermgmtremotesettings' => [
        'condition' => Feature::hasSipLines(),
        'extension_type' => 'user',
        'label' => _('Remote'),
        'selected' => 'extension',
        'parent' => $extension_parent,
        'type' => 'hidden',
    ],
    // 6 Call Queue
    'usermgmtcallqueuesettings' => [
        'condition' => !Feature::isGateway(),
        'extension_type' => 'user',
        'label' => _('Call Queue'),
        'selected' => 'extension',
        'parent' => $extension_parent,
        'type' => 'hidden',
    ],
    // 7 Voice Mailbox
    'usermgmtvmsettings' => [
        'condition' => Feature::hasVoiceMailSystem(),
        'extension_type' => 'user',
        'label' => _('Voice Mailbox'),
        'selected' => 'extension',
        'parent' => $extension_parent,
        'type' => 'hidden',
    ],
    'voicemailboxaccess' => [
        'condition' => !Feature::isPhoneGateway(),
        'label' => _('Voice mailbox Access List - Add/Edit Entry'),
        'parent' => 'usermgmtvmsettings',
        'selected' => 'extension'
    ],
    // 8 Codec
    'usermgmtcodecsettings' => [
        'label' => _('Codec'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 9 ACD Group
    'usermgmtacdgroupsettings' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD Group'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 10 ACD Agents
    'usermgmtacdagenttable' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD Agents'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 11 Recording Box
    'usermgmtrecboxsettings' => [
        'condition' => Feature::hasRecording(),
        'label' => _('Recording Box'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 12 Recording Storage
    'usermgmtrecstoragesettings' => [
        'condition' => Feature::hasRecording(),
        'label' => _('Recording Storage'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 13 Call Park
    'usermgmtcallparksettings' => [
        'label' => _('Call Park'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 14 Call Retrieve
    'usermgmtcallretrievesettings' => [
        'label' => _('Call Retrieve'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    'usermgmtcallparkpagingadd' => [
        'label' => _('Add Extension'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    'usermgmtcallparkpagesettings' => [
        'label' => _('Parked Call Paging'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 15 Moderator Rights
    'usermgmtconfmoderatorrights' => [
        'label' => _('Moderator Rights'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 16 Class of Service
    'usermgmtclassservicesettings' => [
        'condition' => Feature::isPbx(),
        'label' => _('Class of Service'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 17 Credit Settings
    'usermgmtcreditsettings' => [
        'condition' => Feature::isPbx(),
        'label' => _('Credit Setting'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 18 Licensing
    'usermgmtlicensesettings' => [
        'condition' => !Feature::isGateway(),
        'extension_type' => 'user',
        'label' => _('Licensing'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'hidden',
    ],
    'usermgmtattcallhistory' => [
        'label' => _('Attendant Call History'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    // 19 CGI_USER_MGMT_RECORDING_SETTINGS         usermgmtrecordingbox            Go To Recording Box -->
    'usermgmtrecordingbox' => [
        'condition' => Feature::hasRecording(),
        'label' => _('Recording'),
        'parent' => $extension_parent,
        'selected' => 'extension',
    ],
    'usermgmtsmssettings' => [
        'condition' => Feature::hasSms(),
        'extension_type' => 'user',
        'label' => _('Direct Inward Messaging'),
        'parent' => $extension_parent,
        'selected' => 'extension',
        'type' => 'hidden',
    ],
    'usermanagementedit' => [
        'label' => _('Edit'),
        'selected' => 'extension',
        'parent' => $extension_parent,
    ],
    'callparkaccess' => [
        'label' => _('Call Park Access List - Add/Edit Entry'),
        'parent' => 'usermanagementedit',
    ],
    //--------------------
    // DIALING DIRECTORIES
    'menu.pills.dialdirectories' => [
        'label' => _('Dialing Directories'),
        'parent' => 'menu.tabs.extensions',
        'type' => 'pills',
    ],
    // dial by name directory
    'directoryservice' => [
        'condition' => Feature::isPbx(),
        'desc' => _('Configure dial-by-name directory used by the Auto Attendant.'),
        'label' => _('Dial by Name'),
        'parent' => 'menu.pills.dialdirectories',
        'type' => 'grid',
    ],
    'directoryserviceadd' => [
        'condition' => Feature::isPbx(),
        'label' => _('Directory Service - Add Entry'),
        'parent' => 'directoryservice',
        'type' => 'form',
    ],
    // speed dialing table
    'callrt?type=speed_dialing_table' => [
        'desc' => _('Common speed dial directory for all extensions.'),
        'label' => _('Global Speed Dial'),
        'parent' => 'menu.pills.dialdirectories',
        'type' => 'grid',
    ],
    // phone book
    'phonebookservice' => [
        'condition' => Feature::hasIpLinesAutoConfig(),
        'desc' => _('Configure Global Contact directory.'),
        'label' => _('Phone Book'),
        'parent' => 'menu.pills.dialdirectories',
        'type' => 'grid',
    ],
    'phonebookadd' => [
        'condition' => Feature::hasIpLinesAutoConfig(),
        'label' => _('Phone Book - Add Entry'),
        'parent' => 'phonebookservice',
        'type' => 'form',
    ],
    //--------------------
    // CONFERENCES
    'menu.pills.conferences' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Conferences'),
        'parent' => 'menu.tabs.extensions',
        'type' => 'pills',
    ],
    'userconferences' => [
        'condition' => Feature::hasConfServer(),
        'desc' => _('List conferences and access conference-specific settings pages.'),
        'label' => _('Conferences '),
        'parent' => 'menu.pills.conferences',
        'type' => 'grid',
    ],
    'usermanagementadd?ext_type=ExtType_Conference' => [
        'condition' => Feature::hasConfServer(),
        'desc' => _('Create a new conference ID.'),
        'label' => _('Add Conference'),
        'parent' => 'menu.pills.conferences',
        'type' => 'form',
    ],
    'emaildefaults' => [
        'condition' => Feature::hasConfServer(),
        'desc' => _('Configure notifications and activation E-mails for upcoming conference meetings.'),
        'label' => _('E-mail Settings'),
        'parent' => 'menu.pills.conferences',
        'type' => 'form',
    ],
    //--------------------
    // RECORDINGS
    'universal' => [
        'condition' => !Feature::isPhoneGateway(),
        'desc' => _('Configure Music on Hold and other system messages.'),
        'label' => _('Recordings'),
        'parent' => 'menu.tabs.extensions',
    ],
    //--------------------
    // RECEPTIONIST
    'menu.pills.receptionist' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('Receptionist'),
        'parent' => 'menu.tabs.extensions',
        'type' => 'pills',
    ],
    'receptionist' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'desc' => _('Configure IP phones with add-on modules for additional keys.'),
        'label' => _('Receptionist'),
        'parent' => 'menu.pills.receptionist',
        'type' => 'grid',
    ],
    'rpcwizard' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('RPC Wizard'),
        'parent' => 'receptionist',
        'type' => 'wizard',
    ],
    //--------------------
    // ACD
    'menu.pills.acd' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD'),
        'parent' => 'menu.tabs.extensions',
	'helproot' => 'acd', 
        'type' => 'pills',
    ],
    'acdmanagement?page=acd_groups' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Create ACD Queues and assigned agents.'),
        'label' => _('Queues'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    'acdgroupmgmt' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD Queue Management'),
        'parent' => 'acdmanagement?page=acd_groups',
    ],
    'acdqueueagenttable' => [
        'condition' => Feature::hasAcd(),
        'label' => _('Agents Table of Queue Technical Support'),
        'parent' => 'acdmanagement?page=acd_groups',
        'type' => 'hidden',
    ],
    'acdmanagement?page=acd_agents' => [
        'condition' => Feature::hasAcd(),
        'default' => true,
        'desc' => _('Configure each agent of the ACD.'),
        'label' => _('Agents'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    'acdagentmgmt' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD Agent Management'),
        'parent' => 'acdmanagement?page=acd_agents',
        'type' => 'form',
    ],
    'acdmanagement?page=acd_status' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Configure ACD Status Codes.'),
        'label' => _('Status Codes'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    'acdcustomstatusmgmt' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD Status Codes'),
        'parent' => 'acdmanagement?page=acd_status',
    ],
    'acdmanagement?page=acd_wrapupcodes' => [
        'condition' => Feature::hasAcd() && Feature::hasWAMP(),
        'desc' => _('Configure ACD Wrap-up Codes.'),
        'label' => _('Wrap-up Codes'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    'acdwrapupcodemgmt' => [
        'condition' => Feature::hasAcd() && Feature::hasWAMP(),
        'label' => _('Wrap-up Code Settings'),
        'parent' => 'acdmanagement?page=acd_wrapupcodes',
    ],
    // skill
    'acdmanagement?page=acd_skills' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Configure the list of skills used by ACD for skills based routing.'),
        'label' => _('Skills'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    'acdskillsmgmt' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD Skills Management'),
        'parent' => 'acdmanagement?page=acd_skills',
    ],
    // eac status
    'acdmanagement?page=eac_status' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Display logged in ACD agents into EAC.'),
        'label' => _('EAC Status'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    // backup setting
    'acdmanagement?page=settings' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Configure EAC backup settings.'),
        'label' => _('Backup Settings'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    // backup history
    'acdmanagement?page=arch_history' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Display EAC data backups list.'),
        'label' => _('Backup History'),
        'parent' => 'menu.pills.acd',
        'type' => 'grid',
    ],
    // acdmanagement
    'acdqueuescenario' => [
        'condition' => Feature::hasAcd(),
        'label' => _('ACD Management - Add Queue Message'),
        'parent' => 'acdmanagement?page=acd_groups',
    ],
    //--------------------
    // AOC
    'menu.pills.aoc' => [
        'condition' => Feature::hasAcd(),
        'label' => _('AOC'),
        'parent' => 'menu.tabs.extensions',
	'helproot' => 'aoc',
        'type' => 'pills',
    ],
    'aocmanagement?page=queues' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Create AOC Queues and assigned agents.'),
        'label' => _('Queues'),
        'parent' => 'menu.pills.aoc',
        'type' => 'grid',
    ],
    'acdgroupmgmt?prio=on' => [
        'condition' => Feature::hasAcd(),
        'label' => _('AOC Queue Management'),
        'parent' => 'aocmanagement?page=queues',
    ],
    'aocmanagement?page=users' => [
        'condition' => Feature::hasAcd(),
        'default' => true,
        'desc' => _('Configure each user of the AOC.'),
        'label' => _('Users'),
        'parent' => 'menu.pills.aoc',
        'type' => 'grid',
    ],
    'aocusermgmt' => [
        'condition' => Feature::hasAcd(),
        'label' => _('AOC User Management'),
        'parent' => 'aocmanagement?page=users',
        'type' => 'form',
    ],
    // eac status
    'aocmanagement?page=user_status' => [
        'condition' => Feature::hasAcd(),
        'desc' => _('Display logged in AOC users.'),
        'label' => _('AOC Status'),
        'parent' => 'menu.pills.aoc',
        'type' => 'grid',
    ],
    //--------------------
    // CRM Connect
    'menu.pills.crm' => [
        'condition' => Feature::hasCrmConnect(),
        'label' => _('CRM Connect'),
        'parent' => 'menu.tabs.extensions',
	'helproot' => 'crm',
        'type' => 'pills',
    ],
    'crmmanagement?page=users' => [
        'condition' => Feature::hasCrmConnect(),
        'default' => true,
        'desc' => _('Configure each user of the CRM connect.'),
        'label' => _('Users'),
        'parent' => 'menu.pills.crm',
        'type' => 'grid',
    ],
    'crmusermgmt' => [
        'condition' => Feature::hasCrmConnect(),
        'label' => _('CRM Connect Management'),
        'parent' => 'crmmanagement?page=users',
        'type' => 'form',
    ],
    // crm status
    'crmmanagement?page=user_status' => [
        'condition' => Feature::hasCrmConnect(),
        'desc' => _('Display logged in CRM Connect users.'),
        'label' => _('CRM Connect Status'),
        'parent' => 'menu.pills.crm',
        'type' => 'grid',
    ],
    //--------------------
    // VOICEMAILBOX
    'menu.pills.voicemailboxes' => [
        'condition' => Feature::hasVoicemailOwnService(),
        'label' => _('Voice MailBoxes'),
        'parent' => 'menu.tabs.extensions',
        'type' => 'pills',
    ],

    'vmmanagement' => [
        'desc' => _('View and manage all Voice Mailboxes.'),
        'label' => _('Voice Mailboxes'),
        'parent' => 'menu.pills.voicemailboxes',
        'type' => 'grid',
    ],
    'vmmanagementadd' => [
        'default' => true,
        'desc' => _('Create Voice Mailboxes.'),
        'label' => _('Add multiple Voice Mailboxes'),
        'parent' => 'menu.pills.voicemailboxes',
        'type' => 'form',
    ],
    'vmmgmtbulkupdate' => [
        'default' => true,
        'desc' => _('Bulk Add/Edit Voice MailBoxes'),
        'label' => _('Bulk Add/Edit Voice MailBoxes'),
        'parent' => 'menu.pills.voicemailboxes',
        'type' => 'form',
    ],
    'vmmgmtbulkremove' => [
        'default' => true,
        'desc' => _('Bulk Remove Voice MailBoxes'),
        'label' => _('Bulk Remove Voice MailBoxes'),
        'parent' => 'menu.pills.voicemailboxes',
        'type' => 'form',
    ],
    'vmmanagementedit' => [
        'label' => _('Edit'),
        'selected' => 'voicemailbox',
        'parent' => 'vmmanagement',
    ],
    // 1 General
    'vmmgmtgensettings' => [
        'label' => _('General'),
        'parent' => 'vmmanagement',
        'selected' => 'voicemailbox',
        'type' => 'form',
    ],
    'vmmgmtnotifysettings' => [
        'label' => _('Notification'),
        'parent' => 'vmmanagement',
        'selected' => 'voicemailbox',
        'type' => 'form',
    ],
    'vmmgmtredirectsettings' => [
        'label' => _('Redirect'),
        'parent' => 'vmmanagement',
        'selected' => 'voicemailbox',
        'type' => 'form',
    ],
    'vmmgmtoossettings' => [
        'label' => _('Out Of Service'),
        'parent' => 'vmmanagement',
        'selected' => 'voicemailbox',
        'type' => 'form',
    ],
    // 7 Voice Mailbox
    'vmmgmtvmsettings' => [
        'condition' => Feature::hasVoicemailOwnService(),
        'extension_type' => 'voicemailbox',
        'label' => _('Voice Mailbox'),
        'selected' => 'voicemailbox',
        'parent' => 'vmmanagement',
        'type' => 'hidden',
    ],

    'bulkupdresult' => [
        'action' => ['extension', 'bulkupd'],
        'label' => _('Bulk Add/Edit Voice MailBox extensions'),
        'parent' => 'vmmgmtbulkupdate',
        'type' => 'form',
    ],
    'extension/vmbadd-command' => [
        'label' => _('Voice MailBox Update'),
        'parent' => 'extension/vmmgmtbulkupdate',
        'type' => 'command',
    ],
    'bulkdelresult' => [
        'action' => ['extension', 'bulkdel'],
        'label' => _('Bulk Remove Voice MailBox extensions'),
        'parent' => 'vmmgmtbulkremove',
        'type' => 'form',
    ],
    'extension/vmbdel-command' => [
        'label' => _('Voice MailBox Update'),
        'parent' => 'extension/vmmgmtbulkremove',
        'type' => 'command',
    ],

    // Authorize Phones
    'autologin' => [
        'condition' => !Feature::isPhoneGateway(),
        'desc' => _(
            'Based on the caller ID, incoming calls to the Auto Attendant can be authorized to access an extension for features such as voice mail or call relay and call back.'
        ),
        'label' => _('Authorized Phones'),
        'parent' => 'menu.tabs.extensions',
        'type' => 'grid,form',
    ],
    //----------------------------------------------------------------------------------------------------
    // INTERFACES
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.interfaces' => [
        'condition' => Feature::hasTelephony(),
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'interfaces',
        'icon' => 'fa fa-puzzle-piece',
        'label' => _('Interfaces'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // OVERVIEW
    'interfaces/overview' => [
        'label' => _('Overview'),
        'parent' => 'menu.tabs.interfaces',
        'type' => 'data',
    ],
    //--------------------
    // IP LINES
    'menu.pills.iplines' => [
        'condition' => ( Feature::hasIpLines() && !Feature::isPstnGateway() ) || ( Feature::hasIpLines() && Feature::isPstnGateway( ) && FeatureUtils::hasAdditionalIPPhones( ) ),
        'label' => _('IP Lines'),
        'parent' => 'menu.tabs.interfaces',
        'type' => 'pills',
    ],
    // IP Lines
    'linesettings?page_id=1' => [ // iplines
        'desc' => _('Configure IP phones for each extension.'),
        'condition' => ( Feature::hasIpLines() && !Feature::isPstnGateway() ) || ( Feature::hasIpLines() && Feature::isPstnGateway( ) && FeatureUtils::hasAdditionalIPPhones( ) ),
        'label' => _('IP Lines'),
        'parent' => 'menu.pills.iplines',
        'type' => 'grid',
    ],

    // IP Line Settings    
    'linesettings?page_id=2' => [
        'desc' => _('Configure some general settings for IP phones.'),
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('IP Line Settings'),
        'parent' => 'menu.pills.iplines',
        'type' => 'form',
    ],
    'lineipsettingsadd' => [
        'condition' => Feature::hasIpLines(),
        'label' => _('IP Line Settings'),
        'parent' => 'linesettings?page_id=1',
        'type' => 'form',
    ],
    'iplinempksettings' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('IP Lines MPK'),
        'parent' => 'linesettings?page_id=1',
        'type' => 'form',
    ],
    'ipphoneadvsettings' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('IP Lines Advanced'),
        'parent' => 'linesettings?page_id=1',
        'type' => 'form',
    ],
    // IP Phone Templates
    'valueset' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'desc' => _('Create custom configuration templates for uploading to IP Phones.'),
        'label' => _('IP Phone Templates'),
        'parent' => 'menu.pills.iplines',
        'type' => 'grid',
    ],
    'valuesetadd' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('Phone Configuration - Add Template'),
        'parent' => 'valueset',
        'type' => 'form',
    ],
    'valuesetedit' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('Phone Configuration - Edit Settings'),
        'parent' => 'valueset',
    ],
    // IP Phones Logo
    'ipphoneslogo' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'desc' => _('Upload a custom logo for supported IP Phones.'),
        'label' => _('IP Phones Logo'),
        'parent' => 'menu.pills.iplines',
        'type' => 'form',
    ],
    // FXS Gateway
    'fxsgwmanagement' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'desc' => _('Configure an FXS Gateway to add more analog FXS ports.'),
        'label' => _('FXS Gateways'),
        'parent' => 'menu.pills.iplines',
        'type' => 'grid',
    ],
    'fxsgatewaywizard' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('FXS Gateway Wizard'),
        'parent' => 'fxsgwmanagement',
        'type' => 'wizard',
    ],
    'fxsgatewayedit' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('FXS Gateway Edit'),
        'parent' => 'fxsgatewaywizard',
        'type' => 'form, grid',
    ],
    // Eqall settings
    'eqallsettings' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'desc' => _('Configure eQall specific settings.'),
        'label' => _('eQall Settings'),
        'parent' => 'menu.pills.iplines',
        'type' => 'form',
    ],
    // FXS
    'menu.pills.fxs' => [
        'condition' => (!Feature::isPstnGateway() && Feature::hasFxs()),
        'label' => _('FXS'),
        'parent' => 'menu.tabs.interfaces',
        'type' => 'pills',
    ],
    // fxs
    'linesettings?page_id=0' => [
        'condition' => (!Feature::isPstnGateway() && Feature::hasFxs()),
        'desc' => _('Configure FXS ports for connecting basic analog phones or fax machines.'),
        'default' => true,
        'label' => _('FXS (On-board)'),
        'parent' => 'menu.pills.fxs',
        'type' => 'grid',
    ],
    'linesettingsadd' => [
        'condition' => (!Feature::isPstnGateway() && Feature::hasFxs()),
        'label' => _('Line Settings - Edit On-board Lines'),
        'parent' => 'linesettings?page_id=0',
        'type' => 'form',
    ],
    'linecontrol' => [
        'condition' => (!Feature::isPstnGateway() && Feature::hasFxs()) && !Feature::isConfigEmulator(),
        'desc' => _(
            'Diagnostics for incoming calls to automatically pick up on the first ring and loopback the voice to the caller.'
        ),
        'label' => _('Diagnostic Loopback'),
        'parent' => 'menu.pills.fxs',
        'type' => 'grid',
    ],
    // FXO
    'menu.pills.fxo' => [
        'condition' => Feature::hasFxo() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('FXO'),
        'parent' => 'menu.tabs.interfaces',
        'type' => 'pills',
    ],
    'fxo' => [
        'condition' => Feature::hasFxo() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'desc' => _(
            'Configure FXO ports connected via analog telephone lines to the Public Switched Telephone Network (PSTN).'
        ),
        'label' => _('FXO'),
        'parent' => 'menu.pills.fxo',
        'type' => 'grid,form',
    ],
    // E1 / T1
    'menu.pills.e1t1' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'desc' => _(
            'Configure E1 or T1 trunks connected to the Public Switched Telephone Network (PSTN).'
        ),
        'label' => _('E1/T1 Trunk'),
        'parent' => 'menu.tabs.interfaces',
        'type' => 'pills',
    ],
    'e1t1trunk' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'desc' => _(
            'Configure E1 or T1 trunks connected to the Public Switched Telephone Network (PSTN).'
        ),
        'label' => _('E1/T1 Trunk'),
        'parent' => 'menu.pills.e1t1',
    ],
    // isdn
    'menu.pills.isdn' => [
        'condition' => Feature::hasIsdn() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'desc' => _(
            'Configure ISDN BRI trunks connected to the Public Switched Telephone Network (PSTN).'
        ),
        'label' => _('ISDN Trunk'),
        'parent' => 'menu.tabs.interfaces',
        'type' => 'pills',
    ],
    'isdntrunk' => [
        'condition' => Feature::hasIsdn() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'desc' => _(
            'Configure ISDN BRI trunks connected to the Public Switched Telephone Network (PSTN).'
        ),
        'label' => _('ISDN Trunk'),
        'parent' => 'menu.pills.isdn',
        // TODO: fix this
    ],
    //----------
    // PSTN Gateways
    'menu.pills.pstngateways' => [
        'condition' => Feature::hasPstnExAutoConfig(),
        'label' => Feature::isPbx() ? _('PSTN Gateways') : _('PSTN Lines Sharing'),
        'parent' => 'menu.tabs.interfaces',
        'type' => 'pills',
    ],
    'pstngwoperationmode' => [
        'condition' => Feature::isPstnGateway(),
        'default' => true,
        'desc' => _('Select PSTN Gateway operation mode.'),
        'label' => _('PSTN Gateway Operation Mode'),
        'parent' => 'menu.pills.pstngateways',
        'type' => 'form',
    ],
    'operationmode' => [
        'condition' => Feature::hasPstnExAutoConfig(),
        'default' => true,
        'desc' => Feature::isPbx() ? _(
            'Allows trunks/lines of the E1/T1, ISDN BRI or FXO Gateways to be shared with the PBX.'
        ) : _('Allows trunks/lines of this device to be shared with PBX/PSTN Gateway.'),
        'label' => Feature::isPbx() ? _('PSTN Gateways') : _('PSTN Lines Sharing'),
        'parent' => 'menu.pills.pstngateways',
        'type' => 'form',
    ],
    //----------------------------------------------------------------------------------------------------
    // INTERFACES - LEVEL 3+
    //----------------------------------------------------------------------------------------------------
    // e1t1trunk
    'cassignaling' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('Trunk Timeslots CAS Settings'),
        'parent' => 'e1t1trunk',
        'type' => 'hidden',
    ],
    'cassigwizard' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('CAS Signaling Wizard'),
        'parent' => 'e1t1trunk',
    ],
    'ccssignaling' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('Trunk Timeslots CSS Settings'),
        'parent' => 'e1t1trunk',
        'type' => 'hidden',
    ],
    'dnisservice' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('E1/T1 Incoming Interdigit Service'),
        'parent' => 'e1t1trunk',
    ],
    'didservice' => [
        'condition' => Feature::hasIsdn() || Feature::hasE1T1() || (Feature::hasPstnExAutoConfig() && Feature::isPbx() ),
        'label' => _('E1/T1 DID Service'),
        'parent' => 'e1t1trunk',
    ],
    'e1t1stat' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('E1/T1 Status'),
        'parent' => 'e1t1trunk',
    ],
    // isdntrunk
    'isdnnetworkmode' => [
        'condition' => Feature::hasIsdn(),
        'label' => _('ISDN Network Mode'),
        'parent' => 'isdntrunk',
    ],
    'isdnstat' => [
        'condition' => Feature::hasIsdn(),
        'label' => _('ISDN Status'),
        'parent' => 'isdntrunk',
    ],
    'isdnsuspendresume' => [
        'condition' => Feature::hasIsdn() || Feature::hasE1T1(),
        'label' => _(''),
        'parent' => 'isdntrunk',
    ],
    'isdnwizard' => [
        'condition' => Feature::hasIsdn() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('ISDN Wizard'),
        'parent' => 'isdntrunk',
        'type' => 'wizard',
    ],
    'dnisservice?type=isdn' => [
        'condition' => Feature::hasIsdn() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('ISDN Incoming Interdigit Service'),
        'parent' => 'isdntrunk',
    ],
    //----------------------------------------------------------------------------------------------------
    // TELEPHONY
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.telephony' => [
        'condition' => Feature::hasTelephony(),
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::SUPERADMIN,
        'helproot' => 'telephony',
        'icon' => 'fa fa-phone',
        'label' => _('Telephony'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    // OVERVIEW
    'telephony/overview' => [
        'label' => _('Overview'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'data',
    ],
    // VOIP CARRIER WIZARD
    'voipcarrierwizard' => [
        'condition' => !Feature::isPhoneGateway(),
        'desc' => _('Easily configure the SIP trunking account from the Internet Telephony Service Provider (ITSP).'),
        'label' => _('VoIP Carrier'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'wizard',
    ],
    // CALL ROUTING
    'menu.telephony.callrouting.callrouting' => [
        'label' => _('Call Routing'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'pills',
    ],
    'routingmanagement' => [
        'desc' => _('Define the destination for dialed digit patterns and set up options for call routes.'),
        'label' => _('Call Routing Table'),
        'parent' => 'menu.telephony.callrouting.callrouting',
        'type' => 'grid',
    ],
    'lcrwizard' => [
        'label' => _('Call Routing Wizard'),
        'parent' => 'routingmanagement',
        'type' => 'wizard',
    ],
    'callrt' => [
        'default' => true,
        'desc' => _('Send all incoming SIP calls to the Call Routing table.'),
        'label' => _('Call Routing'),
        'parent' => 'menu.telephony.callrouting.callrouting',
        'type' => 'form',
    ],
    'callrt?type=pstn_user_reg_table' => [
        'desc' => _(
            'Authentication table used with Call Routing for callers to pass authorization before being allowed to call out.'
        ),
        'label' => _('Local AAA Table'),
        'parent' => 'menu.telephony.callrouting.callrouting',
        'type' => 'grid',
    ],
    'routingserverreg' => [
        'condition' => Feature::hasRoutingServer(),
        'label' => _(''),
        'parent' => 'callrt',
        'type' => 'hidden',
    ],
    'routingsynchronization' => [
        'condition' => Feature::hasRoutingServer(),
        'label' => _(''),
        'parent' => 'routingserverreg',
        'type' => 'hidden',
    ],
    'rmmoveto' => [
        'label' => _('Call Routing - Move To'), // Call Routing Table - Move Routing Record
        'parent' => 'callrt',
        'type' => 'hidden',
    ],
    'siptrunksettings' => [
        'condition' => Feature::hasSipTrunk(),
        'desc' => _(
            'Create a SIP Tunnel between two locations (best usage is to register a site with a Dynamic IP address to a site with a static IP address).'
        ),
        'label' => _('SIP Tunnel'),
        'parent' => 'menu.telephony.callrouting.callrouting',
        'type' => 'form,grid',
    ],
    'classservice' => [
        'condition' => Feature::isPbx(),
        'desc' => _(
            'Create Class of Service names that can be assigned to extensions to match rules in the Call Routing table.'
        ),
        'label' => _('Class of Service'),
        'parent' => 'menu.telephony.callrouting.callrouting',
        'type' => 'grid,form',
    ],
    // CALL RECORDING
    'callrecordingsettings' => [
        'condition' => Feature::hasRecording(),
        'desc' => _('Configure recording parameters and enable call recording for the extensions.'),
        'label' => _('Call Recording'),
        'parent' => 'menu.tabs.telephony',
    ],
    // NAT TRAVERSAL
    'menu.pills.nattraversal' => [
        'label' => _('NAT Traversal'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'pills',
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::SUPERADMIN,
    ],
    'nattraversal?page=general' => [
        'default' => true,
        'desc' => _('NAT options needed to make external SIP calls on the internet when on a private network.'),
        'label' => _('General'),
        'parent' => 'menu.pills.nattraversal',
        'type' => 'form',
    ],
    'nattraversal?page=sip' => [
        'desc' => _(
            'Configure NAT traversal settings for SIP messages.'
        ),
        'label' => _('SIP Parameters'),
        'parent' => 'menu.pills.nattraversal',
        'type' => 'form',
    ],
    'nattraversal?page=rtp' => [
        'desc' => _(
            'Configure NAT traversal settings for RTP packets (voice and video).'
        ),
        'label' => _('RTP Parameters'),
        'parent' => 'menu.pills.nattraversal',
        'type' => 'form',
    ],
    'nattraversal?page=stun' => [
        'desc' => _('Configure STUN server settings used for automatic NAT traversal.'),
        'label' => _('STUN Parameters'),
        'parent' => 'menu.pills.nattraversal',
        'type' => 'form',
    ],
    'nattraversal?page=nat_excl' => [
        'desc' => _(
            'IP adresses and subnets to exclude from NAT traversal (needed for local or VPN connected subnets).'
        ),
        'label' => _('Exceptions'),
        'parent' => 'menu.pills.nattraversal',
        'type' => 'grid,form',
    ],
    'nattraversal?page=http' => [
        'desc' => _(
            'Configure NAT traversal settings for Auto-provisioning.'
        ),
        'label' => _('Auto-provisioning Parameters'),
        'parent' => 'menu.pills.nattraversal',
        'type' => 'form',
    ],
    // RTP
    'rtp' => [
        'desc' => _('Choose voice and video codecs or modify RTP port range used on this device.'),
        'label' => _('RTP'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'form,grid',
    ],
    // SIP
    'menu.pills.sip' => [
        'label' => _('SIP'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'pills',
    ],
    // sip
    'sip' => [
        'desc' => _('Configure SIP ports and other general SIP settings.'),
        'label' => _('SIP'),
        'parent' => 'menu.pills.sip',
        'type' => 'form',
    ],
    // sip aliases
    'sipaliases' => [
        'desc' => _('DNS Hostnames to recognize when receiving SIP messages by hostname instead of IP.'),
        'label' => _('SIP Aliases'),
        'parent' => 'menu.pills.sip',
        'type' => 'grid',
    ],
    'sipaliasesadd' => [
        'label' => _('SIP Aliases - Add/Edit'),
        'parent' => 'sipaliases',
        'type' => 'form',
    ],
    // tls certificates
    'sipgentlscerts' => [
        'condition' => Feature::hasTlsSupport(),
        'desc' => _('Generate and install new TLS Certificate or download current one.'),
        'label' => _('TLS Certificates'),
        'parent' => 'menu.pills.sip',
        'type' => 'form',
    ],
    // Schedules
    'menu.pills.scheduler' => [
        'condition' => (Feature::isPbx() && !Feature::isPhoneGateway()),
        'label' => _('Schedules'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'pills',
    ],
    'schedules' => [
        'condition' => (Feature::isPbx() && !Feature::isPhoneGateway()),
        'desc' => _('Schedules Settings.'),
        'label' => _('Schedules'),
        'parent' => 'menu.pills.scheduler',
         'type' => 'grid,form',
    ],
    'holidays' => [
        'condition' => Feature::isPbx(),
        'desc' => _('Holidays Settings.'),
        'label' => _('Holidays'),
        'parent' => 'menu.pills.scheduler',
         'type' => 'grid,form',
    ],
    'specialdays' => [
         'condition' => Feature::isPbx(),
         'desc' => _('Special Days.' ),
         'parent' => 'schedules',
         'type' => 'grid,form',
     ],
    // ADVANCED
    'menu.pills.advanced' => [
        'label' => _('Advanced'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'pills',
    ],
    // voice mail common settings
    'vmcs' => [
        'condition' => Feature::hasVoiceMailSystem(),
        'desc' => _('Define the voice mail and fax storage method and E-mail notification settings.'),
        'label' => _('Voice Mail'),
        'parent' => 'menu.pills.advanced',
        'type' => 'form',
    ],
    // audio streaming channels
    'rtpchannelmgmt' => [
        'condition' => Feature::isPbx() || Feature::isPstnGateway(),
        'desc' => _('Assign channel names to RTP audio streams emitted by the Epygi Media Streamer application.'),
        'label' => _('RTP Streaming Channels'),
        'parent' => 'menu.pills.advanced',
        'type' => 'grid,form',
    ],
    'ems' => [
        'condition' => Feature::hasMediaStreamer(),
        'desc' => _('Configure Media Streamer to stream audio file(s) to the RTP destinations.'),
        'label' => _('Media Streamer'),
        'parent' => 'menu.pills.advanced',
        'type' => 'grid,form',
    ],

    'emspl' => [
        'condition' => Feature::hasMediaStreamer(),
        'label' => _('Media Streamer Play List - Add/Edit'),
        'parent' => 'ems',
    ],

    // gain control
    'codecgaincontrol' => [
        'desc' => _(
            'Control transmit/receive levels of audio interface ports and recording/playback level of voice mails.'
        ),
        'label' => _('Gain Control'),
        'parent' => 'menu.pills.advanced',
        'type' => 'form',
    ],
    // 3PCC
    '3pcc' => [
        'desc' => _(
            'Adjust Third Party Call Controlling (3PCC) settings. Controlling applications to remotely initiate and handle calls and subscribe to event notifications.'
        ),
        'condition' => Feature::has3pcc(),
        'label' => _('3PCC'),
        'parent' => 'menu.pills.advanced',
        'type' => 'form',
    ],
    'radiussettings' => [
        'condition' => Feature::hasRadiusClient(),
        'desc' => _('External RADIUS server connection settings.'),
        'label' => _('Radius Client'),
        'parent' => 'menu.pills.advanced',
        'type' => 'form',
    ],
    'dialtimeouts' => [
        'desc' => _('Define timeout before sending dialed digits for call processing.'),
        'label' => _('Dial Timeout'),
        'parent' => 'menu.pills.advanced',
        'type' => 'form',
    ],
    'qosnotification' => [
        'desc' => _('Notify the user when the call quality falls below the specified threshold.'),
        'label' => _('Call Quality Notification'),
        'parent' => 'menu.pills.advanced',
        'type' => 'form',
    ],
    // presence states
    'presencestates' => [
        'desc' => _('Configure Presence Status'),
        'label' => _('Presence Status'),
        'parent' => 'menu.pills.advanced',
        'type' => 'form',
    ],
    'systemhold' => [
        'condition' => Feature::isPstnGateway(),
        'desc' => _('This service allows to configure hold music settings for the system'),
        'label' => _('Hold Music'),
        'parent' => 'menu.pills.advanced',
    ],
    'keysystememul' => [
        'condition' => Feature::hasKeySystemEmulation(),
        'desc' => _('This service allows to configure connected lines with the keys on your phone'),
        'label' => _('Key System Emulation'),
        'parent' => 'menu.pills.advanced',
    ],
    'slasupservices' => [
        'condition' => Feature::hasKeySystemEmulation(),
        'label' => _('Edit SLA\'s Advanced Services'),
        'parent' => 'keysystememul',
    ],
    'keysystemadv' => [
        'condition' => Feature::hasKeySystemEmulation(),
        'label' => _('Key System Advanced Settings'),
        'parent' => 'keysystememul',
    ],

    // WebRTC
    'menu.pills.webrtc' => [
	'condition' => Feature::isEnabledWebRtcGateway(),
        'label' => _('WebRTC'),
        'parent' => 'menu.tabs.telephony',
        'type' => 'pills',
    ],
    'webrtcc2c' => [
    	'condition' => Feature::isEnabledWebRtcGateway(),
        'desc' => _(
            'WebRTC Click to call database.'
        ),
        'label' => _('Click to call'),
        'parent' => 'menu.pills.webrtc',
        'type' => 'form',
    ],
    'webrtcgwsettings' => [
        'condition' => (Feature::isEnabledWebRtcGateway()),
        'desc' => _(
            'WebRTC gateway settings.'
        ),
        'label' => _('WebRTC gateway settings'),
        'parent' => 'menu.pills.webrtc',
        'type' => 'form',
    ],


    //----------------------------------------------------------------------------------------------------
    // FIREWALL
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.firewall' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'condition' => Feature::hasFirewall(),
        'helproot' => 'firewall',
        'icon' => 'icon-fire',
        'label' => _('Firewall'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    // OVERVIEW
    'firewall/overview' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('Overview'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'data',
    ],
    // FIREWALL
    'menu.pills.firewall' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('Firewall'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'pills',
    ],
    'firewall' => [
        'condition' => Feature::hasFirewall(),
        'desc' => !Feature::hasCloudOwnService() ? _('Enable NAT and firewall, choose the protection level.') : _('Enable firewall, choose the protection level.'),
        'label' => Feature::hasNatRouter() ? _('Firewall / NAT') : _('Firewall'),
        'parent' => 'menu.pills.firewall',
        'type' => 'form',
    ],
    'advancedfwsettings' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Enable device to deny ping and portscanner operations.'),
        'label' => _('Advanced'),
        'parent' => 'menu.pills.firewall',
        'type' => 'form',
    ],
    'idslog' => [
        'condition' => Feature::hasIds(),
        'desc' => _(
            'Intrusion Detection System (IDS) logs. Monitor for suspicious network activity on the WAN port.'
        ),
        'label' => _('IDS Log'),
        'parent' => 'menu.pills.firewall',
        'type' => 'grid',
    ],
    // FILTER
    'menu.pills.filter' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('Filtering Rules'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'pills',
    ],
    'filter?ChainName=All' => [
        'condition' => Feature::hasFirewall(),
        'default' => true,
        'desc' => _('List of all defined firewall rules.'),
        'label' => _('View All'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filter?ChainName=ServiceForIn' => [
        'condition' => (Feature::hasFirewall() && Feature::hasNatRouter()),
        'desc' => _('Forward external service or port number to internal IP address and port.'),
        'label' => _('Incoming/Forwarding'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filter?ChainName=ServiceForOut' => [
        'condition' => (Feature::hasFirewall() && Feature::hasNatRouter()),
        'desc' => _('Allow or deny outgoing traffic from LAN to Internet.'),
        'label' => _('Outgoing'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filter?ChainName=ServiceIn' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Allow management access from specific hosts.'),
        'label' => _('Management Access'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filter?ChainName=ServiceCCA' => [
        'condition' => Feature::hasFirewall() && Feature::has3pcc(),
        'desc' => _('Create the list of hosts having access to the Third Party Call Control interface on this device.'),
        'label' => _('Call Control Access'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filter?ChainName=ServiceSip' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Allow or block access to the SIP services on this device.'),
        'label' => _('SIP Access'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filter?ChainName=ServiceBlocked' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('List of hosts whose access to any services on this device is blocked.'),
        'label' => _('Blocked IPs'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filter?ChainName=ServiceAllowed' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('List of hosts having access to all services on this device.'),
        'label' => _('Allowed IPs'),
        'parent' => 'menu.pills.filter',
        'type' => 'grid',
    ],
    'filteradd' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('Add/Edit Filtering Rules'),
        'parent' => 'filter?ChainName=All',
        'type' => 'form',
    ],
    // SERVICE POOL
    'servicepool' => [
        'desc' => _('Define the service names associated with the external ports.'),
        'condition' => Feature::hasFirewall() && Feature::hasNatRouter(),
        'label' => _('Custom Services'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'grid,form',
    ],
    // IP POOL
    'menu.pills.ippool' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Group IP addresses with names (aliases) for easier use in filtering rules.'),
        'label' => _('IP Groups'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'pills',
    ],
    'ippool' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Group IP addresses with names (aliases) for easier use in filtering rules.'),
        'label' => _('IP Groups'),
        'parent' => 'menu.pills.ippool',
        'type' => 'grid',
    ],
    'ippooladd' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('IP Pool Group Configuration - Add/Edit Member'),
        'parent' => 'ippool',
        'type' => 'grid',
    ],
    'menu.pills.security_management' => [
        'desc' => _('Enable SIP Intrusion Detection System (IDS) to help preventing SIP attacks.'),
        'label' => _('SIP IDS'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'pills',
    ],
    'security?SecurityPageState=SIPIDSSettings' => [
        'desc' => _('Enable SIP Intrusion Detection System (IDS) to help preventing SIP attacks.'),
        'label' => _('SIP IDS'),
        'parent' => 'menu.pills.security_management',
        'type' => 'form',
    ],
    'sipidsexceptions' => [
        'label' => _('SIP IDS Exceptions'),
        'parent' => 'security?SecurityPageState=SIPIDSSettings',
        'type' => 'grid,form',
    ],
    // FILTER IPV6
    'menu.pills.filteripv6' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('Filtering Rules IPv6'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'pills',
        'collapsible' => 'true',
    ],
    'filteripv6?ChainName=All' => [
        'condition' => Feature::hasFirewall(),
        'default' => true,
        'desc' => _('List of all defined firewall rules.'),
        'label' => _('View All'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteripv6?ChainName=ServiceForIn' => [
        'condition' => (Feature::hasFirewall() && Feature::hasNatRouter()),
        'desc' => _('Forward external service or port number to internal IP address and port.'),
        'label' => _('Incoming/Forwarding'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteripv6?ChainName=ServiceForOut' => [
        'condition' => (Feature::hasFirewall() && Feature::hasNatRouter()),
        'desc' => _('Allow or deny outgoing traffic from LAN to Internet.'),
        'label' => _('Outgoing'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteripv6?ChainName=ServiceIn' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Allow management access from specific hosts.'),
        'label' => _('Management Access'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteripv6?ChainName=ServiceCCA' => [
        'condition' => Feature::hasFirewall() && Feature::has3pcc(),
        'desc' => _('Create the list of hosts having access to the Third Party Call Control interface on this device.'),
        'label' => _('Call Control Access'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteripv6?ChainName=ServiceSip' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Allow or block access to the SIP services on this device.'),
        'label' => _('SIP Access'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteripv6?ChainName=ServiceBlocked' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('List of hosts whose access to any services on this device is blocked.'),
        'label' => _('Blocked IPs'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteripv6?ChainName=ServiceAllowed' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('List of hosts having access to all services on this device.'),
        'label' => _('Allowed IPs'),
        'parent' => 'menu.pills.filteripv6',
        'type' => 'grid',
    ],
    'filteraddipv6' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('Add/Edit Filtering Rules'),
        'parent' => 'filteripv6?ChainName=All',
        'type' => 'form',
    ],
    // IP POOL IPv6
    'menu.pills.ippoolipv6' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Group IP addresses with names (aliases) for easier use in filtering rules.'),
        'label' => _('IPv6 Groups'),
        'parent' => 'menu.tabs.firewall',
        'type' => 'pills',
        'collapsible' => 'true',
    ],
    'ippoolipv6' => [
        'condition' => Feature::hasFirewall(),
        'desc' => _('Group IP addresses with names (aliases) for easier use in filtering rules.'),
        'label' => _('IP Groups'),
        'parent' => 'menu.pills.ippoolipv6',
        'type' => 'grid',
    ],
    'ippooladdipv6' => [
        'condition' => Feature::hasFirewall(),
        'label' => _('IP Pool Group Configuration - Add/Edit Member'),
        'parent' => 'ippoolipv6',
        'type' => 'grid',
    ],
    //----------------------------------------------------------------------------------------------------
    // NETWORK
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.network' => [
        'condition' => Feature::hasTelephony(),
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'network',
        'icon' => 'fa fa-globe',
        'label' => _('Network'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    // OVERVIEW
    'network/overview' => [
        'label' => _('Overview'),
        'parent' => 'menu.tabs.network',
        'type' => 'data',
    ],
    
    // Second LAN
    'menu.pills.secondlan' => [
        'condition' => Feature::isPc() && !Feature::isHosted(),
        'label' => _('Second LAN'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],

    'secondlaninterface' => [
        'condition' => Feature::isPc() && !Feature::isHosted(),
        'desc' => _('Activate and configure the Second LAN Interface.'),
        'label' => _('Second LAN'),
        'parent' => 'menu.pills.secondlan',
        'type' => 'form',
    ],

    'cloudnetwork' => [
        'condition' => Feature::isPc() && Feature::hasCloudOwnService(),
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::SUPERADMIN,
        'desc' => _('Activate and configure the IPv4 IPv6 address'),
        'label' => _('Cloud Network'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],

    'schedulevoicerestart' => [
        'desc' => _('Start Schedule Voice Restart Detection'),
        'label' => _('Schedule Voice Restart'),
        'parent' => 'internal',
    ],

    'robustnetwork' => [
        'condition' => Feature::isSunxi(),
        'desc' => _('Start Network Freeze Detection'),
        'label' => _('Robust Network'),
        'parent' => 'internal',
    ],

    'watchdog' => [
        'condition' => Feature::isSunxi(),
        'desc' => _('Enable/Disable Watchdog'),
        'label' => _('Watchdog Support'),
        'parent' => 'internal',
    ],
    
    
    // IP ROUTING
    'menu.pills.iprouting' => [
        'label' => _('IP Routing'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    'iprouting?routingpage=0' => [
        'default' => true,
        'desc' => _(
            'Configure static IP Routes (for forwarding the IP packets from the network to the specified destination, via specified IP address).'
        ),
        'label' => _('IP Static Routes'),
        'parent' => 'menu.pills.iprouting',
        'type' => 'grid',
    ],
    'editstaticroute' => [
        'label' => _('Static Route'),
        'parent' => 'iprouting?routingpage=0',
        'type' => 'form',
    ],
    'iprouting?routingpage=1' => [
        'desc' => _(
            'Configure IP Policy Routes (for forwarding the IP packets from the specified source, via specified IP address).'
        ),
        'label' => _('IP Policy Routes'),
        'parent' => 'menu.pills.iprouting',
        'type' => 'grid',
    ],
    'editpolicyroute' => [
        'label' => _('Policy Route'),
        'parent' => 'iprouting?routingpage=1',
        'type' => 'form',
    ],
    'iprouting?routingpage=2' => [
        'condition' => (Feature::hasVpn() && FeatureUtils::isPPTPEnabled()),
        'desc' => _('Configure PPTP/L2TP Routes (for forwarding the IP packets through the PPTP and L2TP tunnels).'),
        'label' => _('PPTP/L2TP Routes'),
        'parent' => 'menu.pills.iprouting',
        'type' => 'grid',
    ],
    'editvpnroute' => [
        'condition' => Feature::hasVpn() && !Feature::isPc(),
        'label' => _('PPTP/L2TP Route'),
        'parent' => 'iprouting?routingpage=2',
        'type' => 'form',
    ],
    'iprouting?routingpage=3' => [
        'desc' => _(
            'Configure static IPv6 Routes (for forwarding the IP packets from the network to the specified destination, via specified IPv6 address).'
        ),
        'label' => _('IPv6 Static Routes'),
        'parent' => 'menu.pills.iprouting',
        'type' => 'grid',
    ],
    'editstaticroute?inet=6' => [
        'label' => _('Static Route'),
        'parent' => 'iprouting?routingpage=3',
  		'type' => 'form',
    ],
    // DHCP
    'menu.pills.dhcp' => [
        'condition' => !Feature::hasCloudOwnService(),
        'label' => _('DHCP'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    'dhcp' => [
        'condition' => !Feature::hasCloudOwnService(),
        'desc' => _('Enable the DHCP Server and choose the dynamic IP address range to assign to clients.'),
        'label' => _('DHCP Server'), // DHCP Settings for the LAN Interface
        'parent' => 'menu.pills.dhcp',
        'type' => 'grid,form',
    ],
    'dhcphostadd' => [
        'condition' => !Feature::hasCloudOwnService(),
        'label' => _('DHCP Settings for the LAN Interface - Add/Edit Host'),
        'parent' => 'dhcp',
        'type' => 'form',
    ],
    'dhcpoptions' => [
        'condition' => !Feature::hasCloudOwnService(),
        'label' => _('DHCP Options Advanced Configuration'),
        'parent' => (!Feature::hasVlan() || strpos(
                Mvc\Param::server('QUERY_STRING'),
                "type=vlan"
            ) === false) ? 'dhcp' : 'dhcpvlan',
        'type' => 'grid,form',
    ],
    'dhcp-leases' => [
        'condition' => !Feature::hasCloudOwnService(),
        'desc' => _('List of DHCP IP addresses and host names provided by the DHCP Server.'),
        'label' => _('DHCP Leases'),
        'parent' => 'menu.pills.dhcp',
        'type' => 'grid',
    ],
    'dhcpvlan' => [
        'condition' => !Feature::hasCloudOwnService() && Feature::hasVlan(),
        'desc' => _('Configure DHCP Server settings for VLAN interfaces.'),
        'label' => _('DHCP for VLAN'),
        'parent' => 'menu.pills.dhcp',
    ],
    // DHCPv6
    'menu.pills.dhcpv6' => [
        'condition' => !Feature::hasCloudOwnService(),
        'label' => _('DHCPv6'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    'dhcpv6' => [
        'condition' => !Feature::hasCloudOwnService(),
        'desc' => _('Enable the DHCPv6 Server and choose the dynamic IPv6 address range to assign to clients.'),
        'label' => _('DHCPv6 Server'), // DHCPv6 Settings for the LAN Interface
        'parent' => 'menu.pills.dhcpv6',
        'type' => 'grid,form',
    ],
    'dhcpv6hostadd' => [
        'condition' => !Feature::hasCloudOwnService(),
        'label' => _('DHCPv6 Settings for the LAN Interface - Add/Edit Host'),
        'parent' => 'dhcpv6',
        'type' => 'form',
    ],
    'dhcpv6options' => [
        'condition' => !Feature::hasCloudOwnService(),
        'label' => _('DHCPv6 Options Advanced Configuration'),
        'parent' => (!Feature::hasVlan() || strpos(
                Mvc\Param::server('QUERY_STRING'),
                "type=vlan"
            ) === false) ? 'dhcpv6' : 'dhcpv6vlan',
        'type' => 'grid,form',
    ],
	'dhcpv6-leases' => [
        'condition' => !Feature::hasCloudOwnService(),
        'desc' => _('List of DHCPv6 IPv6 addresses and host names provided by the DHCPv6 Server.'),
        'label' => _('DHCPv6 Leases'),
        'parent' => 'menu.pills.dhcpv6',
        'type' => 'grid',
    ],
    // DNS
    'menu.pills.dns' => [
        'label' => _('DNS'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    'dns' => [
        'desc' => _('Configure service provider DNS settings to resolve DNS addresses.'),
        'label' => _('DNS'),
        'parent' => 'menu.pills.dns',
        'type' => 'form',
    ],
    'dnsserver' => [
        'condition' => Feature::hasDnsServer(),
        'desc' => _('Configure DNS services for LAN connected hosts.'),
        'label' => _('DNS Server'),
        'parent' => 'menu.pills.dns',
        'type' => 'form,grid',
    ],
    'dnsserveradd' => [
        'condition' => Feature::hasDnsServer(),
        'label' => _('DNS Server Settings - Add/Edit Host'),
        'parent' => 'dnsserver',
        'type' => 'form',
    ],
    'dyndns' => [
        'condition' => Feature::hasDynDns(),
        'desc' => _('Configure Dynamic DNS (DynDNS) service for mapping a dynamic IP address to a host name.'),
        'label' => _('Dynamic DNS'),
        'parent' => 'menu.pills.dns',
        'type' => 'form',
    ],
    // PPP/PPTP
    'menu.pills.provider' => [
        'condition' => Feature::hasPpp(),
        'label' => _('PPP/PPTP'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    'provider' => [
        'condition' => Feature::hasPpp(),
        'desc' => _('Configure PPP/PPTP connection basic settings.'),
        'label' => _('PPP/PPTP'),
        'parent' => 'menu.pills.provider',
        'type' => 'form',
    ],
    'ppp' => [
        'condition' => Feature::hasPpp(),
        'desc' => _('Configure PPP/PPTP connection advanced settings.'),
        'label' => _('Advanced PPP'),
        'parent' => 'menu.pills.provider',
        'type' => 'form',
    ],
    // SNMP
    'menu.pills.snmp' => [
        'condition' => Feature::hasSnmp(),
        'label' => _('SNMP'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    'snmpconfig?page=0' => [
        'default' => true,
        'desc' => _('Configure contact details for network management server.'),
        'label' => _('Global SNMP'),
        'parent' => 'menu.pills.snmp',
        'type' => 'form',
    ],
    'snmpconfig?page=1' => [
        'desc' => _('Defines the traphost and SNMP protocol version.'),
        'label' => _('SNMP Trap'),
        'parent' => 'menu.pills.snmp',
        'type' => 'grid',
    ],
    'edittrap' => [
        'label' => _('SNMP Trap'),
        'parent' => 'snmpconfig?page=1',
        'type' => 'form',
    ],
    // VLAN
    'menu.pills.vlan' => [
        'condition' => Feature::hasVlan() && !Feature::isHosted(),
        'label' => _('VLAN'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    // vlan
    'vlansettings' => [
        'condition' => Feature::hasVlan() && !Feature::isHosted(),
        'desc' => _('Configure VLANs on the LAN or WAN and assign IP address to the interface.'),
        'label' => _('VLAN'),
        'parent' => 'menu.pills.vlan',
        'type' => 'grid,form',
    ],
    // VPN
    'menu.pills.vpn' => [
        'condition' => Feature::hasVpn(),
        'label' => _('VPN'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],
    'ipsec' => [
        'condition' => Feature::hasVpn(),
        'desc' => _('Establish VPN connection using Internet Protocol Security (IPSec).'),
        'label' => _('IPSec'),
        'parent' => 'menu.pills.vpn',
        'type' => 'form,grid',
    ],
    'ipsecwizard' => [
        'condition' => Feature::hasVpn(),
        'label' => _('IPSec'),
        'parent' => 'ipsec',
        'type' => 'wizard',
    ],
    'pptpl2tp' => [
        'condition' => Feature::hasVpn() && !Feature::isPc(),
        'desc' => _('Establish VPN connection using Point-To-Point (PPTP) or Layer 2 Tunneling Protocol (L2TP).'),
        'feature' => 'NAMEOF_FEATURE_VPN',
        'label' => _('PPTP/L2TP'),
        'parent' => 'menu.pills.vpn',
        'type' => 'form,grid',
    ],
    'pptpl2tpwizard' => [
        'condition' => Feature::hasVpn() && !Feature::isPc(),
        'label' => _('PPTP/L2TP Connection Wizard'),
        'parent' => 'pptpl2tp',
        'type' => 'wizard',
    ],
    'pptpl2tpsummary' => [
        'condition' => Feature::hasVpn() && !Feature::isPc(),
        'label' => _('PPTP/L2TP Connection Wizard - Summary'),
        'parent' => 'pptpl2tp',
    ],
    'menu.pills.openvpn' => [
        'condition' => (Feature::hasOpenVpn() || Feature::hasOpenVpnClient()),
        'label' => _('OpenVPN'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],

    'openvpnvars' => [
        'condition' => Feature::hasOpenVpn(),
	'desc' => _('Generate the master Certificate Authority (CA) certificate and key.'),
        'label' => _('Server CA and Key'),
        'parent' => 'menu.pills.openvpn',
        'type' => 'form',
    ],
    'openvpnserverconfig' => [
        'condition' => Feature::hasOpenVpn(),
	'desc' => _('Generate the server configuration file.'),
        'label' => _('Server Configuration'),
        'parent' => 'menu.pills.openvpn',
        'type' => 'form',
    ],
    'openvpnclientconfig' => [
        'condition' => Feature::hasOpenVpn(),
	'desc' => _('Generate and download the configuration files for remote clients.'),
        'label' => _('Remote Client Configuration'),
        'parent' => 'menu.pills.openvpn',
        'type' => 'form',
    ],
    'openvpnstatus' => [
        'condition' => Feature::hasOpenVpn(),
	'desc' => _('Show current activity of the server.'),
        'label' => _('Server Status'),
        'parent' => 'menu.pills.openvpn',
        'type' => 'form',
    ],
    'openvpnclient' => [
        'condition' => Feature::hasOpenVpnClient(),
	'desc' => _('Upload client configuration to connect to remote server.'),
        'label' => _('Local Client Configuration'),
        'parent' => 'menu.pills.openvpn',
        'type' => 'form',
    ],
    'wol' => [
        'condition' => Feature::hasWakeOnLan(),
        'desc' => _('Wake on LAN offers the possibility to wake up WOL enabled clients.'),
        'label' => _('Wake on LAN'),
        'parent' => 'menu.tabs.network',
    ],
    'wolhostadd' => [
        'condition' => Feature::hasWakeOnLan(),
        'label' => _(''),
        'parent' => 'wol'
    ],
    'configwizardwlan' => [
        'condition' => false, // Config::hasFeature('usb_wless'),
        'desc' => _(
            'This wizard guides you through all configuration steps necessary to set up a USB Wireless connection.'
        ),
        'label' => _('WLAN configuration wizard'),
        'parent' => 'menu.tabs.network',
        'type' => 'wizard',
    ],
// LAN1 Interface
    'menu.pills.thirdnet' => [
      'condition' => Feature::isH3Board() && !Feature::hasIserv(),
    'label' => _('LAN1'),
        'parent' => 'menu.tabs.network',
        'type' => 'pills',
    ],

    '3rdnetconfig' => [
        'condition' => Feature::isH3Board() && !Feature::hasIserv(),
        'desc' => _('Activate and configure the LAN1 Interface.'),
        'label' => _('LAN1'),
        'parent' => 'menu.pills.thirdnet',
        'type' => 'form',
    ],
    //----------------------------------------------------------------------------------------------------
    // STATUS
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.status' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'status',
        'icon' => 'fa fa-bar-chart-o',
        'label' => _('Status'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    // OVERVIEW
    'status/overview' => [
        'label' => _('Overview'),
        'parent' => 'menu.tabs.status',
        'type' => 'data',
    ],
    // STATUS
    'menu.pills.status' => [
        'label' => _('System Status'),
        'parent' => 'menu.tabs.status',
        'type' => 'pills',
    ],
    'status?page=general' => [
        'default' => true,
        'desc' => _('Display system host name, uptime duration and firmware release.'),
        'label' => _('General'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    'ipseclog' => [
        'label' => _('IPSec Connection Log'),
        'parent' => 'ipsec',
    ],
    'ipsecsummary' => [
        'label' => _('IPSec Configuration Wizard - Summary'),
        'parent' => 'ipsec',
    ],
    'ipsecautokeying' => [
        'label' => _(''),
        'parent' => 'ipsec',
    ],
    'pptpl2tplog' => [
        'condition' => Feature::hasVpn() && !Feature::isPc(),
        'feature' => 'NAMEOF_FEATURE_VPN',
        'label' => _('VPN Connection Log'),
        'parent' => 'pptpl2tp',
    ],
    'status?page=network' => [
        'desc' => _('View system interface settings and active services.'),
        'label' => _('Network'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    'status?page=lines' => [
        'condition' => Feature::hasTelephony(),
        'desc' => _('Display status of all available telephony interfaces.'),
        'label' => _('Lines'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    'memorystatus' => [
        'condition' => !Feature::isPhoneGateway() && Feature::hasTelephony(),
        'desc' => _('Display available and allocated system memory.'),
        'label' => _('Memory'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    'status?page=hardware' => [
        'desc' => _('Display status of various interface ports.'),
        'label' => _('Hardware'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    'status?page=sip' => [
        'condition' => Feature::hasTelephony(),
        'desc' => _('Display extensions registered to an external SIP server.'),
        'label' => _('SIP Registration'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    'status?page=iplines' => [
        'condition' => ( Feature::hasSipLines() && !Feature::isPstnGateway() ) || ( Feature::hasSipLines() && Feature::isPstnGateway( ) && FeatureUtils::hasAdditionalIPPhones( ) ),
        'desc' => _('List configured IP lines and the registration status of the IP phone.'),
        'label' => _('IP Lines Registration'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    'status?page=license' => [
        'condition' => !Feature::isGateway() && Feature::hasTelephony(),
        'desc' => _('List the software licenses that are assigned/allocated to specific extensions.'),
        'label' => _('License'),
        'parent' => 'menu.pills.status',
        'type' => 'data',
    ],
    // EVENTS
    'menu.pills.events' => [
        'condition' => Feature::hasTelephony(),
        'desc' => _('Determine the action to be taken for events.'),
        'label' => _('Events'),
        'parent' => 'menu.tabs.status',
        'type' => 'pills',
    ],
    'event?eventpage=0' => [
        'default' => true,
        'desc' => _('View recent system notification messages.'),
        'label' => _('System Events'),
        'parent' => 'menu.pills.events',
        'type' => 'grid',
    ],
    'event?eventpage=1' => [
        'desc' => _('Determine the action to be taken for events.'),
        'label' => _('Event Settings'),
        'parent' => 'menu.pills.events',
        'type' => 'grid',
    ],
    'eventedit' => [
        'label' => _('System Events - Edit Event Settings'),
        'parent' => 'event?eventpage=1',
        'type' => 'form',
    ],
	// Email
    'mail' => [
        'condition' => Feature::hasTelephony(),
        'desc' => _('E-mail settings for automatically generated E-mails (events, voice mails, etc).'),
        'label' => _('E-mail (SMTP)'),
        'parent' => 'menu.pills.events',
        'type' => 'form',
    ],
    // SMS (Text Messaging)
    'sms' => [
        'condition' => Feature::hasSms(),
        'desc' => _('SMS settings for automatically generated text messages to mobile phones.'),
        'label' => _('System SMS'),
        'parent' => 'menu.pills.events',
        'type' => 'form',
    ],
    // CALL HISTORY
    'menu.pills.statistics' => [
        'condition' => Feature::hasTelephony(),
        'label' => _('Call History'),
        'parent' => 'menu.tabs.status',
        'type' => 'pills',
    ],
    'statistics?param=SuccessfulCalls' => [
        'default' => true,
        'desc' => _('Display current list of successful calls originated or received.'),
        'label' => _('Successful Calls'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],
    'statistics?param=MissedCalls' => [
        'desc' => _('List of missed (unanswered) calls.'),
        'label' => _('Missed Calls'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],
    'statistics?param=UnsuccessfulOutgoingCalls' => [
        'desc' => _('Outgoing call attempts that did not complete.'),
        'label' => _('Unsuccessful Outgoing Calls'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],
	'statisticscallcost' => [
	'condition' => Feature::isPbx(),
        'desc' => _('Display calculated Call Cost.'),
        'label' => _('Call Cost'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],
    'statistics?param=StatisticsSettings' => [
        'desc' => _('Download current call records or configure the number of call records to save.'),
        'label' => _('Settings'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],
    'cdrslist' => [
        'condition' => Feature::hasCdrArchive(),
        'desc' => _('Chronological display of archived Call Detail Records.'),
        'label' => _('Archive'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],
    'statistics?param=StatisticsArchive' => [
        'condition' => Feature::hasCdrArchive(),
        'desc' => _('Options for archiving call records.'),
        'label' => _('Archiving Settings'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],
    'statistics?param=AutomaticallyDownload' => [
        'condition' => !Feature::hasCdrArchive(),
        'desc' => _('Automatically send call records to external storage.'),
        'label' => _('Automatic Backup'),
        'parent' => 'menu.pills.statistics',
        'type' => 'grid',
    ],    
	'faxstatistics' => [
        'label' => _('Call History - FAX Details'),
        'parent' => 'statistics?param=SuccessfulCalls',
    ],
    'rtpstatistics' => [
        'label' => _('Call History - RTP Details'),
        'parent' => 'statistics?param=SuccessfulCalls',
    ],

    // CONFERENCE HISTORY
    'menu.pills.confstatistics' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Conference History'),
        'parent' => 'menu.tabs.status',
        'type' => 'pills',
    ],
    'confstatistics?param=Conferences' => [
        'condition' => Feature::hasConfServer(),
        'default' => true,
        'desc' => _('View call records specific to conference calls.'),
        'label' => _('Conferences'),
        'parent' => 'menu.pills.confstatistics',
        'type' => 'grid',
    ],
    'confstatistics?param=SuccessfulCalls' => [
        'condition' => Feature::hasConfServer(),
        'desc' => _('View call records of outbound calls originated from a conference bridge.'),
        'label' => _('Successful Calls'),
        'parent' => 'menu.pills.confstatistics',
        'type' => 'grid',
    ],
    'confstatistics?param=UnsuccessfulOutgoingCalls' => [
        'condition' => Feature::hasConfServer(),
        'desc' => _('View call records of unsuccessful outgoing call attempts made from a conference bridge.'),
        'label' => _('Unsuccessful Outgoing Calls'),
        'parent' => 'menu.pills.confstatistics',
        'type' => 'grid',
    ],
    'confstatistics?param=StatisticsSettings' => [
        'condition' => Feature::hasConfServer(),
        'desc' => _('Download conference call detail records or configure number of call records to save.'),
        'label' => _('Settings'),
        'parent' => 'menu.pills.confstatistics',
        'type' => 'grid',
    ],
    
    'menu.pills.smshistory' => [
        'condition' => Feature::hasSms() && Feature::isPbx() && Feature::hasIpLines(),
	'desc' => _('SMS/WhatsApp History.'),
	'label' => _('SMS/WhatsApp History'),
        'parent' => 'menu.tabs.status',
        'type' => 'pills',
    ], 
  
    'smshistory' => [
        'condition' => Feature::hasSms() && Feature::isPbx() && Feature::hasIpLines(),
	'desc' => _('View SMS/WhatsApp records.'),
	'label' => _('SMS/WhatsApp History'),
	'parent' => 'menu.pills.smshistory',
	'type' => 'grid',
	],

    'smshistorybackup' => [
        'condition' => Feature::hasSms() && Feature::isPbx() && Feature::hasIpLines(),
	'desc' => _('Backup SMS/WhatsApp records.'),
	'label' => _('SMS/WhatsApp History Backup'),
	'parent' => 'menu.pills.smshistory',
	'type' => 'grid',
	],

    // LAN/WAN MONITORING
    'menu.pills.interfacestatistics' => [
        'label' => _('Network Interfaces'),
        'parent' => 'menu.tabs.status',
        'type' => 'pills',
    ],
    'interfacestatistics?page=LAN' => [
        'default' => true,
        'desc' => _('Show current activity of the LAN.'),
        'label' => _('LAN'),
        'parent' => 'menu.pills.interfacestatistics',
        'type' => 'data',
    ],
    'interfacestatistics?page=WAN' => [
        'condition' => !Feature::isPc(),
        'desc' => _('Show current activity of the WAN.'),
        'label' => _('WAN'),
        'parent' => 'menu.pills.interfacestatistics',
        'type' => 'data',
    ],
    'interfacestatistics?page=lan1' => [
        'condition' => Feature::isPc() && !Feature::isHosted(),
        'desc' => _('Show current activity of the LAN1.'),
        'label' => _('LAN1'),
        'parent' => 'menu.pills.interfacestatistics',
        'type' => 'data',
    ],
    'vlanstatistics' => [
        'condition' => Feature::hasVlan() && !Feature::isHosted() && FeatureUtils::isVlanConfigured( ),
        'desc' => _('Show current activity of the VLAN.'),
        'label' => _('VLAN'),
        'parent' => 'menu.pills.interfacestatistics',
        'type' => 'data',
    ],
	'pppstatistics' => [
        'condition' => Feature::hasPpp(),
        'desc' => _('Show current activity of the PPTP/L2TP.'),
        'label' => _('PPTP/L2TP'),
        'parent' => 'menu.pills.interfacestatistics',
        'type' => 'data',
     ],
    // STATISTICS
    'menu.pills.reporting' => [
        'label' => _('Statistics'),
        'parent' => 'menu.tabs.status',
        'type' => 'pills',
    ],
    'line' => [
        'desc' => _('Show the activity of LAN or WAN ports over a period of time.'),
        'label' => _('Network Transfer'),
        'parent' => 'menu.pills.reporting',
        'type' => 'data',
    ],
    'trunkstathistory' => [
        'condition' => Feature::hasIsdn() || Feature::hasE1T1() || Feature::hasFxo(),
        'desc' => _('Show the activity on the on-board PSTN (FXO, E1/T1 or ISDN) channels over a period of time.'),
        'label' => _('PSTN Channel Usage'),
        'parent' => 'menu.pills.reporting',
    ],
    'rtsl' => [
        'condition' => Feature::hasRemoteTesting() && Feature::hasRemoteControl(),
        'label' => _('Remote Testing'),
        'parent' => 'menu.tabs.status',
    ],
    //----------------------------------------------------------------------------------------------------
    // MAINTENANCE
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.maintenance' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'maintenance',
        'icon' => 'fa fa-wrench',
        'label' => _('Maintenance'),
        'menu' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // OVERVIEW
    'maintenance/overview' => [
        'label' => _('Overview'),
        'parent' => 'menu.tabs.maintenance',
        'type' => 'data',
    ],
    //--------------------
    // DIAGNOSTICS
    'menu.pills.diagnostics' => [
  		'condition' => !Feature::isConfigEmulator(),
        'label' => _('Diagnostics'),
        'parent' => 'menu.tabs.maintenance',
        'type' => 'pills',
    ],
    'maintenance/diagnostics' => [
        'desc' => _('Start diagnostics on the WAN Ethernet port, ISDN or FXO ports, or download the system logs.'),
        'label' => _('Diagnostics'),
        'parent' => 'menu.pills.diagnostics',
        'type' => 'form',
    ],
    'maintenance/diag-command' => [
        'label' => _('Diagnostics Command'),
        'parent' => 'maintenance/diagnostics',
        'type' => 'command',
    ],
    'maintenance/testusbflash-command' => [
        'label' => _('Test USB flash Command'),
        'parent' => 'maintenance/diagnostics',
        'type' => 'command',
    ],
    'maintenance/security-diagnostics' => [
        'condition' => Feature::hasTelephony(),
        'desc' => _('Perform a security audit of the system.'),
        'label' => _('Security Diagnostics'),
        'parent' => 'menu.pills.diagnostics',
        'type' => 'form',
    ],
    'maintenance/security-diagnostics-command' => [
        'condition' => Feature::hasTelephony(),
        'label' => _('Security Audit Command'),
        'parent' => 'maintenance/security-diagnostics',
        'type' => 'command',
    ],
    'securityreport' => [
        'condition' => Feature::hasTelephony(),
        'label' => _('Security Scanning Report'),
        'parent' => 'maintenance/security-diagnostics'
    ],
    'callcapture' => [
        'condition' => Feature::hasTelephony(),
        'desc' => _('Capture an active call or select a specific interface to provide a DSP trace for analysis.'),
        'label' => _('Call Capture'),
        'parent' => 'menu.pills.diagnostics',
        'type' => 'form',
    ],
    'netcapture' => [
        'desc' => _('Capture packets on selected interface.'),
        'label' => _('Network Capture'),
        'parent' => 'menu.pills.diagnostics',
        'type' => 'form',
    ],
    'maintenance/ping' => [
        'desc' => _('Ping to an IP address or DNS name.'),
        'label' => _('Ping'),
        'parent' => 'menu.pills.diagnostics',
        'type' => 'form',
    ],
    'maintenance/ping-command' => [
        'label' => _('Ping Command'),
        'parent' => 'maintenance/ping',
        'type' => 'command',
    ],
    'maintenance/traceroute' => [
        'desc' => _('Perform a traceroute to see the path and response time for each hop to the destination node.'),
        'label' => _('Traceroute'),
        'parent' => 'menu.pills.diagnostics',
        'type' => 'form',
    ],
    'maintenance/traceroute-command' => [
        'label' => _('Traceroute Command'),
        'parent' => 'maintenance/traceroute',
        'type' => 'command',
    ],
    //--------------------    
    // SYSTEM LOGS
    'menu.pills.systemlogs' => [
        'condition' => Feature::hasTelephony() && !Feature::isConfigEmulator(),
        'label' => _('System Logs'),
        'parent' => 'menu.tabs.maintenance',
        'type' => 'pills',
    ],
    'systemlogs?param=0' => [
        'default' => true,
        'desc' => _('View system logs.'),
        'label' => _('System Logs'),
        'parent' => 'menu.pills.systemlogs',
        'type' => 'data',
    ],
    'systemlogs?param=100' => [
        'desc' => _('Configure general settings of the system logs.'),
        'label' => _('System Logs Settings'),
        'parent' => 'menu.pills.systemlogs',
        'type' => 'form',
    ],
    'systemlogs?param=101' => [
  		'condition' => Feature::isSunxi(),
        'desc' => _('Choose the logs to be streamed to a remote telnet client.'),
        'label' => _('Remote Logs Settings'),
        'parent' => 'menu.pills.systemlogs',
        'type' => 'form',
    ],
    'sysloglist' => [
        'condition' => Feature::hasLogArchive(),
        'desc' => _('Archive log files for later reference.'),
        'label' => _('Logs Archive'),
        'parent' => 'menu.pills.systemlogs',
        'type' => 'grid',
    ],
    //--------------------
    // USER RIGHTS
    'menu.pills.userrights' => [
        'condition' => Feature::hasTelephony(),
        'label' => _('User Rights'),
        'parent' => 'menu.tabs.maintenance',
        'type' => 'pills',
    ],
    'rightsmanagement?eventpage=0' => [
        'default' => true,
        'desc' => _('Enable/disable localadmin, set the admin and localadmin passwords.'),
        'label' => _('Users'),
        'parent' => 'menu.pills.userrights',
        'type' => 'grid',
    ],
    'rightsmanagement?eventpage=1' => [
        'desc' => _('Assign permissions to access the GUI pages for localadmin or extensions.'),
        'label' => _('Roles'),
        'parent' => 'menu.pills.userrights',
        'type' => 'grid',
    ],
    'pmsconfigmgmt' => [
        'condition' => FeatureUtils::isPmsServerEnabled(),
        'desc' => _('Hotel Console user rights management.'),
        'label' => _('Hotel Console User'),
        'parent' => 'menu.pills.userrights',
        'type' => 'grid',
    ],
    'adminpsw' => [
        'label' => _('Admin Password'),
        'parent' => 'rightsmanagement?eventpage=0',
        'type' => 'form',
    ],
    'userpsw' => [
        'label' => _('User Password'),
        'parent' => 'usersettings',
        'type' => 'form',
    ],
    'rightschange' => [
        'label' => _('Change Rights'),
        'parent' => 'rightsmanagement?eventpage=1',
        'type' => 'grid,form',
    ],
    'twofactorauth' => [
        'label' => _('Time-Based One-Time Password'),
        'parent' => 'rightsmanagement?eventpage=0',
        'type' => 'form',
    ],
    //--------------------
    // BACKUP / RESTORE
    'menu.pills.backuprestore' => [
        'label' => _('Backup / Restore'),
        'parent' => 'menu.tabs.maintenance',
        'type' => 'pills',
    ],
    'backuprestoreconfint' => [
        'desc' => _('Backup or restore system configuration and voice data.'),
        'label' => _('Backup / Restore'),
        'parent' => 'menu.pills.backuprestore',
        'type' => 'data',
    ],
    'autobackupconfig' => [
        'desc' => _('Enable and configure the automatic backup of the system configuration and voice data.'),
        'label' => _('Automatic Backup'),
        'parent' => 'menu.pills.backuprestore',
        'type' => 'form',
    ],
    'getconfsummary' => [
        'desc' => _('Generate legible configuration and download to PC or view directly in browser.'),
        'label' => _('Download Legible Configuration'),
        'parent' => 'menu.pills.backuprestore',
        'type' => 'form',
    ],
    'putconf' => [
        'desc' => _('Upload a configuration file in text format.'),
        'label' => _('Upload Legible Configuration'),
        'parent' => 'menu.pills.backuprestore',
        'type' => 'form',
    ],
    //---------------------
    // Auto Provisioning
    'fxsgwoperationmode' => [
        'condition' => Feature::isPhoneGateway(),
	'desc' => _('General Operation Mode'),
        'label' => _('Auto Provisioning'),
	'parent' => 'menu.tabs.maintenance',
    ],
    //--------------------
    // FIRMWARE
    'menu.pills.firmware' => [
        'label' => _('Firmware'),
        'parent' => 'menu.tabs.maintenance',
        'type' => 'pills',
    ],
    'update?firmwareupdatemainpage=uploadupdate' => [
	'condition' => Feature::showFirmwareManualUpload() && !Feature::isConfigEmulator(),
        'desc' => _('Upload firmware from your computer and install it.'),
        'label' => _('Manual Firmware Update'),
        'parent' => 'menu.pills.firmware',
        'type' => 'form',
    ],
    'update?firmwareupdatemainpage=downloadupdate' => [
        'desc' => _('Get and install a firmware located on the remote server.'),
        'label' => _('Get Firmware From Server'),
        'parent' => 'menu.pills.firmware',
        'type' => 'form',
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::SUPERADMIN,
    ],
    'burn' => [
    	'condition' => !Feature::isConfigEmulator(),
        'action' => ['maintenance', 'burn'],
        'label' => _('Burning Image'),
        'parent' => 'update',
        'type' => 'form',
    ],
    'maintenance/burn-command' => [
  		'condition' => !Feature::isConfigEmulator(),
        'label' => _('Test USB Flash Command'),
        'parent' => 'burn',
        'type' => 'command',
    ],
    'updateconfiguration' => [
        'condition' => !Feature::hasCloudOwnService(),
        'desc' => _(
            'Perform automatic notification or update when new firmware becomes available on Epygi Support Portal.'
        ),
        'label' => _('Automatic Firmware Update'),
        'parent' => 'menu.pills.firmware',
        'type' => 'form',
    ],
    'maintenance/reboot' => [
        'desc' => _('Reboot the device.'),
        'label' => _('Reboot'),
        'parent' => 'menu.tabs.maintenance',
    ],
    //----------------------------------------------------------------------------------------------------
    // CONFMENU
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.confmenu' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::CONFERENCE,
        'condition' => Feature::hasConfServer() && $ext->isConference(),
        'helproot' => 'conference',
        'icon' => 'fa fa-users',
        'label' => _('Conference') . ':' . $ext->getId(), //_('Conference'),
        'menu' => true,
        'menu-lock' => true, // 'menu-define' => EMenu::CONFERENCE,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // CONFERENCE PROGRESS
    'conferencepage' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Conference Progress'),
        'parent' => 'menu.tabs.confmenu',
    ],
    //--------------------
    // RECORDED CONFERENCES
    'vmail?param=conference' => [
        'condition' => Feature::hasConfServer() && $ext->isConference(),
        'label' => _('Recorded Conferences'),
        'parent' => 'menu.tabs.confmenu',
        'type' => 'list',
    ],
    //--------------------
    // CONFERENCE SETTINGS
    'menu.pills.properties' => [
        'condition' => Feature::hasConfServer() && $ext->isConference(),
        'icon' => 'fa fa-cogs',
        'label' => _('Conference Settings'),
        'parent' => 'menu.tabs.confmenu',
        'type' => 'pills',
    ],
    // General
    'conferencegeneral' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('General'),
        'parent' => 'menu.pills.properties',
        'type' => 'form',
    ],
    'conferencepresence' => [
        'label' => _('Presence Settings'),
        'parent' => 'conferencegeneral',
    ],
    // Recordings
    'conferencerecording' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Recording'),
        'parent' => 'menu.pills.properties',
        'type' => 'form',
    ],
    // customization
    'confsysmessages' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Customization'),
        'parent' => 'menu.pills.properties',
        'type' => 'form',
    ],
    // participants
    'participants' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Participants'),
        'parent' => 'menu.pills.properties',
    ],
    'participant' => [
        'label' => _('Conference Progress - Add Participant and Participants - Add Entry'),
        'parent' => 'participants',
        'type' => 'form',
    ],
    'participanthandset' => [
        'label' => _('Handset Added Participants Configuration'),
        'parent' => 'participants',
        'type' => 'form',
    ],
    'participantnew' => [
        'label' => _('New Participants Configuration'),
        'parent' => 'participants',
        'type' => 'form',
    ],
    // schedule
    'schedulepage' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Schedule'),
        'parent' => 'menu.pills.properties',
        'type' => 'form,grid',
    ],
    'sendmail' => [
        'condition' => Feature::hasConfServer(),
        'label' => _('Send Notification Mail'),
        'parent' => 'menu.pills.properties',
    ],
    
    // video room
    'conferencevideoroom' => [
        'condition' => (Feature::hasConfServer() && Feature::isEnabledWebRtcGateway()),
        'label' => _(''),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],

    //----------------------------------------------------------------------------------------------------
    // RECORDING SUBMENU
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.recording' => [
        'acl' => ERole::RECORDING,
        'condition' => $ext->isRecording(),
        'helproot' => 'yourext',
        'icon' => 'fa fa-phone',
        'label' => _('Your Recording'),
        'menu' => true,
        'menu-lock' => true,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // RECORDING BOX
    'menu.pills.recordingbox' => [
        'condition' => $ext->isRecording(),
        'icon' => 'fa fa-phone',
        'label' => _('Recording Box'),
        'parent' => 'menu.tabs.recording',
        'type' => 'pills',
    ],
    'recordingbox' => [
        'condition' => (Feature::hasRecording() && $ext->isRecording()),
        'label' => _('Recording'),
        'parent' => 'menu.pills.recordingbox',
    ],
    'userrecordingbox' => [
        'condition' => (Feature::hasRecording() && $ext->isRecording()),
        'hide' => true,
        'parent' => 'recordingbox',
    ],
    'playrecord' => [
        'condition' => Feature::hasVoiceMailSystem(),
        'feature' => 'NAMEOF_FEATURE_VM',
        'label' => _(''),
        'parent' => 'recordingbox',
    ],
    //----------------------------------------------------------------------------------------------------
    // YOUR EXTENSION
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.yourextension' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION,
        'condition' => ($ext->isExtension() || $ext->isTemplate()),
        'helproot' => 'yourext',
        'icon' => 'fa fa-phone',
        'label' => _('Extension') . ':' . $ext->getId(), //_('Your Extension'),
        'menu' => true,
        'menu-lock' => true, // menu-define' => EMenu::EXTENSION,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // VOICE MAIL
    'menu.pills.voicemail' => [
        'condition' => ($ext->isExtension() || $ext->isTemplate()) && Feature::hasVoiceMailSystem(),
        'icon' => 'fa fa-phone',
        'label' => _('Voice Mail'),
        'parent' => 'menu.tabs.yourextension',
        'type' => 'pills',
    ],
    // voice mailbox
    'vmail?param=voicemail' => [
        'condition' => (Feature::hasVoiceMailSystem() && !$ext->isTemplate()),
        'default' => true,
        'label' => _('Voice Mailbox'),
        'parent' => 'menu.pills.voicemail',
        'type' => 'grid',
    ],
    // voice mail settings
    'vms' => [
        'condition' => Feature::hasVoiceMailSystem(),
        'label' => _('Voice Mail Settings'), // Extension Voice Mail Settings
        'parent' => 'menu.pills.voicemail',
        'type' => 'form',
    ],
    'vmprofiles' => [
        'condition' => (Feature::hasVoiceMailSystem() && $isadmin_no_cloud),
        'label' => _('Voice Mail Profiles'),
        'parent' => 'menu.pills.voicemail',
        'type' => 'grid,form',
    ],
    // group list
    'grouplist' => [
        'condition' => (Feature::hasVoiceMailSystem() && $isadmin_no_cloud),
        'label' => _('Group List'), // Extension Group List
        'parent' => 'menu.pills.voicemail',
        'type' => 'grid,form',
    ],
    'grouplistadd' => [
        'condition' =>(Feature::hasVoiceMailSystem() && $isadmin_no_cloud),
        'label' => _('Extension Group List - Add/Edit Member'),
        'parent' => 'grouplist',
    ],
    //--------------------
    // CALL HISTORY
    'menu.pills.userstatistics' => [
        'condition' => !$ext->isTemplate(),
        'label' => _('Call History'),
        'parent' => 'menu.tabs.yourextension',
        'type' => 'pills',
    ],
    'userstatistics?param=SuccessfulCalls' => [
        'default' => true,
        'desc' => _('Display current list of successful calls originated or received.'),
        'label' => _('Successful Calls'),
        'parent' => 'menu.pills.userstatistics',
        'type' => 'grid',
    ],
    'userstatistics?param=MissedCalls' => [
        'desc' => _('List of missed (unanswered) calls.'),
        'label' => _('Missed Calls'),
        'parent' => 'menu.pills.userstatistics',
        'type' => 'grid',
    ],
    'userstatistics?param=UnsuccessfulOutgoingCalls' => [
        'desc' => _('Outgoing call attempts that did not complete.'),
        'label' => _('Unsuccessful Outgoing Calls'),
        'parent' => 'menu.pills.userstatistics',
        'type' => 'grid',
    ],
    //--------------------
    // PBX INFORMATION
    'extensionstat' => [
        'condition' => (( !$ext->isTemplate() && !Feature::isPhoneGateway() ) && $isadmin_no_cloud), // !Config::isProductType(4, 7) && !Config::isProductClass(4),
        'extension_type' => 'user',
        'label' =>  Feature::isPbx() ? _('PBX Information') : _('General Information'), // General PBX Information for the Extension Users
        'parent' => 'menu.tabs.yourextension',
        'type' => 'grid',
    ],
    //--------------------
    // SPEED CALLING
    'sds' => [
        'condition' => !Feature::isGateway(),
        'extension_type' => 'user',
        'label' => _('Speed Calling'),
        'parent' => 'menu.tabs.yourextension',
        'type' => 'grid,form',
    ],
    //--------------------
    // ACCOUNT SETTINGS
    'menu.pills.account' => [
        'condition' => (!Feature::isPhoneGateway() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Account'),
        'parent' => 'menu.tabs.yourextension',
        'type' => 'pills',
    ],
    'usersettings' => [
        'condition' => (!Feature::isPhoneGateway() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Account'), // Extension Account Settings
        'parent' => 'menu.pills.account',
        'type' => 'form',
    ],
    //--------------------
    // BASIC SERVICES
    'menu.pills.callhandlingbasic' => [
        'condition' => ((Feature::isPbx() || Feature::isPhoneGateway()) && $isadmin_no_cloud),
        'label' => _('Basic Services'),
        'parent' => 'menu.tabs.yourextension',
        'type' => 'pills',
    ],
    'redial' => [
        'condition' => ((Feature::isPbx() || Feature::isPhoneGateway()) && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('General'),
        'parent' => 'menu.pills.callhandlingbasic',
        'type' => 'form',
    ],
    'hold' => [
        'condition' => (Feature::isPbx() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Hold Music'),
        'parent' => 'menu.pills.callhandlingbasic',
        'type' => 'form',
    ],
    'dnd' => [
        'condition' => (Feature::isPbx() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Do Not Disturb'),
        'parent' => 'menu.pills.callhandlingbasic',
        'type' => 'form',
    ],
    'alarm' => [
        'condition' => (Feature::isPbx() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Alarm'),
        'parent' => 'menu.pills.callhandlingbasic',
        'type' => 'form',
    ],
    'alarmadd' => [
        'condition' => (Feature::isPbx() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('AlarmClock - Add/Edit Entry'),
        'parent' => 'alarm',
        'type' => 'form',
    ],
    'scheduledtask' => [
        'condition' => (Feature::isPbx() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Activate D&A'),
        'parent' => 'menu.pills.callhandlingbasic',
        'type' => 'form',
    ],
    'scheduledtaskadd' => [
        'condition' => (Feature::isPbx() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Activate Dial&Announce - Add/Edit Entry'),
        'parent' => 'scheduledtask',
        'type' => 'form',
    ],
    'hotline' => [
        'condition' => ((Feature::isPbx() || Feature::isPhoneGateway()) && Feature::hasFxs()) && $isadmin_no_cloud,
        'extension_type' => 'user',
        'label' => _('Hot Line'),
        'parent' => 'menu.pills.callhandlingbasic',
        'type' => 'form',
    ],
    //--------------------
    // CALLER ID SERVICES
    'menu.pills.calleridservices' => [
        'condition' => (!Feature::isPhoneGateway() && $isadmin_no_cloud),
        'label' => _('Caller ID Services'),
        'parent' => 'menu.tabs.yourextension',
        'type' => 'pills',
    ],
    'addressmanagement' => [
        'condition' => (!Feature::isPhoneGateway() && $isadmin_no_cloud),
        'extension_type' => 'user',
        'label' => _('Caller ID Services'),
        'parent' => 'menu.pills.calleridservices',
        'type' => 'grid',
    ],
    'supservices' => [
        'condition' => (!Feature::isPhoneGateway() && $isadmin_no_cloud),
        'label' => _('Caller ID Based Services'),
        'parent' => 'addressmanagement',
        'type' => 'form,grid',
    ],
    'huntadd' => [
        'condition' => !Feature::isPhoneGateway(),
        'label' => _('Call Hunting - Add/Edit Entry'),
        'parent' => 'supservices',
        'type' => 'form',
    ],
    'forwardadd' => [
        'condition' => (!Feature::isPhoneGateway() && $isadmin_no_cloud),
        'label' => _('Forwarding List - Add/Edit Entry'),
        'parent' => 'supservices',
        'type' => 'form',
    ],
    'findfollowadd' => [
        'condition' => (Feature::has3pcc() && $isadmin_no_cloud),
        'label' => _('FindFollow List - Add/Edit Entry'),
        'parent' => 'supservices',
        'type' => 'form',
    ],
    'dialandannounceadd' => [
        'condition' => (Feature::has3pcc() && $isadmin_no_cloud),
        'label' => _('Dial & Announce List - Add/Edit Entry'),
        'parent' => 'supservices',
        'type' => 'form',
    ],
    //----------------------------------------------------------------------------------------------------
    // YOUR VOICEMAILBOX
    //----------------------------------------------------------------------------------------------------
    'menu.tabs.yourvoicemailbox' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::VOICEMAILBOX,
        'condition' => $ext->isVoiceMailBox(),
        'helproot' => 'yourvmb',
        'icon' => 'fa fa-microphone',
        'label' => $ext->getId(), //_('Your Voice MailBox'),
        'menu' => true,
        'menu-lock' => true, // menu-define' => EMenu::VOICEMAILBOX,
        'parent' => 'ROOT',
        'type' => 'tabs',
    ],
    //--------------------
    // VOICE MAIL
    'menu.pills.vmb' => [
        'condition' => $ext->isVoiceMailBox(),
        'icon' => 'fa fa-microphone',
        'label' => _('Voice MailBox'),
        'parent' => 'menu.tabs.yourvoicemailbox',
        'type' => 'pills',
    ],
    'vmmgmtmailbox' => [
        'condition' => $ext->isVoiceMailBox(),
        'label' => _('Voice Mails'),
        'parent' => 'menu.pills.vmb',
        'selected' => 'voicemailbox',
    ],
    // voice mail settings
    'vmbsettings' => [
        'condition' => $ext->isVoiceMailBox(),
        'label' => _('Voice MailBox Settings'), // Voice Mail Settings
        'parent' => 'menu.pills.vmb',
        'type' => 'form',
    ],

    //----------------------------------------------------------------------------------------------------
    // HIDDEN
    //----------------------------------------------------------------------------------------------------
    'hidden' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'hidden',
        'icon' => 'fa fa-lock',
        'label' => _('Hidden'),
        'parent' => 'ROOT',
    ],
    // USER KNOWN HIDDEN PAGES
    'menu.hidden.known' => [
        'label' => _('User Known Hidden Pages'),
        'parent' => 'hidden',
        'type' => 'menu',
    ],
    'advanced' => [
        'label' => _('Advanced System Setup'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'codecsconfig' => [
        'desc' => _('Allows configuring voice codec settings.'),
        'label' => _('Voice Codecs'),
        'parent' => 'menu.hidden.known',
        'type' => 'form,grid',
    ],
    'extmanagement' => [
        'desc' => _('Advanced settings for extensions and attendants.'),
        'label' => _('Extension Management'),
        'parent' => 'menu.hidden.known',
        'type' => 'form,grid',
    ],
    'fxocfg' => [
        'condition' => Feature::hasFxo(),
        'desc' => _('Configure FXO lines.'),
        'label' => _('FXO Configuration'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'fxoconfig' => [
        'desc' => _('FXO Echo Canceller settings.'),
        'label' => _('FXO Echo Cancel Settings'),
        'parent' => 'menu.hidden.known',
        'type' => 'form,grid',
    ],
    'fxodisconnect' => [
        'condition' => Feature::hasFxo(),
        'desc' => _('Select 1 of 5 scenarios for call disconnection.'),
        'label' => _('FXO Disconnect Scenarios'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'generalconfig' => [
        'desc' => _('Configure system general settings.'),
        'label' => _('General Configuration'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'lantable' => [
        'desc' => _('Allows packet traffic prioritization base on IP address.'),
        'label' => _('LAN Prioritization Table'),
        'parent' => 'menu.hidden.known',
        'type' => 'grid,form',
    ],
    'linesconfig' => [
        'desc' => _('Advanced FXS settings.'),
        'label' => _('Lines Configuration'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'trunkecho' => [
        'condition' => Feature::hasIsdn() || Feature::hasE1T1(),
        'desc' => _('Configure echo settings of ISDN, E1/T1 trunks.'),
        'label' => _(''),
        'parent' => 'menu.hidden.known',
        'type' => 'internal',
    ],
    'tos' => [
        'desc' => _('Specify type of service (ToS) for SIP and RTP packets.'),
        'label' => _('TOS Settings'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'loadlogoint' => [
        'desc' => _('Upload or Restore company details: logo, running logo, icon, link.'),
        'label' => _('Upload Company Details'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'uploadlogo' => [
        'desc' => _('Upload or Restore company details: logo, icon.'),
        'label' => _('Upload Company Details'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'callcontrol' => [
        'condition' => Feature::has3pcc(),
        'desc' => _('Make auto-generated calls.'),
        'label' => _('Call Control'),
        'parent' => 'menu.hidden.known',
        'type' => 'form',
    ],
    'busylightnotifications' => [
        'desc' => _('Configure BusyLight Notifications'),
        'label' => _('BusyLight Integration'),
        'parent' => 'menu.hidden.known',
	'type' => 'form',
    ],
    'e911' => [
        'desc' => _('Dynamic emergency address'),
        'label' => _('e911'),
        'parent' => 'menu.hidden.known',
	'type' => 'form',
    ],

    //----------------------------------------------------------------------------------------------------
    // INTERNAL
    //----------------------------------------------------------------------------------------------------
    'internal' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'helproot' => 'internal',
        'icon' => 'fa fa-lock',
        'label' => _('Internal'),
        'parent' => 'ROOT',
    ],
    //----------
    // SETUP
    'menu.internal.setup' => [
        'label' => _('Setup - Hidden Pages'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    'switch' => [
        'label' => _('Switch'),
        'parent' => 'menu.internal.setup',
        'type' => 'form',
    ],
    //----------
    // INTERFACES
    'menu.internal.interfaces' => [
        'label' => _('Interfaces - Hidden Pages'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    'cactable' => [
        'label' => _('CAC Exclusion Table'),
        'parent' => 'menu.internal.interfaces',
        'type' => 'grid,form',
    ],
    'ipphonesdirectory' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('IP Phones Directory'),
        'parent' => 'menu.internal.interfaces',
        'type' => 'grid,form',
    ],
    'ipphonesfrm' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('IP Phones Firmware Settings'),
        'parent' => 'menu.internal.interfaces',
        'type' => 'form',
    ],
    'r2settings' => [
        'condition' => Feature::hasE1T1() || (Feature::isPbx() && Feature::hasPstnExAutoConfig()),
        'label' => _('E1 CAS R2 Recommended Settings'),
        'parent' => 'menu.internal.interfaces',
    ],
    //----------
    // EXTENSIONS
    'menu.internal.extensions' => [
        'label' => _('Extensions - Hidden Pages'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    'instantconferences' => [
        'label' => _('Instant Conferences Management'),
        'parent' => 'menu.internal.extensions',
    ],
    //----------
    // TELEPHONY
    'menu.internal.telephony' => [
        'label' => _('Telephony - Hidden Pages'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    'callpolicy' => [
        'label' => _('Call Policy'),
        'parent' => 'menu.internal.telephony',
        'type' => 'form',
    ],
    // TODO: is this needed?
    'confmediasettings' => [
        'label' => _('Conference Media Settings'),
        'parent' => 'menu.internal.telephony',
        'type' => 'form',
    ],
    'dtmfduration' => [
        'label' => _('DTMF Duration Settings'),
        'parent' => 'menu.internal.telephony',
        'type' => 'form',
    ],
    'faxsettings' => [
        'label' => _('Fax Settings'),
        'parent' => 'menu.internal.telephony',
        'type' => 'form',
    ],
    'instanthotdesk' => [
        'condition' => Feature::isPbx(),
        'label' => _('Service Code for Instant HotDesking'),
        'parent' => 'menu.internal.telephony',
    ],
    'jittercfg' => [
        'label' => _('Jitter Buffer Configuration'),
        'parent' => 'menu.internal.telephony',
        'type' => 'grid,form',
    ],
    'radiushidden' => [
        'condition' => Feature::hasRadiusClient(),
        'label' => _('Radius Hidden Settings'),
        'parent' => 'menu.internal.telephony',
        'type' => 'form',
    ],
    //----------
    // NETWORK
    'menu.internal.network' => [
        'label' => _('Network - Hidden Pages'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    'networkphycfg' => [
        'condition' => !Feature::isPc(),
        'label' => _('Network PHY Config'),
        'parent' => 'menu.internal.network',
        'type' => 'form',
    ],
    //----------
    // STATUS
    'menu.internal.status' => [
  		'condition' => !Feature::isConfigEmulator(),
        'label' => _('Status - Hidden Pages'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    'bandwidthhistory' => [
        'label' => _('Call Bandwidth Statistics'),
        'parent' => 'menu.internal.status',
        'type' => 'data',
    ],
    'loglevelswitch' => [
        'label' => _('For switching specified applications\' log levels'),
        'parent' => 'menu.internal.status',
        'type' => 'form',
    ],
    //----------
    // PNP SERVICE
    'menu.internal.pnpservice' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('PNP Service'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    //For the following CGIs(invisible) redirection is done in .htaccess, so Feature:: conditions do not take effect
    'aastra' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => '',
        'parent' => 'menu.internal.pnpservice',
    ],
    'pnpservice' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig() && Feature::hasPnpIpPhones(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'quadroautoconfig' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'snom' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'provisioning' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'xmlsetup' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig() && Feature::hasPnpIpPhones(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'restconfmpk' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'restconfipline' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'restphonebook' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    'restconfeqallsettings' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.internal.pnpservice',
    ],
    //----------
    // UNCERTAIN
    'menu.internal.uncertain' => [
        'label' => _('Uncertain Hidden Pages'),
        'parent' => 'internal',
        'type' => 'menu',
    ],
    'autoprovisioning' => [
        // TODO: move this to better menu location
        'condition' => Feature::hasProvisioning(),
        'label' => _('Automatic Provisioning'),
        'parent' => 'menu.internal.uncertain',
    ],
    'codecsmanagement' => [
        'extension_type' => 'all',
        'hide' => true,
        'label' => _('Extension Codecs'), // Extensions Management - Edit Codecs
        'parent' => $extension_parent,
        'type' => 'internal',
    ],
    'extensionsettings' => [
        'label' => _('Extension Settings'),
        'parent' => 'menu.internal.uncertain',
        'type' => 'internal',
    ],
    'inetsettings' => [
        'label' => _('Internet Connection Settings'),
        'parent' => 'menu.internal.uncertain',
        'type' => 'internal',
    ],
    'lansettings' => [
        'label' => _('LAN Configuration Settings'),
        'parent' => 'menu.internal.uncertain',
        'type' => 'internal',
    ],
    'telephonysettings' => [
        'label' => _('Telephony General Settings'),
        'parent' => 'menu.internal.uncertain',
        'type' => 'internal',
    ],
    //----------------------------------------------------------------------------------------------------
    // NO MENU
    //----------------------------------------------------------------------------------------------------
    'clicktodial' => [
        'condition' => Feature::has3pcc(),
        'label' => _(''),
        'parent' => 'internal',
    ],
    'clicktocall' => [
        'condition' => Feature::has3pcc(),
        'label' => _(''),
        'parent' => 'internal',
    ],
    'clicktoactivate' => [
        'condition' => Feature::has3pcc(),
        'label' => _(''),
        'parent' => 'internal',
    ],
    'configcmdhandler' => [
        'condition' => Feature::isPhoneGateway(),
        'label' => _(''),
        'parent' => 'menu.internal.uncertain',
    ],
    'distringpreview' => [
        'condition' => !Feature::isPhoneGateway(),
        'label' => _(''),
        'parent' => 'supservices',
    ],
    'dsp' => [
        'condition' => Feature::isPc() || Feature::isSunxi(),
        'label' => _('DSP Settings'),
        'parent' => 'internal',
    ],
    'dspcapture' => [
        'label' => _(''),
        'parent' => 'dsp',
    ],
    'falsealertmsg' => [
        'condition' => Feature::hasIsdn(),
        'label' => _('False Alert Message Timeout'),
        'parent' => 'menu.internal.uncertain',
    ],
    'fanstatus' => [
        'condition' => (Feature::isPhoneGateway() || (Feature::hasE1T1() && Feature::isPstnGateway())),
        'label' => _('FAN Status'),
        'parent' => 'internal',
    ],
    'featurelockedinfo' => [
        'label' => _(''),
        'parent' => 'internal',
    ],
    'hiddenputconf' => [
        'label' => _(''),
        'parent' => 'menu.internal.uncertain',
    ],
    'icsettings' => [
        'label' => _('Instant Conferences Settings'),
        'parent' => 'menu.internal.uncertain',
    ],
    'mbxsettings' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _('MBX Settings '),
        'parent' => 'menu.internal.uncertain',
    ],
    'paginggroup' => [
        'condition' => !Feature::isPhoneGateway(),
        'label' => _('Edit Paging Group'),
        'parent' => 'usermgmtgensettings',
    ],
    'phonerecording' => [
        'condition' => Feature::hasRecording(),
        'label' => _('IP Phone Call Recording'),
        'parent' => 'menu.internal.uncertain',
    ],
    'pmsconnection' => [
        'condition' => Feature::isPbx(),
        'label' => _('PMS Connection'),
        'parent' => 'internal',
    ],
    'pmslinkuseridmapping' => [
        'condition' => Feature::isPbx(),
        'label' => _('HMobile PMS Connection User ID Mapping Table'),
        'parent' => 'internal',
    ],
    'pmslinkroomcondition' => [
        'condition' => Feature::isPbx(),
        'label' => _('HMobile PMS Connection Room Condition Mapping Table'),
        'parent' => 'internal',
    ],
    'pmslinkminibar' => [
        'condition' => Feature::isPbx(),
        'label' => _('HMobile PMS Connection Minbar Mapping Table'),
        'parent' => 'internal',
    ],
    'registration' => [
        'label' => _(''),
        'parent' => 'internal',
    ],
    // TODO: do we still use robust FXS?
    'robustfxs' => [
        'label' => _(''),
        'parent' => 'internal',
    ],
    'rollback' => [
        'label' => _(''),
        'parent' => 'internal',
    ],
    'smsrecv' => [
        'condition' => Feature::hasSms(),
        'label' => _(''),
        'parent' => 'internal',
    ],
    'sys_messages' => [
        'label' => _(''),
        'parent' => 'internal',
    ],
    'vmplay' => [
        'condition' => Feature::hasVoiceMailSystem(),
        'feature' => 'NAMEOF_FEATURE_VM',
        'label' => _(''),
        'parent' => 'usermgmtrecordingbox',
    ],
    'extvmplay' => [
        'condition' => Feature::hasVoiceMailSystem(),
        'feature' => 'NAMEOF_FEATURE_VM',
        'label' => _(''),
        'parent' => 'vmail',
    ],
    'vmbvmplay' => [
        'condition' => Feature::hasVoiceMailSystem(),
        'feature' => 'NAMEOF_FEATURE_VM',
        'label' => _(''),
        'parent' => 'vmmgmtmailbox',
    ],
    'vxmlgenerator' => [
        'condition' => Feature::hasIvrBuilder(),
        'label' => _('VXML Generator Settings'),
        'parent' => 'usermgmtscenariosettings'
    ],
    'xmlservice' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'internal'
    ],
    'recording' => [
		'condition' => Feature::isPc() || Feature::isPbx(),
        'label' => _(''),
    ],

    'qxmon' => [
        'label' => _(''),
    ],
    'pnreg' => [
        'label' => _(''),
        'parent' => 'internal',
    ],
    'setuid' => [
  		'condition' => Feature::hasCloudOwnService() || Feature::hasPCOwnService() ,
        'label' => _(''),
        'parent' => 'internal',
    ],


    //----------------------------------------------------------------------------------------------------
    // PUBLIC (no ACL assigned)
    //----------------------------------------------------------------------------------------------------
    'menu.public' => [
        'acl' => ERole::GUEST,
        'icon' => 'fa fa-lightbulb-o',
        'label' => _('Public'),
        'parent' => 'ROOT',
    ],
    'home' => [
        'action' => ['index', 'home'],
        'label' => _('Home'),
        'parent' => 'menu.public',
    ],
    'login' => [
        'action' => ['index', 'login'],
        'label' => _('Log In'),
        'parent' => 'menu.public',
    ],
    'login2fa' => [
        'action' => ['index', 'login2fa'],
        'label' => _('Log In'),
        'parent' => 'menu.public',
    ],
    'unsecure' => [
        'action' => ['index', 'login'],
        'label' => _('Log In'),
        'parent' => 'menu.public',
    ],
    'logout' => [
        'action' => ['index', 'logout'],
        'label' => _('Log Out'),
        'parent' => 'menu.public',
    ],
    // product activation
    'activation' => [
        'condition' => Feature::isSunxi() || Feature::hasCloudOwnService()  || Feature::hasPCOwnService() ,
        'label' => _('Product Activation'),
        'parent' => 'menu.public',
    ],
    'setspwd' => [
        'condition' => Feature::hasCloudOwnService(),
        'label' => _(''),
        'parent' => 'menu.hidden.known',
    ],
    //----------------------------------------------------------------------------------------------------
    // CORE
    //----------------------------------------------------------------------------------------------------
    'core' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'icon' => 'fa fa-lightbulb-o',
        'label' => _('Core'),
        'parent' => 'ROOT',
    ],
    'index/help' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION | ERole::CONFERENCE,
        'action' => ['index', 'help'],
        'label' => _('Help'),
        'parent' => 'core',
    ],
    'index/help-extension' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION,
        'action' => ['index', 'help'],
        'label' => _('Help'),
        'parent' => 'core',
    ],
    'index/searchHelp' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION | ERole::CONFERENCE,
        'action' => ['index', 'searchHelp'],
        'label' => _(''),
        'parent' => 'core',
    ],
	// call any cgi url directly without wrapper ...
	// example /index/callcgi?url=extensionlist.cgi
    'index/callcgi' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN,
        'action' => ['index', 'callcgi'],
        'parent' => 'core',
    ],

    // DOCUMENTATION
    'menu.core.documentation' => [
        'label' => _('Documentation'),
        'parent' => 'core',
    ],
    'doc/config-viewer' => [
        'label' => _('Config Viewer'),
        'parent' => 'menu.core.documentation',
    ],
    'doc/router-study' => [
        'label' => _('Router Study'),
        'parent' => 'menu.core.documentation',
    ],
    'doc/features' => [
        'label' => _('Features'),
        'parent' => 'menu.core.documentation',
    ],
    // FILES
    'menu.core.files' => [
        'label' => _('Files'),
        'parent' => 'core',
    ],
    'downloadbackupint' => [
		'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION | ERole::PARTICIPANT,
        'label' => _(''),
        'parent' => 'menu.core.files',
    ],
    'downloadfile' => [
        'label' => _(''),
        'parent' => 'menu.core.files',
    ],
    'systemlogsdownload' => [
        'label' => _(''),
        'parent' => 'menu.core.files',
    ],
    'uploadownmessages' => [
        'condition' => !Feature::isPhoneGateway(),
        'label' => _(''),
        'parent' => 'menu.core.files',
    ],
    'uploadtemplatefile' => [
        'condition' => Feature::hasIpLines() && Feature::hasIpLinesAutoConfig(),
        'label' => _(''),
        'parent' => 'menu.core.files',
    ],
    'wavdownload' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION | ERole::CONFERENCE | ERole::VOICEMAILBOX,
        'label' => _(''),
        'parent' => 'menu.core.files',
    ],
    //----------------------------------------------------------------------------------------------------
    // Admin Settings
    //----------------------------------------------------------------------------------------------------
    'adminsettings' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION | ERole::CONFERENCE | ERole::RECORDING | ERole::VOICEMAILBOX,
        'condition' => (Auth::isAdmin() || Auth::isLocalAdmin()) &&
            ($ext->isExtension() || $ext->isTemplate() || $ext->isConference() || $ext->isRecording() || $ext->isVoiceMailBox()),
        'icon' => 'fa fa-shield',
        'label' => _('Admin Settings'),
        'action' => ['index', 'adminsettings'],
        'menu' => true,
        'menu-lock' => true,
        'parent' => 'ROOT'
    ],
    //----------------------------------------------------------------------------------------------------
    // RETURN
    //----------------------------------------------------------------------------------------------------
    'return' => [
        'acl' => ERole::ADMIN | ERole::LOCALADMIN | ERole::EXTENSION | ERole::CONFERENCE | ERole::RECORDING | ERole::VOICEMAILBOX,
        'condition' => (Auth::isAdmin() || Auth::isLocalAdmin()) &&
            ($ext->isExtension() || $ext->isTemplate() || $ext->isConference() || $ext->isRecording() || $ext->isVoiceMailBox()),
        'icon' => 'fa fa-arrow-left',
        'label' => _('Return'),
        'menu' => true,
        'menu-lock' => true,
        'parent' => 'ROOT'
    ]
    //----------------------------------------------------------------------------------------------------
    // END OF FILE
    //----------------------------------------------------------------------------------------------------
];