<?php
namespace Epygi\Shell\Command;

use Epygi;

class Feature
{
    /**
     * feature:
     *    -a add key
     *    -d del key
     *    -k <encrypted key>
     *    -c check key
     *    -b boot mode (no other args)
     *    -t add trial version keys
     *    -p <expiration period>
     *    -e <expiration date and time>
     *    -v verify demo keys ( no other args )
     */
    const BIN_FEATURE = '/bin/feature';

    /**
     * Add a new license key.
     *
     * @param $feature_key - encrypted license key
     *
     * @return bool
     */
    public static function featureKeyAdd($feature_key)
    {
        $cmd = new Epygi\Shell\Command(self::BIN_FEATURE);
        $cmd->opt('-a');
        $cmd->opt('-k', $feature_key);

        // run
        $cmd->execute();
        return $cmd->data;
    }

    /**
     * Check a license key.
     *
     * @param $feature_key - encrypted license key
     *
     * @return bool
     */
    public static function featureKeyCheck($feature_key)
    {
        $cmd = new Epygi\Shell\Command(self::BIN_FEATURE);
        $cmd->opt('-c');
        $cmd->opt('-k', $feature_key);

        // run
        $cmd->execute();
        return $cmd->data;
    }

    /**
     * It is not documented, but I think "-q" installs a time limited key and "-x" is the key to install it after.
     *
     * @param $feature_key - encrypted license key
     * @param $after_key - key to install this one after
     *
     * @return bool
     */

    public static function featureKeyInstallAfter($feature_key, $after_key)
    {
        $cmd = new Epygi\Shell\Command(self::BIN_FEATURE);
        $cmd->opt('-q');
        $cmd->opt('-k', $feature_key);
        $cmd->opt('-x', $after_key);

        // run
        $cmd->execute();
        return $cmd->data;
    }
} 