<?php
namespace Epygi\Storage;

use Epygi\Enum\Role as ERole;

class AclDb extends StorageAbstract
{
    public static $file = '/mnt/flashfs/samdb';

    /**
     * @param $role - selected user role: "extensions", etc
     *
     * @return array - list of cginames which are enabled for the selected role
     */
    public static function getRightsEnabled($role)
    {
        // get array of all rights from acldb
        $config = ConfigFile::getInstance(static::$file);
        $rights = $config['rights']->getArray();

        // loop through and parse rights list
        $data = array();
        foreach ($rights as $cginame => $roles) {
            // convert roles string into array
            $roles = preg_split('/\s*,\s*/', $roles, 0, PREG_SPLIT_NO_EMPTY);

            // skip if the selected role is not present
            if (!$role || !in_array($role, $roles)) {
                continue;
            }

            // skip bogus cgi
            if ($cginame == '/') {
                continue;
            }

            // save this in our list
            $data[$cginame] = true;
        }

        // enabled cgis
        return $data;
    }

    public static function hasAccessRights($cgi, $role)
    {
        // get array of all rights from acldb
        $config = ConfigFile::getInstance(static::$file);
        $rights = $config['rights']->getArray();

        $roleName = '';
        switch ($role) {
            case ERole::ADMIN:
                $roleName = 'admins';
                break;
            case ERole::LOCALADMIN:
                $roleName = 'localadmins';
                break;
            case ERole::CONFERENCE:
                $roleName = 'moderators';
                break;
            case ERole::PARTICIPANT:
                $roleName = 'participants';
            break;
            case ERole::EXTENSION:
                $roleName = 'extensions';
                break;
            case ERole::SUPERADMIN:
                $roleName = 'superadmins';
                break;
        }
        // loop through and parse rights list
        $data = array();

        foreach ($rights as $cginame => $roles) {
            // convert roles string into array
            $roles = preg_split('/\s*,\s*/', $roles, 0, PREG_SPLIT_NO_EMPTY);

            // skip if the selected role is not present
            if (!in_array($roleName, $roles)) {
                continue;
            }
            // skip bogus cgi
            if ($cginame == '/') {
                continue;
            }

            if ($cginame == $cgi) {
                return true;
            }
        }
        return false;
    }
}