<?php
namespace Epygi\Webrtc;
use \DateTime;

class WebRtcGwToken
{
	const WEBRTC_AUTH_SECRET_FILE = '/var/janus/At';
	private static $secret = ''; 
	private static $timeout = 0;
    function __construct($t=24 * 60 * 60) {
		self::$timeout=$t;
		$file = fopen(self::WEBRTC_AUTH_SECRET_FILE,"r");
		self::$secret = rtrim(fgets($file));
		fclose($file);
    }

    private function makeJanusToken($realm, $timeout, $data, $secret)
    {
		if (empty($secret))
		{
			return "";
		}

		$date = new DateTime;
		$timestamp = $date->getTimestamp();
		$expiry=$timestamp+$timeout;

		$array = array(strval($expiry), $realm, $data);
		$strdata = implode(",", $array);

		$token = $strdata . ':' . base64_encode(hash_hmac ('sha1', $strdata, $secret, true));
		return $token;
    }
	public function getJanusToken($data)
    {
		return self::makeJanusToken('janus', self::$timeout, $data, self::$secret);
    }
}
