<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="./css/style.min.css" type="text/css">
    <title>WebRTC Conference</title>
</head>
<body>
    <header class="page-header">
	<?php // LOGO ?>
    <?php $isCustomLogo = Mvc\CustomLogo::isMainLogoExist(); ?>
    <?php if ( $isCustomLogo ) : ?>
  	  <a href="/home" class="customlogo"></a>
    <?php else: ?>    
      <a href="/home" class="logo"></a>
    <?php endif; ?>
    </header>
    <div class="roomjoin-popup" id="roomjoin">
        <div class="roomjoin-form">
            <div class="card-header">
                <h3 class="join-title">Join to conference room!</h3>
            </div>
            <div class="card-body">
                <form class="form" id="joinform" role="form" action="./conference.php" method="post" autocomplete="on" name="join">
                    <div class="input-group form-group">
                        <input autocomplete="on" required class="form-control" type="text" placeholder="room id" name="RoomId" id="roomid" value="<?php if(isset($_GET['id'])){echo $_GET['id'];}else{echo "";}?>">
                    </div>
                    <div class="input-group form-group">
                        <input autocomplete="off" required class="form-control" type="text" placeholder="Nickname" name="UserName" id="username" pattern="^[a-zA-Z0-9_-]*$">
                    </div>
                    <div class="input-group form-group">
                        <input autocomplete="off" class="form-control" type="password" placeholder="Password (if required)" name="UserPin" id="userpin"> <!-- pattern="[0-9]+" -->
                    </div>
                    <div class="input-group form-group">
                        <button type="submit" name="submit" class="btn btn-primary" autocomplete="off" id="register">Join now</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div id="usernames"></div>
    <script src="./js/jquery-3.3.1.min.js"></script>
    <script src="./js/main.min.js"></script>
    <script type="text/javascript">
        $("#joinform").submit(function(e) {
            var $form = $(this);
            var config = {  "confid":$("input[name='RoomId']").val(),
                            "userId":$("input[name='UserName']").val(),
                            "userpin":$("input[name='UserPin']").val()
                            };
            $.ajax({url: "auth.php",
                    method: "POST",
                    context: $form, // context will be "this" in your handlers
                    data: JSON.stringify(config),
                    contentType: "application/json; charset=utf-8",
                    dataType: 'json',
            success: function (data) {
                        this.off('submit');
                        // actually submit the form
                        document.getElementById("register").click();
                    },
            error: function (jqXHR, textStatus, errorThrown) {  
                        $("form[name='join']").css("animation", "shake 0.5s").delay(500).queue(function(){
                        $("form[name='join']").css("animation", "");
                        $("form[name='join']").focus().select();
                        $(this).dequeue();
                    }); 
                }
            });
            e.preventDefault();
            e.returnValue = false;
        });
		$( document ).ready( function(){
            <?php if (isset($_GET['id'])):?>
                $('#username').focus();
            <?php endif; ?>
		});
	</script>
</body>
</html>