<?php
/**
@overview - Epygi CRM Connect RestAPI v.1.0
- Response format may be configured by passing 'format' argument following route, for example ?format=xml. Default format is json. Currently only json is supported.
- Debug logging level is also configurable per request, for example logLevel=5.
- Example of full request - http://crmcon.epygi.com/v1/Vtiger/GetToken?format=json&logLevel=5
@author Armen Movsisyan
@version 1.0
@date March 2020
*/

//autoload of classes from ./classes directory
session_start();
error_reporting(E_ALL & ~ E_NOTICE & ~ E_DEPRECATED);
ini_set('display_errors', 0);
ini_set('html_errors', false);
ini_set('log_errors', 1);
ini_set('ignore_repeated_errors', 1);
//ini_set("error_log", "error-" . date("Ymd") . ".log");
ini_set("error_log", "crmapi.log");

set_include_path(get_include_path().PATH_SEPARATOR.'classes');
spl_autoload_extensions('.class.php');
spl_autoload_register();

function default_exception_handler(Exception $e){
   header('HTTP/1.1 500 Internal Server Error');
   header('Content-Type: application/json; charset=utf-8');
   $rawResponse = array (
                        ApiConstants::KEY_SUCCESS => false,
                        ApiConstants::KEY_ERROR => array(
                            ApiConstants::KEY_CODE => ApiConstants::GENERIC_ERROR_CODE,
                            ApiConstants::KEY_MESSAGE => ApiConstants::INTERNAL_ERROR_MESSAGE
                        )
                    );
   echo json_encode(array(ApiConstants::MESSAGE => ApiConstants::INTERNAL_ERROR_MESSAGE, ApiConstants::KEY_RAW_RESPONSE => $rawResponse));
   die();
}
set_exception_handler("default_exception_handler");

// creation of ApiMain object, the only global scope object per HTTP request;
$obj = new ApiMain();
$obj->process();
$obj = null;
