<?php

use Epygi\Mvc;
use Epygi\Shell\Command;

function SendSipIM($from, $to, $msg, $type)
{
    $cmd = new Command('/bin/notifier');
    $cmd->opt('-sendsipim');
    $cmd->opt($from);
    $cmd->opt($to);
    $cmd->opt("'" . $msg . "'");
	$cmd->opt($type);
    return $cmd->execute();
}

// Your auth token from twilio.com/user/account
//$sid = getenv('TWILIO_ACCOUNT_SID');
//$token = getenv('TWILIO_AUTH_TOKEN');
$conf = new Epygi\Storage\Sms();
$accountsid = $conf->GetTwilioSID();
$token = $conf->GetTwilioAuth();

if( empty($accountsid) || empty($token) ) {
    closelog();
    http_response_code(501);
    die("Not Implemented");
}

/*
"AccountSid": "ACxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"
"From": "+15017250604"
"MessageSid": "SM1342fe1b2c904d1ab04f0fc7a58abca9"
"MessageStatus": "sent"
"SmsSid": "SM1342fe1b2c904d1ab04f0fc7a58abca9"
"SmsStatus": "sent"
*/

if( !isset($_REQUEST['AccountSid']) || !isset($_REQUEST['MessageSid'])  ) {
    closelog();
    die();
}
if($_REQUEST['AccountSid'] != $accountsid) {
    closelog();
    die();
}

$sid = isset($_REQUEST['MessageSid']) ? $_REQUEST['MessageSid'] : "";
$status = isset($_REQUEST['MessageStatus']) ? $_REQUEST['MessageStatus'] : "";
if( empty($status) ) {
    $status = isset($_REQUEST['SmsStatus']) ? $_REQUEST['SmsStatus'] : "";
}
syslog(LOG_INFO, "SID: $sid, Status: $status");

if(!empty($status) && !empty($sid)) {
    try {
        $pdo = new PDO('sqlite:/mnt/bbram/calldata/smsdetail.db');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
	$qs='UPDATE sms SET msg_status = "' . $status . '" WHERE msg_sid == "' . $sid . '"';
        $pdo->query($qs);

        $qs='SELECT extension, msg from sms WHERE msg_sid == "' . $sid . '" AND type == "outbound"';
        $stmt = $pdo->query($qs);
        $result = [];
        while ($row = $stmt->fetch(\PDO::FETCH_ASSOC)) {
            $result[] = [
                'extension' => $row['extension'],
				'msg' => $row['msg']
            ];
        }
        $extension = $result[0]['extension'];
		$msg = $result[0]['msg'];

        if(!empty($extension) && ($status == "undelivered" || $status == "failed"))
        {
            // send back the status message in case of failure
            $from = isset($_REQUEST['To']) ? $_REQUEST['To'] : "";
            if(!empty($from) && !empty($extension))
            {
				//$errorMsg="<p style=\"color:red; font-weight: bold;\">";
				//$errorMsg=$errorMsg . "Status:" . $status . "<br>";
				//$errorMsg=$errorMsg . "Message:" . $msg;
				//$errorMsg=$errorMsg . "</p>";

				$errorMsg="Status: " . $status . "\n";
				$errorMsg=$errorMsg . "Message: " . $msg;

                SendSipIM($from, $extension, $errorMsg, "sms" );
            }
        }
    }
    catch (Exception $e) {
	    syslog(LOG_INFO, "Caught exception: $e->getMessage()");
            echo 'Caught exception: ' . $e->getMessage();
        }
}

closelog();

