<?php
namespace App\Form\Helper;

use Mvc\Tag;
use Mvc\View\AbstractHelper;

class EpyCheckBlock extends AbstractHelper
{
    private $xml = array();

    public function checkbox($field, $label)
    {
        // should the checkbox start out checked?
        $is_checked = (boolean) $this->getView()->form->$field;

        $xml = new Tag();

        // row for checkbox
        $xml->push('div', 'class', 'row');

        // checkbox and label
        $xml->push('div', 'class', 'checkbox checkblock checkblock-' . $field);
        $xml->push('label');

        // input
        $xml->append('input', 'type', 'hidden', 'name', $field, 'value', '0');
        $xml->push('input', 'type', 'checkbox', 'name', $field, 'value', '1');
        //$xml->attr('checked', 'checked', $is_checked);
        $xml->attr('checked', 'checked', $is_checked);
        $xml->pop(); // input

        $xml->text($label);
        $xml->pop(2); // label, div(checkbox)

        // finish row
        $xml->pop(); // div(row)

        // print checkbox
        print (string) $xml;
    }

    public function close()
    {
        // continue with XML block we were building
        $xml = array_pop($this->xml);

        // retrieve captured PHP output buffer and add to XML
        $xml->raw(ob_get_clean());
        $xml->pop(); // div (block)

        // print blocks
        print (string) $xml;
    }

    /**
     * @param $field
     * @param bool $enabled Whether the block should be displayed when the checkbox is ON (true) or OFF (false).
     */
    public function open($field, $enabled = true)
    {
        // start new XML block
        $xml = new Tag();
        array_push($this->xml, $xml);

        // begin div section
        $block_name = $enabled ? 'block-' . $field : 'block-inverse-' . $field;
        $xml->push('div', 'class', $block_name, 'style', 'display: none;');

        // start capturing PHP output into buffer
        ob_start();
    }

    public function radioButton($field, $label, $id = "radioid")
    {
        // should the checkbox start out checked?
        $is_checked = (boolean) $this->getView()->form->$id;

        $xml = new Tag();

        // row for checkbox
        $xml->push('div', 'class', 'row');

        // checkbox and label
        $xml->push('div', 'class', 'radiobutton checkblock checkblock-' . $field);
        $xml->push('label');

        // input
        //$xml->append('input', 'type', 'hidden', 'name', $field, 'checked',$is_checked);
        //$xml->append('input', 'type', 'hidden', 'name', $field, 'value', '0');
        $xml->push('input', 'type', 'radio', 'name', $field, 'value', '1');
        $xml->attr('checked', 'checked', $is_checked);
        $xml->attr('id', $id);
        $xml->pop(); // input

        $xml->text($label);
        $xml->pop(2); // label, div(checkbox)

        // finish row
        $xml->pop(); // div(row)

        // print checkbox
        print (string) $xml;
    }
}