<?php
namespace App\Index;

use Epygi;
use Mvc;
use Epygi\Enum\Role as ERole;

class Login2faForm extends LoginForm
{
    public function execute()
    {
		if ($_SERVER['REQUEST_METHOD'] === 'POST') {
		//something posted

		if (isset($_POST['sendviaemail'])) {
			// btnDelete
		} else {
			//assume btnSubmit
		}
		}
		$username = Epygi\Auth::Get2faLoginUser();
		$role = Epygi\Auth::Get2faLoginUserRole();
		$oneTimePassword = Epygi\Auth::GetOneTimePassword($username);
		if($oneTimePassword != $this->oneTimePassword) {
			header('Location: /logout');
			exit;
		}
		Epygi\Auth::logIn($this->username, $role);
		
		if($role != ERole::SUPERADMIN) {
			// log event
			$message = _('Authentication success for user %s (peer IP=%s)');
			$message = sprintf($message, Epygi\Auth::getUsername(), Mvc\Param::server('REMOTE_ADDR'));
			Epygi\Shell\Command\RaiseEvent::raiseEvent('system', 'login', $message);
		}

        // if we wanted a specific page, redirect to the page we originally wanted
        Epygi\Auth::wantUriRedirect();

        // redirect to the /home url which will again redirect to the proper first page
        header('Location: /home');
        exit;
    }

    /**
     * remove all session data on page load
     */
    protected function onFirstLoad()
    {

    }
    protected function prepare()
    {
        // reset
        $this->clear('oneTimePassword');  
    }
}
