<?php
include_once (dirname(__FILE__) . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR .  "CtlValidations.php");

class SalesForceController_v1 extends BaseController {

    public function __construct(ApiRequest $apiRequest, BaseModel $modelObj) {
        parent::__construct($apiRequest,$modelObj);

        $this->registerEndpoint("GetToken", "POST", array(
            array(ApiConstants::ARG_NAME=>"clientId", ApiConstants::ARG_ALIAS=>"clientId", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"clientSecret", ApiConstants::ARG_ALIAS=>"clientSecret", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"username", ApiConstants::ARG_ALIAS=>"username", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"password", ApiConstants::ARG_ALIAS=>"password", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"securityToken", ApiConstants::ARG_ALIAS=>"securityToken", ApiConstants::ARG_REGEX => '/^.*$/'),
        ));

        $this->registerEndpoint("ListObjects", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
        ));

        $this->registerEndpoint("Describe", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"sobject", ApiConstants::ARG_ALIAS=>"sobject", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => 'Contact'),
        ));

        $this->registerEndpoint("GetContactInfo", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"phoneNumber", ApiConstants::ARG_ALIAS=>"phoneNumber", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"sobjects", ApiConstants::ARG_ALIAS=>"sobjects", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_ISARRAY => CtlValidations_v1::sObjects(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"searchPhoneTypes", ApiConstants::ARG_ALIAS=>"searchPhoneTypes", ApiConstants::ARG_ISARRAY => CtlValidations_v1::PhoneTypes(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"mandatoryFields", ApiConstants::ARG_ALIAS=>"mandatoryFields", ApiConstants::ARG_ISARRAY => CtlValidations_v1::MandatoryFields(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"minNumOfMatchedDigits", ApiConstants::ARG_ALIAS=>"minNumOfMatchedDigits", ApiConstants::ARG_REGEX => '/^[0-9]*$/', ApiConstants::ARG_DEFAULT => 3),
            array(ApiConstants::ARG_NAME=>"exactMatch", ApiConstants::ARG_ALIAS=>"exactMatch", ApiConstants::ARG_DEFAULT => false),
        ));

        $this->registerEndpoint("GetMandatoryFields", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"sobjects", ApiConstants::ARG_ALIAS=>"sobjects", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_ISARRAY => CtlValidations_v1::sObjects(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"userDefinedMandatoryFields", ApiConstants::ARG_ALIAS=>"userDefinedMandatoryFields", ApiConstants::ARG_ISARRAY => CtlValidations_v1::MandatoryFields(), ApiConstants::ARG_DEFAULT => array())
        ));

        $this->registerEndpoint("GetPhonetypeFields", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"sobjects", ApiConstants::ARG_ALIAS=>"sobjects", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_ISARRAY => CtlValidations_v1::sObjects(), ApiConstants::ARG_DEFAULT => array()),
        ));

        $this->registerEndpoint("GetListOfFields", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"sobjects", ApiConstants::ARG_ALIAS=>"sobjects", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_ISARRAY => CtlValidations_v1::sObjects(), ApiConstants::ARG_DEFAULT => array()),
        ));
    
        $this->registerEndpoint("GetResourceInfo", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"sobjects", ApiConstants::ARG_ALIAS=>"sobjects", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_ISARRAY => CtlValidations_v1::sObjects(), ApiConstants::ARG_DEFAULT => array('Contact', 'Lead')),
        ));

        $this->registerEndpoint("CreateContact", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"loginUserName", ApiConstants::ARG_ALIAS=>"loginUserName", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"recordType", ApiConstants::ARG_ALIAS=>"recordType", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_REGEX => '/^(Contact|Lead)$/'),
            array(ApiConstants::ARG_NAME=>"FirstName", ApiConstants::ARG_ALIAS=>"FirstName", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"LastName", ApiConstants::ARG_ALIAS=>"LastName", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"MobilePhone", ApiConstants::ARG_ALIAS=>"MobilePhone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"Phone", ApiConstants::ARG_ALIAS=>"Phone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"HomePhone", ApiConstants::ARG_ALIAS=>"HomePhone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"AssistantPhone", ApiConstants::ARG_ALIAS=>"AssistantPhone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"OtherPhone", ApiConstants::ARG_ALIAS=>"OtherPhone", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"Fax", ApiConstants::ARG_ALIAS=>"Fax", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"Email", ApiConstants::ARG_ALIAS=>"Email", ApiConstants::ARG_REGEX => '/^[A-Za-z0-9-_.+%]+@[A-Za-z0-9-.]+.[A-Za-z]{2,4}$|^ $/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"Description", ApiConstants::ARG_ALIAS=>"Description", ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"OwnerName", ApiConstants::ARG_ALIAS=>"OwnerName", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"OwnerId", ApiConstants::ARG_ALIAS=>"OwnerId", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"customManadatoryFields", ApiConstants::ARG_ALIAS=>"customManadatoryFields", ApiConstants::ARG_ISARRAY => CtlValidations_v1::CustomManadatoryFields(), ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"id", ApiConstants::ARG_ALIAS=>"id", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
        ));

        $this->registerEndpoint("PutCDR", "POST", array(
            array(ApiConstants::ARG_NAME=>"instanceUrl", ApiConstants::ARG_ALIAS=>"instanceUrl", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"phoneNumber", ApiConstants::ARG_ALIAS=>"phoneNumber", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"searchPhoneTypes", ApiConstants::ARG_ALIAS=>"searchPhoneTypes", ApiConstants::ARG_ISARRAY => CtlValidations_v1::PhoneTypes(), ApiConstants::ARG_DEFAULT => array()),
            array(ApiConstants::ARG_NAME=>"ActivityDateTime", ApiConstants::ARG_ALIAS=>"ActivityDateTime", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"Subject", ApiConstants::ARG_ALIAS=>"Subject", ApiConstants::ARG_REGEX => '/^.*$/'),
            array(ApiConstants::ARG_NAME=>"DurationInMinutes", ApiConstants::ARG_ALIAS=>"DurationInMinutes", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
            array(ApiConstants::ARG_NAME=>"Description", ApiConstants::ARG_ALIAS=>"Description", ApiConstants::ARG_REGEX => '/^.*$/', ApiConstants::ARG_DEFAULT => ''),
        ));
    }
}
?>
