<?php
namespace App\Form\Helper;

use Epygi;
use Mvc;

class EpyForm extends Mvc\View\AbstractHelper
{
    private $xml = null;
    private $form = null;

    public function __invoke()
    {
        // form object
        $this->form = $this->getView()->form;

        // return reference to this instance
        return $this;
    }

    public function buttons($label_submit = 'Submit', $label_previous = '', $inverse = false)
    {
        $xml = new Mvc\Tag();

        // start the bottom buttons
        $xml->push('div', 'class', 'row button-container');

        // previous
        if ($label_previous && !$this->form->isFirstStep()) {
            $xml->push('input', 'type', 'submit', 'class', 'btn btn-default btn-sm');
            $xml->attr('name', Epygi\Form\Engine::TOKEN_PREVIOUS, 'value', $label_previous);
            $xml->pop(); // input
        }

        // next
        if ($label_submit) {
            $style = $inverse ? 'btn-inverse' : 'btn-primary';
            $xml->push('input', 'type', 'submit', 'class', 'btn ' . $style);
            $xml->attr('name', Epygi\Form\Engine::TOKEN_NEXT, 'value', $label_submit);
            $xml->pop(); // input
        }

        // finish 'div'
        $xml->text('');
        $xml->pop(); // div
        return (string) $xml;
    }

    public function close()
    {
        // retrieve captured PHP output buffer
        $data = ob_get_clean();

        // continue with XML block we were building
        $xml = $this->xml;

        // add captured buffer to XML output and print
        $xml->raw($data);
        $xml->pop(); // form
        print (string) $xml;
    }

    public function errors()
    {
        // nothing to do if no errors
        $form = $this->form;
        if ($form->isFirstLoad() || !$form->hasError()) {
            return '';
        }

        // build error message box
        $bold = _('We were unable to process your request.');
        $xml = new Mvc\Tag('div');
        $xml->text(_('Please correct the errors below, and resubmit your request.'));

        // system error text goes in red error box
        $syserr = $form->getMarkedError('syserr');
        if ($syserr) {
            $xml->push('ul');
            $xml->push('li');
            $xml->text($syserr);
            $xml->pop(2); // li, ul
        }

        // render error box
        return Epygi\View\GlobalError::renderError('', $bold, (string) $xml);
    }

    public function open($attr = array())
    {
        // params
        $url = Epygi\Url::getPath();
        $step_name = $this->form->getStepName();

        // generate form tag
        $xml = new Mvc\Tag('form', 'action', $url, 'method', 'post');
        $xml->attr('class', 'epyform epygi-form form-horizontal', 'role', 'form');
        $xml->attr('name', 'epyform', 'id', 'epyform');

        //// turn off autocomplete (especially for login page)
        //$xml->attr('autocomplete', 'off', isset($attr['autocomplete']) && !$attr['autocomplete']);

        // use multipart (for file uploads)
        $want_multipart = isset($attr['multipart']) ? true : false;
        $xml->attr('enctype', 'multipart/form-data', $want_multipart);

        // hidden self load trigger
        $xml->append('input', 'type', 'hidden', 'class', 'hidden', 'name', 'action', 'value', $step_name);

        // begin capturing HTML output
        $this->xml = $xml;
        ob_start();
    }
}