<?php
namespace Epygi;

use Mvc;

class Console
{
    public static function findAvailableConsoles()
    {
        $available_consoles = array();
        $host_address = $_SERVER['SERVER_ADDR'];
        if (Mvc\Feature::hasCloudOwnService()) {
            $host_address = Mvc\Config::getHostname() . '.' . Mvc\Config::getDomainname();
        }

        if (Mvc\FeatureUtils::getAcdClientFeatureCount() > 0) {
            $available_consoles["EAC"] = array(
                'name' => "EAC",
                'url' => '/acd' );
                /* 'url' => 'http://' . $host_address . '/acd' ); */
        }

        if (Mvc\FeatureUtils::getAOCFeatureCount() > 0) {
            $available_consoles["AOC"] = array(
                'name' => "AOC",
                'url' => '/aoc' );
                /* 'url' => 'http://' . $host_address . '/aoc' ); */
        }

        if (Mvc\FeatureUtils::getCRMFeatureCount() > 0) {
            $available_consoles["CRM"] = array(
                'name' => "CRM",
                'url' => 'http://' . $host_address . '/crmconnect' );
        }

        // WebRTC conference room
        /*
        if (Mvc\Feature::isEnabledWebRtcGateway()) {
            $available_consoles["CR"] = array(
            'name' => "CR",
            'url' => '/cr' );
	}
	*/
        // these are our valid consoles
        return $available_consoles;
    }

    public static function getConsoleName($console)
    {
        $consoles = array(
            'AOC' => 'Automatic Outbound Calling',
            'EAC' => 'Epygi ACD Console',
            'CR'  => 'Conference Room',
            'CRM' => 'Epygi CRM Connection',
        );

        return isset($consoles[$console]) ? $consoles[$console] : 'Unknown console';
    }
}