<?php
namespace Epygi\Storage;

class LineDb extends StorageAbstract
{
    public static $file = '/etc/fiad-conf/telephony/linedb';
    /**
     *  @return true if there is onboard isdn lines on device, otherwise false;
    */
	public static function hasIsdnLines( )
    {
        $config = ConfigFile::getInstance(static::$file);
        $entries = $config['general']->getArray();     
		return (( $entries['isdn_on'] == '1' ) && ( $entries['num_of_isdn'] > 0 ));
	}
    /**
    *  @return true if IP line sip username and password are match
    */
    public static function authIPlineUser($sipuser, $passwd)
    {
        $config = ConfigFile::getInstance(static::$file);
        $sections = $config->sections();
        foreach ($sections as $section) {
            $sec = $section->getArray();
            if(isset($sec["sip_line_username"]))
            {
                if($sec["sip_line_username"] == $sipuser)
                {
                    $realPass = "";
                    try {
                        if(\Epygi\Shell\Command\CheckSAM::decryptPass($sec["sip_line_password"], $realPass) != 0) {
                            return false;
                        }
                    }
                    catch(\Exception $e) {
                        return false;
                    }

                    if($realPass == $passwd)
                    {
                        return true;
                    }
                }
            }
        }
        return false;
	}     
}