<?php
namespace Epygi\View;

use Exception;
use Mvc\Tag;

class MessageBox
{
    private $style = 'info';
    private $bullets_started = false;

    public $important = '';
    public $bold = '';
    public $XML;

    public static function error($important, $bold, $text)
    {
        return self :: renderMessageBox('danger', $important, $bold, $text);
    }

    public static function info($important, $bold, $text)
    {
        return self :: renderMessageBox('info', $important, $bold, $text);
    }

    public static function ok($important, $bold, $text)
    {
        return self :: renderMessageBox('success', $important, $bold, $text);
    }

    private static function renderMessageBox($style, $important, $bold, $text)
    {
        $xml = new Tag('div', 'class', 'alert alert-dismissable alert-' . $style);

        // close button
        $xml->push('button', 'type', 'button', 'class', 'close', 'data-dismiss', 'alert', 'aria-hidden', 'true');
        $xml->raw('&times;');
        $xml->pop(); // button

        // text
        if ($important) {
            $xml->push('span', 'class', 'important pull-left');
            $xml->text($important);
            $xml->pop(); // span
        }

        if ($bold) {
            $xml->push('strong', 'class', 'pull-left');
            $xml->text($bold);
            $xml->raw('&nbsp;');
            $xml->pop(); // strong
        }
        $xml->raw($text);

        // end message box
        $xml->pop(); // div

        return (string) $xml;
    }

    public static function warn($important, $bold, $text)
    {
        return self :: renderMessageBox('warn', $important, $bold, $text);
    }

    public function __construct($style)
    {
        // holds the text body
        $this->XML = new Tag('div', 'class', 'messagebox');

        // style
        if ($style == 'info' || $style == 'error' || $style == 'ok' || $style == 'warn') {
            $this->style = $style;
        }
        else {
            throw new Exception('unknown style');
        }
    }

    public function bold($text)
    {
        $this->bold = $text;
    }

    public function bullet($text)
    {
        if (!$this->bullets_started) {
            $this->XML->push('ul');
            $this->bullets_started = true;
        }

        // add bullet
        $this->XML->append('li', $text);
    }

    public function draw()
    {
        print $this->toString();
    }

    public function head($text)
    {
        $this->important = $text;
    }

    public function text($text)
    {
        $this->XML->text($text);
    }

    public function toString()
    {
        return self :: renderMessageBox($this->style, $this->important, $this->bold, (string) $this->XML);
    }
}