<?php
namespace Mvc;

use Epygi;
use Epygi\Storage;
use Epygi\Storage\ConfigFactory;

class FeatureUtils
{
    const FEATURES_STATUS_FILE = '/tmp/featurestatus.conf';

    private $configs = array();

    protected function __construct()
    {
		if( file_exists ( self::FEATURES_STATUS_FILE ) ) {
			// load entire config file
			$lines = file(self::FEATURES_STATUS_FILE);
			// process each config file line
			foreach ($lines as $line) {
			// split on the "=" character
			$parts = preg_split('/=/', trim($line), 2);

			// if we have 2 parts, the first part is the key and the second is the value
				if (count($parts) == 2) {
					$this->configs[$parts[0]] = $parts[1];
				}
			}
		}
    }

    /**
     */
    protected function get($key)
    {
	if (empty($this->configs)) {
		 return 0;
	}
	if( isset($this->configs[$key]) )	        
	{
	    if( $this->configs[$key] == 'true' )
		return 1;
	    else	
		return 0;
	}
	else
	{
	    return null;
	}
    }

    protected function getInt($key)
    {
	if (empty($this->configs)) {
		 return 0;
	}
	if( isset($this->configs[$key]) )	        
	{
	    return intval($this->configs[$key]);
	}
	else
	{
	    return null;
	}
    }

    /**
     * @return bool - true if product supports feature, false if product does not support feature
     */
    protected function getBoolFeature($feature)
    {
        return (boolean) $this->get('SEC_START_' . strtoupper($feature));
    }

    /**
     * @return count of activated feature. 0 - no feature
     */
    protected function getCountFeature($feature)
    {
        return $this->getInt('SEC_NUM_' . strtoupper($feature));
    }

    /**
     * Treat the feature class as a singleton.  We create just 1 instance and reuse references to that instance.
     * @return FeatureUtils - instance of the feature config class
     */
    protected static function getInstance()
    {
        static $obj = null;
        return $obj ? : $obj = new self();
    }

    public static function isEnabled3pcc()
    {
        return self::getInstance()->getBoolFeature('3PCC');
    }

    public static function isEnabledAcd()
    {
        return self::getInstance()->getBoolFeature('ACD');
    }

    public static function getAcdClientFeatureCount()
    {
	return self::getInstance()->getCountFeature('ACD_CLIENT');
    }

    public static function getAOCFeatureCount()
    {
	return self::getInstance()->getCountFeature('AOC');
    }

    public static function getCRMFeatureCount()
    {
	return self::getInstance()->getCountFeature('CRM_INTEGRATION');
    }

    public static function isEnabledBargeIn()
    {
        return self::getInstance()->getBoolFeature('BARGEIN');
    }

    public static function isEnabledVpn()
    {
        return self::getInstance()->getBoolFeature('VPN');
    }
    
    public static function isPPTPEnabled( )
    {
	$pBxMode 	= false;
        $rc 	   	= Epygi\Storage\ConfigFactory::rc();                                                                                                  
	$swap_interface = $rc->getBool('SWAP_INTERFACES');
	
	if( isset( $swap_interface ) )	        
	{
	    if( $swap_interface == true )
	    	$pBxMode = true;
	}
        return ( self::isEnabledVpn( ) && ( !$pBxMode) );
    }

    public static function isPmsServerEnabled( )
    {
        if( !self::getInstance()->getBoolFeature('PMS_SERVER_R1') )
        {    
            $count = self::getInstance()->getCountFeature('PMS_SERVER');
            if( is_numeric( $count )) 
                return ( $count > 0 );
            else
                return false;
        }
        else
        {
            return true;            
        }    
    }
    
    public static function hasAdditionalIPPhones( )
    {
        $count = self::getInstance()->getCountFeature('ADD_IP_PHONES');
        if( is_numeric( $count )) 
            return ( $count > 0 );
        else
            return false;
    }    
    
    public static function isVlanConfigured( )
    {
        $vlanConfig = Epygi\Storage\ConfigFactory::vlan();
        foreach ($vlanConfig as $section) {
            if (!$section->isEmpty( ) ) {
                return true;
            }
        }
        return false;
    }

    public static function isEnabledCallCost()
    {
        return self::getInstance()->getBoolFeature('CALL_COST');
    }

    public static function isEnabledSmsForExtensions( )
    {
        $count = self::getInstance()->getCountFeature('SMS_EXTENSION');
        if( is_numeric( $count )) 
            return ( $count > 0 );
        else
            return false;
    }
}