<?php

use Epygi\Storage;
use Epygi\Shell\Command;

/** 
 * Get header Authorization
 * */
function getAuthorizationHeader(){
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    }
    else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
        $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
        //print_r($requestHeaders);
        if (isset($requestHeaders['Authorization'])) {
            $headers = trim($requestHeaders['Authorization']);
        }
    }
    return $headers;
}

/**
 * get access token from header
 * */
function getBearerToken() {
    $headers = getAuthorizationHeader();
    // HEADER: Get the access token from the header
    if (!empty($headers)) {
        if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
            return $matches[1];
        }
    }
    return null;
}

function SendSipSMS($from, $to, $msg, $msgSid, $msgStatus)
{
    $cmd = new Command('/bin/notifier');
    $cmd->opt('-sendsipimfromdim');
    $cmd->opt($from);
    $cmd->opt($to);
    $cmd->opt("\"$msg\"");
    $cmd->opt("\"$msgSid\"");
    $cmd->opt("\"$msgStatus\"");
    return $cmd->execute();
}


// Takes raw data from the request
$json = file_get_contents('php://input');

// For Debug
//file_put_contents('/tmp/clearfly',$json,FILE_APPEND);
//file_put_contents('/tmp/clearfly',PHP_EOL,FILE_APPEND);
//

$jsonArray = json_decode($json, true);

$conf = new Epygi\Storage\Sms();
$webhookToken = $conf->GetClearflyWebhookToken();
$bearerToken = getBearerToken();

if ( $bearerToken === null || empty($bearerToken) || !isset($bearerToken) ){
    header('HTTP/1.0 401 Unauthorized');
    die("Unauthorized");
}

if( $webhookToken != $bearerToken ) {
        header('HTTP/1.0 401 Unauthorized');
    die("Unauthorized");
}
// example:
// {"body":"message text","conversation":"OkkkkkL5ZoST1hiK0f-IsffU=","from":"+XXXXXXXXXXX","media_urls":[],"message_id":617630,"msg_to":["+YYYYYYYYYYY"],"to":"+YYYYYYYYYYY"}

if(isset($jsonArray["body"]))
{
	$body = $jsonArray["body"];
}
else
{
	http_response_code(400);
	die("body is not set");
}

$from = isset($jsonArray["from"])?$jsonArray["from"]:"";
$to = isset($jsonArray["to"])?$jsonArray["to"]:"";
if($to == "")
{
	$to = isset($jsonArray["msg_to"])?$jsonArray["msg_to"]:"";
}
$conversationid = isset($jsonArray["conversation"])?$jsonArray["conversation"]:"";
$msgSid = isset($jsonArray["message_id"])?$jsonArray["message_id"]:"";

if($from == "" || $to == "")
{
	http_response_code(400);
	die("from or to not set");
}

if($msgSid == "")
{
	http_response_code(400);
	die("message_id is not set");
}

syslog(LOG_INFO, "Inbound SMS From: $from To: $to msgSid: $msgSid") ;
$res=SendSipSMS($from,$to,$body,$msgSid,"");
syslog(LOG_INFO, "Sending IM to sip From: $from To: $to res=$res") ;
http_response_code(200);
