<?php
namespace App\Network;

use Epygi;
use Mvc;

class VlanGrid extends Epygi\Grid\Engine
{
    // default order
    protected $default_order_field = 'position';
    protected $default_order_direction = 1;

    public function callbackDelete($ids)
    {
        foreach ($ids as $id) {
            Epygi\View\GlobalError::error(sprintf(_('Function not written to delete VLAN (#%d)'), $id));
            // remove VLAN

            //        // remove location
            //        $result = Query\Location::locationDelete($id);
            //
            //        // failed
            //        if (!$result) {
            //            GlobalError::error(sprintf('Unable to delete location #%d', $id));
            //        }
            //        // success
            //        else {
            //            GlobalError::success(sprintf('Successfully removed location #%d', $id));
            //        }
        }
    }

    public function init()
    {
        // filter
        $this->filter
            ->add('all', 'All')
            ->add('vlanid', 'VLAN ID')
            ->add('interface', 'Interface');

        // actions
        $this->action->add(
            array('ADD', 'New VLAN', 'none', '/vlan-add', 'fa fa-plus')
        );

        $edit_url = '/vlan-edit?SmartCheckbox_[selection]=[selection]&callerPath=/network/vlan';
        $this->action->add(
            array('EDIT', 'Edit', 'single', $edit_url),
            array(
                array('DELETE', 'Delete', 'multiple', null, 'fa fa-trash-o')
            )
        );
    }

    public function loadRecords()
    {
        $config = Epygi\Storage\ConfigFactory::vlan();

        $data = array();
        foreach ($config as $section) {
            $data[] = array(
                'interface' => $section->get('interface'),
                'ipaddress' => $section->get('ipaddress'),
                'label' => 'VLAN ' . $section->get('vlanid'),
                'netmask' => $section->get('netmask'),
                'priority' => $section->get('priority'),
                'section_id' => $section->get('section_id'),
                'state' => $section->get('state'),
                'vlanid' => $section->get('vlanid'),
            );
        }
        return $data;
    }
}