<?php
namespace Epygi\Webrtc;
use Mvc;
use PDO;

class Click2Call
{
    const WEBRTC_CLICK_TO_CALL_SDN = 'webrtcclick2calldb';
    private static $PDO = null;

    function __construct() {
        self::getConnection();
    }

    static public function getConnection($force = false)
    {
        if ($force || !self::$PDO) {
            $dbFile = Mvc\Config::getDb(self::WEBRTC_CLICK_TO_CALL_SDN);
            if($dbFile){
                $pdo = self::$PDO = new PDO($dbFile);
                $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            }
        }
        if (!self::$PDO) {
            throw new Exception('connection failed!');
        }
        return self::$PDO;
    }

    public static function getConfig($id)
    {
        $jsonstring="";
        self::getConnection();
        if (!self::$PDO) {
            return $jsonstring;
        }
        $gwToken = new WebRtcGwToken();
        $token = $gwToken->getJanusToken('janus.plugin.sip');
        try{
			$result = self::$PDO->query('SELECT * FROM sip WHERE sip.ID == "' . $id . '"');
			foreach($result as $row) {
				if ($id == $row['ID']) {
					$config = array(
						'caller' => $row['ID'],
						'callee' => $row['SIPURL'],
						'digits' => $row['DIGITS'],
						'options' => $row['OPTIONS'],
						'token' => $token
					);
					$jsonstring = json_encode($config);
					break;
				}
			}
			
			// If ID does not found, search for ID:* SIPURL:* rule. If found, the SIPURL will be the ID from the URL 
			if($jsonstring == "")
			{
				$result = self::$PDO->query('SELECT * FROM sip WHERE sip.ID == "*" AND sip.SIPURL == "*"');
				foreach($result as $row) {
					if ($row['ID'] == "*") {
						$config = array(
							'caller' => $id,
							'callee' => $id,
							'digits' => $row['DIGITS'],
							'options' => $row['OPTIONS'],
							'token' => $token
						);
						$jsonstring = json_encode($config);
						break;
					}
				}	
			}
        } catch (Exception $e) {
            echo 'Caught exception: ' . $e->getMessage();
        }

        return $jsonstring;
    }
}
