<?php
namespace Mvc\View;

class Placeholder extends AbstractHelper
{
    private static $instances = array();
    private $data = '';

    public function __construct($name)
    {
        $this->name = $name;
    }

    public function __toString()
    {
        return $this->data;
    }

    public function captureEnd()
    {
        $this->data = ob_get_clean();
    }

    public function captureStart()
    {
        ob_start();
    }

    public static function getInstance($name)
    {
        // create a new instance of placeholder
        if (!isset(self::$instances[$name])) {
            self::$instances[$name] = new self($name);
        }

        // return named instance
        return self::$instances[$name];
    }
}