<?php
namespace App\Maintenance;

use Epygi;
use Mvc;

class DiagnosticsForm extends Epygi\Form\AbstractForm
{
    private function execDownloadSystemLogs()
    {
        $url = new Epygi\Url('/systemlogsdownload');
        $url->attr('WBG_sid', Epygi\Auth::getCgiSessionId());
        $url->attr('id', 0);
        header('Location: ' . (string) $url);
        exit;
    }

    public function execute()
    {
        Epygi\View\GlobalError::success('Data validated successfully!');
        return true;
    }

    protected function onFirstLoad()
    {
        // reset
        $this->clear();

        //$this->confirmusbtestbtn = _('Yes');
        //$this->cancelusbtestbtn = _('No');
        //$this->testusbflash = _('Start USB Flash Memory Testing');
        //$this->wanprotocol = _('Start detecting WAN Protocol');
    }

    protected function prepare()
    {
        // do we have a command to execute?
        $this->hasAccessRights= Epygi\Storage\AclDb::hasAccessRights('diagnostics', Epygi\Auth::getRole());

        $command_method = Mvc\Param::request('command');

        $this->command_url = false;
        switch ($command_method) {
            case 'downloadLogsButton':
                $this->execDownloadSystemLogs();
                break;

            case 'diagnet':
            case 'diage1t1':
            case 'diagfan':
            case 'diagisdn':
            case 'diagfxo':
                $url = new Epygi\Url('/maintenance/diag-command');
                $url->attr('method', $command_method);
                $this->command_url = (string) $url;
                break;
        }

        //if (Mvc\Param::request('wanprotocol') == _('Start detecting WAN Protocol')) {
        //    $method = 'diagwan';
        //}
        //$this->showusbtestdialog = false;
        //
        //if (Mvc\Param::request('testusbflash') == _('Start USB Flash Memory Testing')) {
        //    $this->showusbtestdialog = true;
        //}
        //
        //else if (Mvc\Param::request('confirmusbtestbtn') == _('Yes')) {
        //    // generate URL to our ping command url
        //    $this->command_url = false;
        //    if ($this->target) {
        //        $url = new Epygi\Url ('/maintenance/testusbflash-command');
        //        $this->command_url = ( string ) $url;
        //    }
        //}
    }
}