<?php

abstract class BaseController  {

    protected  $args;
    protected  $endpointsArray;
    protected  $modelObj;
    protected  $log;
    protected  $endpoint;
    protected  $endpointUnDashed;
    protected  $method;

    public function __construct($apiRequestObj, $modelObj) {
        $this->log = $apiRequestObj->getLogObj();
        $this->endpoint = $apiRequestObj->getEndpoint();
        $this->endpointUnDashed = $apiRequestObj->getUnDashedMethod($this->endpoint);
        $this->method = $apiRequestObj->getMethod();
        $this->modelObj = $modelObj;
        $this->endpointsArray = array();
        $this->args = array();
    }

    public function execute() {
      $this->log->add(__FILE__ . ":" . __LINE__ ." starting validateEndpoint");
      $this->validateEndpoint();
      $this->log->add(__FILE__ . ":". __LINE__ . "\nEndpoint Arguments:\n" . print_r($this->args,true) . "Endpoint Headers:\n" . print_r(getallheaders(), true), LogMgmt::LVL_INFO, LogMgmt::SECTION_ARGUMENTS);
      $this->log->add(__FILE__ . ":" . __LINE__ ." starting modelObj..execute");
      return $this->modelObj->execute($this->endpointUnDashed, $this->args);
    }

    protected function registerEndpoint($endpoint, $method, $args = array(), $argsType = ApiConstants::FORMAT_X_WWW_FORM) {
      $this->endpointsArray[$endpoint] = array(ApiConstants::ENDPOINT => $endpoint, ApiConstants::METHOD => $method, ApiConstants::ARGUMENTS => $args);
    }

    // simple recursion to validate the individual arguments
    // Enum requires an array of allowed values
    protected function validateArguments($argDescArr, &$argValuesArr){
       $this->log->add(__FILE__ . ":". __LINE__ . " argDescArr:" . print_r($argDescArr,true) . " argValuesArr:" . print_r($argValuesArr,true));
       foreach($argDescArr as $argDesciptor) {
         if ($argDesciptor[ApiConstants::BODY_KEY_NEEDS_TO_BE_ADDED]) {
             $argValuesArr = array($argDesciptor[ApiConstants::ARG_NAME] => $argValuesArr);
         }
         if(empty($argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]]) && strlen($argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]]) == 0) {
            if(isset($argDesciptor[ApiConstants::ARG_DEFAULT])) {
               $this->args[$argDesciptor[ApiConstants::ARG_ALIAS]] = $argDesciptor[ApiConstants::ARG_DEFAULT];
            } else {
               throw new ApiException(Messages::ARGUMENT_NOT_SET . " - " . $this->endpoint . ": " . $argDesciptor[ApiConstants::ARG_ALIAS], ApiConstants::http_Bad_Request);
            }
         } else if (isset($argDesciptor[ApiConstants::ARG_ENUM])) {
            $ok= false; // no matching enum found
            foreach($argDesciptor[ApiConstants::ARG_ENUM] as $enum_val){
               $ok = ($ok || (strtolower($enum_val) === strtolower($argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]])));
            }
            if(!$ok) {// no matching enum found
               throw new ApiException(Messages::INVALID_ENUM_VALUE . " - " . $this->endpoint . ": " . $argDesciptor[ApiConstants::ARG_ALIAS], ApiConstants::http_Bad_Request);
            }
         } else if (isset($argDesciptor[ApiConstants::ARG_ISARRAY])) {
            $argsArr = $argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]];
            if(!is_array($argsArr)) {
               throw new ApiException(Messages::INVALID_ARRAY_VALUE . " - " . $this->endpoint . ": " . $argDesciptor[ApiConstants::ARG_ALIAS], ApiConstants::http_Bad_Request);
            }
            foreach($argsArr as $arg) {
               $this->validateArguments($argDesciptor[ApiConstants::ARG_ISARRAY], $arg);
            }
         } else if (isset($argDesciptor[ApiConstants::ARG_COMPLEX])) {
            $this->validateArguments($argDesciptor[ApiConstants::ARG_COMPLEX], $argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]]);
         } else {
           if (isset($argDesciptor[ApiConstants::ARG_REGEX]) && preg_match($argDesciptor[ApiConstants::ARG_REGEX], $argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]]) !== 1) {
               throw new ApiException(Messages::INVALID_ARGUMENT_VALUE . " - " . $argDesciptor[ApiConstants::ARG_ALIAS] . ": " . $argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]],
                 ApiConstants::http_Bad_Request);
           }
           $this->args[$argDesciptor[ApiConstants::ARG_ALIAS]] = $argValuesArr[$argDesciptor[ApiConstants::ARG_NAME]];
         }
       }
    }
    
    public function getEndpointsArray(){
       return $this->endpointsArray;
    }

    public function endpointGetDefaultArgType($arr, $method){
        if (empty($arr[ApiConstants::ARG_TYPE])){
            if ($method == 'GET'){
                $default = ApiConstants::FORMAT_X_WWW_FORM;
            } else {
                $default = ApiConstants::FORMAT_JSON;
            }
        } else{
            $default = $arr[ApiConstants::ARG_TYPE];
        }

        return $default;
    }

    protected function validateEndpoint() {
       $tmpArgs = array(ApiConstants::FORMAT_X_WWW_FORM => array(), ApiConstants::FORMAT_JSON => array());
       $tmp_epDefn_www_form = $tmp_epDefn_json = array();
       $epDefn = $this->endpointsArray[$this->endpoint];
       if (($epDefn) && ($epDefn[ApiConstants::METHOD] == $this->method)) {
            foreach ($epDefn[ApiConstants::ARGUMENTS] as $key=>$arr){
                $epDefn[ApiConstants::ARGUMENTS][$key][ApiConstants::ARG_TYPE] = $this->endpointGetDefaultArgType($arr, $epDefn[ApiConstants::METHOD]);
                if ($epDefn[ApiConstants::ARGUMENTS][$key][ApiConstants::ARG_TYPE] == ApiConstants::FORMAT_X_WWW_FORM){
                    $tmp_epDefn_www_form[] = $arr;
                } elseif ($epDefn[ApiConstants::ARGUMENTS][$key][ApiConstants::ARG_TYPE] == ApiConstants::FORMAT_JSON){
                    $tmp_epDefn_json[] = $arr;
                }
            }

            // if ARG_TYPE == ApiConstants::FORMAT_X_WWW_FORM
            $this->validateAgainstExtraParmsInURL($tmp_epDefn_www_form);
            if(count($tmp_epDefn_www_form)) {
              unset($this->args);
              $this->args = $_REQUEST;
              $this->log->add(__FILE__ . ":" . __LINE__ . " argSource:" . print_r($this->args,true));
              $this->validateArguments($tmp_epDefn_www_form, $this->args);
              $tmpArgs[ApiConstants::FORMAT_X_WWW_FORM] = $this->args;
            }

            // if ARG_TYPE == ApiConstants::FORMAT_JSON
            if(count($tmp_epDefn_json)) {
              $postdata = file_get_contents('php://input');
              unset($this->args);
              $this->args = json_decode($postdata, true);
              $this->log->add(__FILE__ . ":" . __LINE__ ." postdata:" . print_r($postdata,true) . "; argSource:" . print_r($this->args,true));
              if(!$this->args) {
                throw new ApiException(Messages::JSON_ARGUMENTS_INVALID, ApiConstants::http_Bad_Request);
              }
              $this->validateArguments($tmp_epDefn_json, $this->args);
              $tmpArgs[ApiConstants::FORMAT_JSON] = $this->args;
            } /*else { //xml??
                $this->log->add(__FILE__ . ":" . __LINE__ ." xml?:");
            }*/

            unset($this->args);
            if (($commonParms = array_intersect_key($tmpArgs[ApiConstants::FORMAT_X_WWW_FORM], $tmpArgs[ApiConstants::FORMAT_JSON])) !== array()) {
                throw new ApiException(Messages::COMMON_PARAMETERS_ERR, ApiConstants::http_Bad_Request, array("Common Parameters" => $commonParms));
            }

            $this->args = array_merge($tmpArgs[ApiConstants::FORMAT_X_WWW_FORM], $tmpArgs[ApiConstants::FORMAT_JSON]);
            return; //validation is passed
      }
      throw new ApiException(Messages::ENDPOINT_NOT_FOUND_FOR_METHOD . " - " . $this->endpoint . ": " . $this->method, ApiConstants::http_Bad_Request);
    }

    private function validateAgainstExtraParmsInURL ($argDescArr) {
        $keys = array('arg1', 'arg2', 'arg3', 'arg4');
        $tmp = array();
        foreach ($keys as $key) {
            if (strlen($_GET[$key]) > 0) {
                $tmp[$key] = $_GET[$key];
            }
        }
        if (count($argDescArr) < count($tmp)){
            throw new ApiException(Messages::REQUESTED_URL_NOT_FOUND, ApiConstants::http_Not_Found, ": ". $_SERVER[REQUEST_URI] . "; Extra arguments found in URL");
        }
    }
}
