<?php

use Epygi\Storage;
use Epygi\Shell\Command;

function SendSipSMS($from, $to, $msg, $msgSid, $msgStatus)
{
    $cmd = new Command('/bin/notifier'); 
    $cmd->opt('-sendsipimfromdim'); 
    $cmd->opt($from); 
    $cmd->opt($to); 
    $cmd->opt("\"$msg\""); 
    $cmd->opt("\"$msgSid\"");
    $cmd->opt("\"$msgStatus\"");
    return $cmd->execute();
}


// Your auth token from twilio.com/user/account
//$sid = getenv('TWILIO_ACCOUNT_SID');
//$token = getenv('TWILIO_AUTH_TOKEN');
$conf = new Epygi\Storage\Sms();
$sid = $conf->GetTwilioSID();
$token = $conf->GetTwilioAuth();

if( empty($sid) || empty($token) ) {
    closelog();
    die();
}

require_once '/usr/www/gui/library/Twilio/autoload.php';

use Twilio\Security\RequestValidator;
use Twilio\TwiML\MessagingResponse;


// The X-Twilio-Signature header
$signature = isset($_SERVER["HTTP_X_TWILIO_SIGNATURE"]) ? $_SERVER["HTTP_X_TWILIO_SIGNATURE"] : "";

// Initialize the validator
$validator = new RequestValidator($token);

// The Twilio request URL. You may be able to retrieve this from
$url = $_SERVER['SCRIPT_URI'];

// The post variables in the Twilio request. You may be able to use
$postVars = $_POST;

if ($validator->validate($signature, $url, $postVars)) {
    $from = $postVars["From"];
    $to = $postVars["To"];
    $body = $postVars["Body"];
    $msgSid = isset($postVars["MessageSid"])?$postVars["MessageSid"]:"";
    $msgStatus = isset($postVars["SmsStatus"])?$postVars["SmsStatus"]:"";
    syslog(LOG_INFO, "Inbound SMS From: $from To: $to msgSid: $msgSid SmsStatus: $msgStatus") ;
    $res=SendSipSMS($from,$to,$body,$msgSid,$msgStatus);
    syslog(LOG_INFO, "Sending IM to sip From: $from To: $to res=$res") ;
    
    header('Content-Type: text/xml');
    $response = new MessagingResponse();
    echo $response;
} else {
    //echo "NOT VALID. It might have been spoofed!";
    header('HTTP/1.0 401 Unauthorized');
    closelog();
    die("Unauthorized");
}
closelog();

