<?php
namespace Epygi\Shell\Command;

use Epygi\Shell\Command;

class Ip
{
    const DEBUG = 1;

    const BIN_IP = '/bin/ip';
    const BIN_GREP = '/bin/grep';
    const BIN_CUT = '/bin/cut';

    /* Get Device Mac Address
     * @return string
     */
    public static function getMyMacAddress()
    {
        //Remote IP
        $ip_addr = \Mvc\Param::server('REMOTE_ADDR');

        // find neighbors
        $cmd = new Command(self::BIN_IP);
        $cmd->arg('neighbour');
        $cmd->arg('show');

        // filter only reachable ones
        $cmd->pipe(self::BIN_GREP);
        $cmd->opt('-i', 'reachable');

        // find the one for this IP address
        $cmd->pipe(self::BIN_GREP);
        $cmd->arg($ip_addr);

        // extract mac address
        $cmd->pipe(self::BIN_CUT);
        $cmd->opt('-f', 5);
        $cmd->opt('-d', ' ');
        //$cmd->verbose(true);

        // run
        $cmd->execute();
        return implode($cmd->data);
    }
}