<?php
namespace Epygi\View;

use Mvc\Session;
use Mvc\Tag;

class GlobalError
{
    public static function error($message)
    {
        return self::saveMessage('error', $message);
    }

    private static function getSession()
    {
        static $session = null;
        return $session ? : new Session(__CLASS__);
    }

    public static function hasErrors()
    {
        $session = self::getSession();
        return (boolean) $session->error || (boolean) $session->info || (boolean) $session->success;
    }

    public static function info($message)
    {
        return self::saveMessage('info', $message);
    }

    private static function messagesToHtml($messages)
    {
        $xml = new Tag();

        //// build error message box
        //$XML = new Tag('div');

        // success text goes in green error box
        // $XML->push('ul');

        foreach ($messages as $message) {
            $message = unserialize($message);
            $xml->push('div');
            // $XML->push('li');

            if ($message instanceof Tag) {
                // xhtml object
                $xml->raw((string) $message);
            }

            else {
                // standard text
                $xml->text($message);
            }

            $xml->pop(); // div
        }

        return (string) $xml;
    }

    public static function render()
    {
        // session
        $session = self::getSession();

        $out = '';

        // error message
        if ($session->error) {
            $out .= self::renderMessageBox('danger', '', _('Error: '), self::messagesToHtml($session->error));
            $session->error = null;
        }

        // info message
        if ($session->info) {
            $out .= self::renderMessageBox('info', '', _('Info: '), self::messagesToHtml($session->info));
            $session->info = null;
        }

        // success message
        if ($session->success) {
            $out .= self::renderMessageBox('success', '', _('Success! '), self::messagesToHtml($session->success));
            $session->success = null;
        }

        return $out;
    }

    public static function renderError($important, $bold, $text)
    {
        return self::renderMessageBox('danger', $important, $bold, $text);
    }

    private static function renderMessageBox($style, $important, $bold, $text)
    {
        $xml = new Tag('div', 'class', 'alert alert-dismissable alert-' . $style);

        // close button
        $xml->push('button', 'type', 'button', 'class', 'close', 'data-dismiss', 'alert', 'aria-hidden', 'true');
        $xml->raw('&times;');
        $xml->pop(); // button

        // text
        if ($important) {
            $xml->push('span', 'class', 'important pull-left');
            $xml->text($important);
            $xml->pop(); // span
        }

        if ($bold) {
            $xml->push('strong', 'class', 'pull-left');
            $xml->text($bold);
            $xml->raw('&nbsp;');
            $xml->pop(); // strong
        }
        $xml->raw($text);

        // end message box
        $xml->pop(); // div

        return (string) $xml;
    }

    private static function saveMessage($type, $message)
    {
        // session
        $session = self::getSession();
        $values = $session->$type;

        // make sure session stores an array of info messages
        if (!is_array($values)) {
            $values = array();
        }

        // save the success message in our session
        $values[] = serialize($message);
        $session->$type = $values;
    }

    public static function success($message)
    {
        self::saveMessage('success', $message);
    }

    public static function warn($important, $bold, $text)
    {
        return self::renderMessageBox('warn', $important, $bold, $text);
    }
}