<?php

namespace Epygi\Shell;

class Exec
{
    private $qid;
    private $method;

    public function __construct($command, $qid, $method = null)
    {
        /**
         * this is important! We must turn off output buffering and flush all existing buffers.
         * Then, the output
         * MUST be set to text/html for browsers to respond appropriately.
         */
        header('Content-type: text/html; charset=utf-8');
        ob_end_clean();
        ob_implicit_flush(true);

        $this->qid = $qid;
        $this->method = $method;
        //
        exec($command);
    }

    private function htmlEnd()
    {
        echo "\ndone.\n</body></html>";
        echo "\n";
        flush();
    }

    /**
     * In another life, we will put this into a template file and not embed the style directly into this class, but
     * for today, we are feeling rushed and little naughty.
     * Git-er-done!
     */
    private function htmlStart()
    {
        echo '<html><head><style>div { font: normal 14px "Courier New"; }</style></head><body>';
        echo "\n";
        flush();
    }

    public function process()
    {
        // start html output
        $this->htmlStart();

        // Sendoptions
        $serialize_needed = false; // Must the transfer data be serialized ?
        $block_send = false; // Block if Message could not be send (Queue full...) (true/false)
        $msgtype_send = 0; // Any Integer above 0. It signeds every Message. So you could handle multible message
        // type in one Queue.

        // Receiveoptions
        $msgtype_receive = 0; // Whiche type of Message we want to receive ? (Here, the type is the same as the type we send,
        // but if you set this to 0 you receive the next Message in the Queue with any type.
        $maxsize = 1024; // How long is the maximal data you like to receive.
        $option_receive = 0; // If there are no messages of the wanted type in the Queue continue without wating.
        // If is set to NULL wait for a Message.

        $queue = msg_get_queue($this->qid, 0666);

        while (1) {
            $queue_status = msg_stat_queue($queue);
            msg_receive($queue, $msgtype_receive, $msgtype_send, $maxsize, $msg, false, 0, $err);
            if ($err) {
                print "Received $err fetching message";
                print '<br/>';
                break;
            }
            if ($msgtype_send == 100) //the 'd' char
            {
                $startpos = 0;
                $newmsg = '';
                $findpos = 0;
                $msg = substr($msg, 0, strlen($msg) - 3);
                $msg = preg_replace('/\\\n/', '<br/>', $msg);

                print $msg;
                flush();
                //usleep(30000);
            }
            elseif ($msgtype_send == 99) //the 'c' char
            {
                // close page message
                break;
            }
        }
        msg_remove_queue($queue);
        // end html output
        $this->htmlEnd();
    }
}
