<?php
namespace Epygi\Storage;

use Epygi;
use Mvc;

class SessionData
{
    /**
     * Remove session details
     *
     * @param $session_id - user session id
     *
     * @return ConfigFile
     */
    public static function removeSession($session_id)
    {
        $config = ConfigFactory::sessionDataDb();
        unset ($config[$session_id]);
        $config->save();
    }

    public static function setLocale($session_id, $locale)
    {
        // no session id, nothing to do
        if (!$session_id) {
            return false;
        }

        // update the expire timestamp
        $config = ConfigFactory::sessionDataDb();
        $config[$session_id]->LANG = $locale;
        $config->save();
        return true;
    }
    public static function getLocale($session_id)
    {
        // no session id, nothing to do
        if (!$session_id) {
            return null;
        }

        $config = ConfigFactory::sessionDataDb();
        if( isset( $config[$session_id]) )
        {
          return $config[$session_id]->LANG;   
        }
        return null;
    }
    /**
     * @param $session_id - session id
     * @param $username - username
     * @param $user_role - User role
     * @param $expire_timestamp - Expired time stamp
     */
    public static function setSession($session_id, $username, $user_role, $expire_timestamp)
    {
        // load user selected locale and apply to logged in session
        $user_locale = Epygi\Locale::getLocale();
        $user_locale = ($user_locale == 'en_US') ? 'C' : $user_locale;

        // new session section should use 'sid' prefix
        $config = ConfigFactory::sessionDataDb();
        $section = $config[$session_id];
        $section->setLabel('sid');

        // set session values
        $section->set('USERNAME', $username);
        $section->set('REMOTE_ADDR', '127.0.0.1');
        //$section->set('REMOTE_CLIENT_ADDR', Mvc\Param::server('REMOTE_ADDR'));
        $section->set('REMOTE_CLIENT_ADDR', Mvc\Param::getRemoteIpAddress());
        $section->set('REMOTE_PORT', Mvc\Param::server('REMOTE_PORT' ));
        $section->set('LANG', $user_locale);
        $section->set('THEME', ROOT_DIR . '/public/factorythemes/Wrapper');
        $section->set('ROLE', $user_role);
        $section->set('EXPIRY', $expire_timestamp);

        // save
        $config->save();
    }

    /**
     * @param $session_id - session id
     * @param $expire_timestamp - Expired time stamp
     *
     * @return bool
     */
    public static function updateSessionTime($session_id, $expire_timestamp)
    {
        // no session id, nothing to do
        if (!$session_id) {
            return false;
        }

        // update the expire timestamp
        $config = ConfigFactory::sessionDataDb();
        $config[$session_id]->EXPIRY = $expire_timestamp;
        $config->save();
        return true;
    }

    public static function removeExpiredSessions()
    {
        $config = ConfigFactory::sessionDataDb();
        $currtime = time();
        $dosave = false;
        $sections = $config->sections();
        foreach ($sections as $index => $section) {
            $expiry = $section->getint("EXPIRY");
            if ($expiry && $expiry < $currtime) {
                $dosave = true;
                unset($config[$section->getName()]);
            }
        }
        if ($dosave) {
            $config->save();
        }
    }
}