<?php
namespace Epygi\Grid;

use Epygi;
use Exception;
use Mvc;

class Action
{
    private $actions = array();
    private $toolbar = array();

    /**
     * Builds the "action" drop-down menu.
     * @throws \Exception
     */
    public function add()
    {
        $args = func_get_args();

        $actions = array();
        foreach ($args as $arg) {
            // make sure we have an action record
            if (!is_array($arg)) {
                throw new Exception ('invalid action definition!');
            }

            // "more" drop down
            if (is_array($arg[0])) {
                $more = array();
                foreach ($arg as $more_arg) {
                    $action = array_shift($more_arg);
                    $this->addAction($action, $more_arg);
                    $more[] = $action;
                }
                $actions[] = $more;
            }

            // regular action button
            else {
                $action = array_shift($arg);
                $this->addAction($action, $arg);
                $actions[] = $action;
            }
        }

        // add these action to our toolbar
        $this->toolbar[] = $actions;
    }

    public function addAction($action, $rec)
    {
        // params
        $label = array_shift($rec);
        $type = array_shift($rec);
        $url = array_shift($rec);
        $icon = array_shift($rec);

        // format params
        $action = strtoupper($action);

        // invalid "type"
        if (!in_array($type, array('none', 'single', 'multiple'))) {
            throw new Exception('Unsupported action type: ' . $type);
        }

        // drop-down actions
        $this->actions[$action] = array(
            'icon' => $icon,
            'label' => $label,
            'type' => $type,
            'url' => $url
        );

        // chaining
        return $this;
    }

    public function getAction($action)
    {
        // invalid action
        if (!isset($this->actions[$action])) {
            return array(null, null, null, null);
        }

        // return action data
        $a = $this->actions[$action];
        return array($action, $a['label'], $a['type'], $a['icon']);
    }

    public function getToolbarGroups()
    {
        return $this->toolbar;
    }

    public function process(Engine $grid)
    {
        // get action and selections
        $action = strtoupper(Mvc\Param::request('actiontype'));
        $selections = (string) Mvc\Param::request('actiondata');

        $selections = preg_split('/\s*,\s*/', $selections, 0, PREG_SPLIT_NO_EMPTY);
        $selections = array_unique($selections);

        // read action data
        $info = isset($this->actions[$action]) ? $this->actions[$action] : false;

        // we don't have an action record defined (quick sanity check to bail early)
        if (!$info) {
            return false;
        }

        // handle redirect to URL
        if ($info['url']) {
            // rewrite the URI
            $url = Epygi\String::merge($info['url'], array('selection' => array_shift($selections)));

            // redirect and exit
            header('Location: ' . $url);
            exit;
        }

        // handle special 'none' and 'group' types
        switch ($info['type']) {
            case 'single' :
            case 'none':
            case 'multiple':
                $callback = 'callback' . ucfirst(strtolower($action));

                if (!method_exists($grid, $callback)) {
                    throw new Exception("unhandled callback method {$callback}");
                }

                // call the user's callback method
                return call_user_func(array($grid, $callback), $selections);
        }

        // WTF!
        throw new Exception('unhandled action process');
    }
}