<!DOCTYPE html>
<html style="--safe-area-inset-top:env(safe-area-inset-top); --safe-area-inset-right:env(safe-area-inset-right); --safe-area-inset-bottom:env(safe-area-inset-bottom); --safe-area-inset-left:env(safe-area-inset-left);" lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="./css/jquery-ui.min.css">
    <link rel="stylesheet" href="./css/style.min.css" type="text/css">
    <!-- alertify -->
    <link rel="stylesheet" href="./css/alertify.min.css"/>
    <link rel="stylesheet" href="./css/themes/default.min.css"/>
    <link rel="stylesheet" href="./css/themes/semantic.min.css"/>
    <link rel="stylesheet" href="./css/themes/bootstrap.min.css"/>
    <link rel="stylesheet" href="./css/alertify.rtl.min.css"/>
    <link rel="stylesheet" href="./css/themes/default.rtl.min.css"/>
    <link rel="stylesheet" href="./css/themes/semantic.rtl.min.css"/>
    <link rel="stylesheet" href="./css/themes/bootstrap.rtl.min.css"/>
    <link href="./css/jquery.lsxemojipicker.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/css/toastr-2.1.3.min.css" />
    <link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/w3-css/4.1.0/w3.min.css" integrity="sha512-Z6UIAdEZ7JNzeX5M/c5QZj+oqbldGD+E8xJEoOwAx5e0phH7kdjsWULGeK5l2UjehKtChHDaUY2rQAF/NEiI9w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <title>WebRTC Conference</title>
</head>
<body>
    <header class="page-header">
	<?php // LOGO ?>
    <?php $isCustomLogo = Mvc\CustomLogo::isMainLogoExist(); ?>
    <?php if ( $isCustomLogo ) : ?>
  	  <a href="/home" class="customlogo"></a>
    <?php else: ?>    
      <a href="/home" class="logo"></a>
    <?php endif; ?>
    <div class="header-right" >
    <table class="pull-left" >
    <tbody><tr>
    <td>
        <div>
            <div class="dropdown">
                <button class="dropbtn"><?=_("Share");?></button>
                <div class="dropdown-content">
                    <a class="fa fa-link fa-lg" id="shareLink" aria-hidden="true"></a>
                    <a class="fa fa-envelope fa-lg" id="shareEmail" href="#" aria-hidden="true" target="_blank"></a>
                    <a class="fab fa-viber fa-lg" id="shareViber" href="#" aria-hidden="true" target="_blank"></a>
                    <a class="fab fa-whatsapp fa-lg" id="shareWhatsapp" href="#" aria-hidden="true" target="_blank"></a>
                    <!--a class="fas fa-phone fa-lg" id="shareSip" href="#" aria-hidden="true"></a-->
                </div>
            </div>
        </div>
    </td>
    <td class="settingsicon" id="settingsicon">
        <div class="big-icon">
            <a href="#" class="fas fa-cogs"></a>
        </div>
    </td>
    <td class="auth">
        <div><?=_("Me:");?></div>
        <em id="myname"></em>
    </td>
    <td class="exit">
        <div class="big-icon">
            <a href="#" class="fas fa-sign-out-alt" onClick="exitRoom();"></a>
        </div>
        <a href="#" onClick="exitRoom();"><?=_("Exit");?></a>
    </td>
    </tr>
    </tbody>
    </table>
    </div>
    </div>
    </header>
    <div class="page-content">
        <div class="chat" id="chat">
            <div class="chat-close">
                <div class="closeicon"></div>
            </div>
            <div class="message-list" id="chatroom">
            </div>
            <form class="write-message" action="">
                <div class="message-section">
                <div class="sendbtncontainer">
                <span id="picker">&#128515</span>
                <button id="sendMessage" onClick="return chatRoomSendData();"></button>
                </div>
                    <textarea placeholder="Enter message" id="datasend"></textarea>
                </div>
            </form>
        </div>

        <div id="settings" class="w3-modal">
            <div class="w3-modal-content w3-animate-zoom">
                <header class="w3-container w3-grey">
                    <span onclick="document.getElementById('settings').style.display='none'" class="w3-button w3-display-topright">&times;</span>
                    <h6><?=_("Settings");?></h6>
                </header>
                <div class="w3-row w3-padding-16">
                    <div class="w3-col w3-container m6 s3">
                        <label class="w3-col m6 s3 w3-padding-small w3-margin-bottom settingslabel" for="audio-device"><?=_("Select Microphone");?></label>
                        <div class="w3-col m6 s3 w3-margin-bottom select">
                            <select id="audio-device"></select>
                        </div>
                        <label class="w3-col m6 s3 w3-padding-small w3-margin-bottom settingslabel" for="video-device"><?=_("Select Camera");?></label>
                            <div class="w3-col m6 s3 w3-margin-bottom select">
                                <select id="video-device"></select>
                        </div>
                        <div class="w3-col s6 m12 l12">
                            
                        </div>
                    </div>
                </div>
                <footer class="w3-modal-container w3-container w3-padding-16">
                    <div id="change-devices" class="button-primary"><?=_("Change devices");?></div>
                </footer>
            </div>
        </div>
        <div id="shareSipModal" class="w3-modal">
            <div class="w3-modal-content w3-animate-zoom">
                <header class="w3-container">
                    <span  id="shareSipModalclose" class="w3-button w3-display-topright">&times;</span>
                    <h6><?=_("Number to call");?></h6>
                </header>
                <div class="w3-center w3-col w3-container m6 16">
                    <input id="shareSipDial" class="w3-input w3-border" type="text">
                </div>
            </div>
        </div>
        <div class="conference" id="conference">
            <div class="hide" id="sipvideoright"></div>
			<div class="hide" id="sipvideoleft"></div>
            <div class="webcam" id="videolocal"></div>
            <div class="chaticon" id="chaticon"></div>
            <!--div class="videos" id="remotes"></div-->
            <div class="grid" id="remotes"></div>
            <div class="control-buttons">
                <div class="button microphone" id="micrphone" onClick="toggleMute();"></div>
                <div class="button speaker" id="speaker" onClick="toggleMuteRemote();"></div>
                <div class="button videocamera" id="videocamera" onClick="return toggleVideo();"></div>
                <div class="button screenshare off" id="screenshare" onClick="return toggleScreenShare();"></div>
                <div class="button dialpad" id="dialpad"></div>
                <div class="button red exit" id="exitroom" onClick="exitRoom();"></div>
                <div class="dialap-buttons-wrapper" id="dialUpButtons">
                    <div class="dialap-buttons" id="keypad">
                        <button data-id="1"><span>1</span></button>
                        <button data-id="2"><span>2</span></button>
                        <button data-id="3"><span>3</span></button>
                        <button data-id="4"><span>4</span></button>
                        <button data-id="5"><span>5</span></button>
                        <button data-id="6"><span>6</span></button>
                        <button data-id="7"><span>7</span></button>
                        <button data-id="8"><span>8</span></button>
                        <button data-id="9"><span>9</span></button>
                        <button data-id="*"><span>*</span></button>
                        <button data-id="0"><span>0</span></button>
                        <button data-id="#"><span>#</span></button>
                    </div>
                    <div class="dialap-arrow-bottom"></div>
                </div>
            </div>
    </div>

    <script src="/js/adapter-7.4.0.min.js"></script>
    <script src="./js/jquery-3.3.1.min.js"></script>
    <script src="./js/jquery-ui.min.js" type="text/javascript"></script>
    <script src="/js/jquery.blockUI.min.js"></script>
    <script src="./js/rtcgw.min.js"></script>
    <script src="./js/twemoji.min.js"></script>
    <script src="./js/jquery.lsxemojipicker.min.js"></script>
    <script src="./js/alertify.min.js"></script>
    <script src="./js/app.min.js?ver=1.0.2"></script>
    <script src="./js/main.min.js?ver=1"></script>
    <script src="./js/draggabilly.pkgd.min.js"></script>
    <script src="./js/packery.pkgd.min.js"></script>
    <script src="/js/toastr-2.1.3.min.js"></script>
	<script>
		$( document ).ready( function(){
        <?php
        try{
            $confid = (isset($_POST['RoomId']))?$_POST['RoomId']:"";
		    $userId = (isset($_POST['UserName']))?$_POST['UserName']:"";
		    $userpin = (isset($_POST['UserPin']))?$_POST['UserPin']:"";
            $config = array(
			    "confid" => $confid,
			    "userId" => $userId,
			    "userpin" => $userpin
			    );
                ?>
                login(<?php echo json_encode($config) ?>);
                <?php
            } catch (Exception $e) {
                header("Location: index.php");
                die();
            }
        ?>
		});
	</script>
</body>
</html>