<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<meta name="viewport" content="width=1024" />
    <link rel="stylesheet" href="/css/theme-main.min.css" />
    <title>
        <?=htmlspecialchars(Mvc\Config::getProductName(), ENT_QUOTES); ?> <?=htmlspecialchars(_('Click to call'), ENT_QUOTES); ?>
    </title>
    <?php $isChangedFavicon = Mvc\CustomLogo::isSiteIconExist(); ?>
    <?php if ( $isChangedFavicon ) : ?>
    <link rel="shortcut icon" href="/img/logo/uploadedfavicon.ico" />
    <?php else: ?>
    <link rel="shortcut icon" href="/favicon.ico" />
    <?php endif; ?>
	<link rel="stylesheet" href="/css/theme-main.min.css" />
    <?php
    function getUrlOrigin($s, $use_forwarded_host = false)
    {
        $ssl      = (!empty($s['HTTPS']) && $s['HTTPS'] == 'on') ? true : false;
        $sp       = strtolower($s['SERVER_PROTOCOL']);
        $protocol = substr($sp, 0, strpos($sp, '/')) . (($ssl) ? 's' : '');
        $port     = $s['SERVER_PORT'];
        $port     = ((!$ssl && $port == '80') || ($ssl && $port == '443')) ? '' : ':' . $port;
        $host     = ($use_forwarded_host && isset($s['HTTP_X_FORWARDED_HOST'])) ? $s['HTTP_X_FORWARDED_HOST'] : (isset($s['HTTP_HOST']) ? $s['HTTP_HOST'] : null);
        $host     = isset($host) ? $host : $s['SERVER_NAME'] . $port;
        return $protocol . '://' . $host;
    }
    function getFullUrl($s, $use_forwarded_host = false)
    {
    return getUrlOrigin($s, $use_forwarded_host) . $s['REQUEST_URI'];
    }
    function getId()
    {
        $absolute_url = getFullUrl($_SERVER);
        $str = rtrim($absolute_url, '/');
        $str = explode('/', $str);
        $id  = end(($str));
        $id = urldecode($id);
        return $id;
    }
    ?>
</head>
<body>
<div id="tpl-nav" class="stick-top">
</div>
    <div id="tpl-page">
	<div id="tpl-title">
	</div>
		<div id="tpl-content">
        <div id="videos" class="hide">
			<div class="col-md-6">
				<div class="panel panel-default">
					<div class="panel-heading">
						<h3 class="panel-title">You</h3>
					</div>
					<div class="panel-body" id="videoleft"></div>
				</div>
			</div>
			<div class="col-md-6">
				<div class="panel panel-default">
					<div class="panel-heading">
						<h3 class="panel-title">Remote UA</h3>
					</div>
					<div class="panel-body" id="videoright"></div>
				</div>
			</div>
			</div>
			<div id="btnGroup" class="btn-group-vertical hide">
                <div class="dialap-buttons-wrapper" id="dialUpButtons">
                    <button type="button" class="btn btn-danger hangupbutton" autocomplet="off" id="btnHangUp" onclick='doHangup();'><?=htmlspecialchars(_('Hang Up'), ENT_QUOTES); ?></button>
                    <div class="dialap-buttons" id="keypad">
                        <button data-id="1"  onclick="sipSendDTMF('1');"><span>1</span></button>
                        <button data-id="2"  onclick="sipSendDTMF('2');"><span>2</span></button>
                        <button data-id="3"  onclick="sipSendDTMF('3');"><span>3</span></button>
                        <button data-id="4"  onclick="sipSendDTMF('4');"><span>4</span></button>
                        <button data-id="5"  onclick="sipSendDTMF('5');"><span>5</span></button>
                        <button data-id="6"  onclick="sipSendDTMF('6');"><span>6</span></button>
                        <button data-id="7"  onclick="sipSendDTMF('7');"><span>7</span></button>
                        <button data-id="8"  onclick="sipSendDTMF('8');"><span>8</span></button>
                        <button data-id="9"  onclick="sipSendDTMF('9');"><span>9</span></button>
                        <button data-id="*"  onclick="sipSendDTMF('*');"><span>*</span></button>
                        <button data-id="0"  onclick="sipSendDTMF('0');"><span>0</span></button>
                        <button data-id="#"  onclick="sipSendDTMF('#');"><span>#</span></button>
                    </div>
                </div>
			</div>
		</div>
    </div>

	<script src="/js/adapter-6.0.3.min.js"></script>
	<script src="/js/jquery-2.1.0.min.js"></script>
	<script src="/js/bootstrap.min.js"></script>
	<script src="/js/toastr-2.1.3.min.js"></script>
	<script src="/js/janus.min.js"></script>
    <script src="js/ctc.min.js"></script>
	<link rel="stylesheet" href="/css/toastr-2.1.3.min.css" />
	<link rel="stylesheet" href="css/ctc.min.css" />
    <footer></footer>

    <script>
        $(window).resize(function () {
            var obj = $('#tpl-page');
            obj.css({
                display: 'block',
                top: ($(window).height() - obj.outerHeight()) / 2
            });
        });
        $(document).ready(function () {
            $(window).resize();
            c2c_call(<?php echo Epygi\Webrtc\Click2Call::getConfig(getId()); ?>);
            $('#btnHangUp').focus();
        });
    </script>
</body>
</html>
