<?php

// Print error page for responses from CGIs  
// Currently this page is for 500 errors from CGIs
$ERROR_CODES = array(
'500' => array(
  'Internal Server Error', 
  'INTERROR'),
'413' => array(
  'Request Entity Too Large', 
  'INTERROR'),
);
// Prints out the html for the error
// Input parameter is status code
function print_html ($VAR_C){
	global $VAR_REQUEST_METHOD, $VAR_REASON_PHRASE, $VAR_MESSAGE;
	if($VAR_C && $VAR_REASON_PHRASE){
		@header("Connection: close",1);
		echo"<!DOCTYPE html><html lang=\"en\"><head><meta charset=\"utf-8\" />";
		echo "<title>$VAR_C $VAR_REASON_PHRASE</title>";
		echo "<link rel=\"stylesheet\" href=\"/css/theme-error404.min.css\" />";
		echo "</head><body><div class=\"alert alert-danger\">$VAR_REASON_PHRASE</h1>";
		echo "<p>$VAR_MESSAGE</p><div class=\"btn-toolbar pull-right\" role=\"toolbar\">";
		echo "<div class=\"btn-group\">";
		echo "<a href=\"javascript:window.history.back()\" class=\"btn btn-default btn-sm pull-right\"><i class=\"fa fa-arrow-left\"></i> Go Back</a>";
		echo "</div><div class=\"btn-group\">";
		echo "<a href=\"/\" class=\"btn btn-default btn-sm pull-right\"><i class=\"fa fa-home\"></i> Go Home</a>";
		echo "</div></div></div></body></html>";
		return true;
	}
	else 
	{ 
		return false; 
	}
}
// Determine the error status code
if(isset($_SERVER['REDIRECT_STATUS']) && $_SERVER['REDIRECT_STATUS']!='200') {
$VAR_STATUS_CODE = $_SERVER['REDIRECT_STATUS'];
$VAR_REQUEST_METHOD = $_SERVER['REQUEST_METHOD'];
$VAR_THE_REQUEST = htmlentities(strip_tags($_SERVER['REQUEST_URI']));
$VAR_REASON_PHRASE = $ERROR_CODES[$VAR_STATUS_CODE][0];
$VAR_M_SR=array(array('INTERROR','REQURID','THEREQMETH'),
array(_('The server encountered an internal error or misconfiguration ').
_('and was unable to complete your request.'),$VAR_THE_REQUEST,$VAR_REQUEST_METHOD));
$VAR_MESSAGE=str_replace($VAR_M_SR[0],$VAR_M_SR[1],$ERROR_CODES[$VAR_STATUS_CODE][1]);
// Send headers and response
ob_start();
@header("HTTP/1.1 $VAR_STATUS_CODE $VAR_REASON_PHRASE",1);
@header("Status: $VAR_STATUS_CODE $VAR_REASON_PHRASE",1);
}else{
$VAR_STATUS_CODE = "";
ob_start();
header("Location: /index/notfound");
}
if(!print_html($VAR_STATUS_CODE)){
// Redirect to /index/notfound for unknown status codes
header("Location: /index/notfound");
}
