#!/bin/bash

LOGGER="/bin/logger -t openVPN"

timestamp=$(date +"%s")
time=$(echo $(date +"%c"))

get_client_connected_since()
{
local input_file=/tmp/logs/openvpn-status.log

local time_t=""
local client_name=$1
while read line; do
	line=$(grep -v HEADER <<< "$line")
	line=$(grep CLIENT_LIST <<< "$line")
	if [ ! -z "$line" ]; then
		line=$(echo "$line" | grep -w "$client_name")
		if [ ! -z "$line" ]; then
			# CLIENT_LIST Common Name Real Address Virtual Address Virtual IPv6 Address Bytes Received Bytes Sent Connected Since Connected Since (time_t)
			# CLIENT_LIST QxClient1 192.168.0.12:57193 10.26.0.150 26821 10260 Fri Sep 30 11:25:57 2022 1664522757 UNDEF 8 0
			time_t=$(echo "$line" | awk '{print$12}')
			date -d @$time_t > /dev/null 2>&1
			if [ $? -ne 0 ]; then
				$time_t = ""
			fi
			break
		fi
	fi
done < $input_file
echo $time_t
}

connected_since=$(get_client_connected_since "$common_name")
if [ ! -z "$connected_since" ]; then
	if [ $time_unix -lt $connected_since ]; then
		$LOGGER Got Client disconnect event delaed: ignore the event. Connected since: [$(date -d @$connected_since)] Real Address[$untrusted_ip] Virtual Address[$ifconfig_pool_remote_ip] CommonName[$common_name]
		exit 0
	fi
fi

$LOGGER Client disconnected: Connected since: [$(date -d @$time_unix)] Real Address[$untrusted_ip] Virtual Address[$ifconfig_pool_remote_ip] CommonName[$common_name]

/bin/raise_event -a OpenVPNServer -n "client disconnected" -t "Connected since: [$(date -d @$time_unix)] Real Address[$untrusted_ip] Virtual Address[$ifconfig_pool_remote_ip] CommonName[$common_name]"  > /dev/null 2>&1
