<?php
namespace Epygi;

use Mvc;

class Help
{

    /**
     * get file path for a cgi
     *
     * @param $cgi_name - name of cgi page
     *
     * @return string - absolute path to help file
     */
    public static function getHelpFile($cgi_name = null)
    {
        // find current page URI or passed in cgi name
        $router = Mvc\Router::getInstance();
        $cgi_name = $cgi_name ? : $router->getSelectedUri();

        // help pages will be under the helproot for the cgi page
        $helproot = $router->getAttributeRecursive('helproot', $cgi_name);

        // convert path names to lowercase and smooth out query strings
        $path = preg_replace('/[_\W]+/', '-', strtolower(basename($cgi_name)));

        // help file will be located here in the assets folder
        $help_file = 'help' . '/' . $helproot . '/' . $path;

        // find the absolute path to the help file under the assets folder (file has .phtml extension)
        return Mvc\Application::findAssetFile('view', $help_file);
    }

    /**
     * @param null $cgi_name - name of cgi page
     *
     * @return string - url of help page
     */
    public static function getHelpUrl($cgi_name = null)
    {
        // find current page URI or passed in cgi name
        $router = Mvc\Router::getInstance();
        $cgi_name = $cgi_name ? : $router->getSelectedUri();

        // help pages will be under the helproot for the cgi page
        $helproot = $router->getAttributeRecursive('helproot', $cgi_name);

        // convert path names to lowercase and smooth out query strings
        $path = preg_replace('/[_\W]+/', '-', strtolower(basename($cgi_name)));

        // return the URL to the help page
        return '/help/' . $helproot . '/' . $path;
    }

    /**
     * Check if the current cgi has help page or not.
     *
     * @param $cgi_name - name of cgi page
     *
     * @return bool
     */
    public static function hasHelp($cgi_name = null)
    {
        // where should the help file be located if it did exist?
        $help_file = self::getHelpFile($cgi_name);

        // does that file actually exist?
        return file_exists($help_file);
    }

    /**
     * @param $cgi_name - name of cgi page
     *
     * @return bool
     */
    public static function needHelp($cgi_name)
    {
        // any cginame that contains a DOT character is just a menu placeholder and does not need a help page
        return preg_match('#\.#', $cgi_name) ? false : true;
    }

    /**
    * @param $query - string to find
    *
    * @return search result
    */
    public static function searchHelp($query)
    {
      $string=$query;
      $hint="";
      $response = "";
      if (strlen($string)>0) {
          //$string = preg_quote($string, '/');
          $dir = '/usr/www/gui/assets/view/help/';
          $it = new \RecursiveDirectoryIterator($dir);
          foreach(new \RecursiveIteratorIterator($it) as $file) {
              if (!$it->isDot())
              {
                  if (!is_dir($file))
                  {
                      $content = file_get_contents("$file");
                      $title="";
                      if (preg_match("/<title>(.*)<\/title>/siU", $content, $title_matches)){
                          // Clean up title: remove EOL's and excessive whitespace.
                          $title = preg_replace('/\s+/', ' ', $title_matches[1]);
                          $title = trim($title);
                      }
                      $content = strip_tags($content);
                      if (($pos = stripos($content, $string)) !== false) {
                          //if (preg_match("/\b$string\b/i", $content, $matches, PREG_OFFSET_CAPTURE)) {
                          $href = str_replace("$dir","/help/",$file);
                          $href = str_replace(".phtml","",$href);
                          //$pos = $matches[0][1];
                          if( $pos <= 300 ) {
                              $foundstr = substr("$content",0,300);
                          }
                          else {
                                $foundstr = substr("$content",($pos-150),300);
                                $foundstr = "..." . $foundstr;
                          }
                          $foundstr = $foundstr . "...";
                          if ($title=="") {
                                $title = $foundstr;
                          }
                          if ($hint=="") {
                                $hint="<li><a type='button' href='" .
                                $href .
                                "'>" . //"' target='_blank'>" .
                                "<string>" . $title . "</strong></br></a>" . $foundstr . "</li>";
                          } else {
                                $hint=$hint . "</br><li><a type='button' href='" .
                                $href .
                                "'>" . //"' target='_blank'>" .
                                "<string>" . $title . "</strong></br></a>" . $foundstr . "</li>";
                          }
                      }
                  }
              }
          }
          // Set output to "no suggestion" if no hint was found
          // or to the correct values
          if ($hint=="") {
                $response=
                "<li>no suggestion</li>";
          } else {
                $response=$hint;
          }
      }
      return $response;
    }
}