<?php
/**
 *  Class for simple storage actions
 */

namespace Epygi\Storage;

class StorageAbstract
{
    /* config file path [init in child class] */
    public static $file = null;
    public static $multisection = false;

    /**
     * Gets _root elements
     * @return array
     */
    public static function getRootElements()
    {
        $config = ConfigFile::getInstance(static::$file);
        return $config->root()->getArray();
    }

    /**
     * Get element value from selected config file
     *
     * @param $key
     * @param null $defValue
     *
     * @return null
     */
    public static function getElementsById($key, $defValue = null)
    {
        //if (!is_null(static::$file)) {
        $config = ConfigFile::getInstance(static::$file);
        $elements = $config->root()->getArray();
        return isset($elements[$key]) ? $elements[$key] : (!is_null($defValue) ? $defValue : null);
        //}
        //return null;
    }

    /**
     * Class for change value in selected config file
     *
     * @param array $changes - by type $changes[field]
     *
     * @return object
     */
    public static function ChangeValues($changes)
    {
        if (!is_null(static::$file)) {
            $config = ConfigFile::getInstance(static::$file);
            foreach ($changes as $key => $value) {
                $config->root()->set($key, $value);
            }
            return $config;
        }
        return null;
    }

    /**
     * Fetches list of variables by given section name array
     *
     * @param $names - array of section names
     *
     * @return array
     */
    public static function getSectionsArray($names)
    {
        if (!is_null(static::$file)) {
//             $config = ConfigFile::getInstance(static::$file);
            $config = self::getConfigObject();
            $data = array();
            if (is_string($names)) {
                $names = array($names);
            }
            foreach ($names as $name) {
                $section = $config[$name];
                $ids = $section->getArray();
                $data[$name] = $ids;
            }
            return $data;
        }
        return null;
    }

    /**
     * Fetches list of variables of selected section
     *
     * @param $name - string with section name
     *
     * @return array
     */
    public static function getSectionArray($name)
    {
        if (!is_null(static::$file)) {
//             $config = ConfigFile::getInstance(static::$file);
            $config = self::getConfigObject();
            $section = $config[$name];
            $ids = $section->getArray();
            return $ids;
        }
        return null;
    }

    /**
     * Fetches list of variables of selected section
     *
     * @param $name - string with section name
     *
     * @return ConfigSection
     */
    public static function getSection($name)
    {
        if (!is_null(static::$file)) {
            $config = ConfigFile::getInstance(static::$file);
            $section = $config[$name];
            return $section;
        }
        return null;
    }

    /**
     * Change data prepare for Save
     *
     * @param $changes - by type $changes[section][field]
     *
     * @return ConfigFile
     */
    public static function changeSectionsValues($changes)
    {
        if (!is_null(static::$file)) {
            //$config = ConfigFile::getInstance(static::$file);
            $config = self::getConfigObject();
            foreach ($changes as $section => $fields) {
                foreach ($fields as $key => $value) {
                    $config[$section]->$key = $value;
                }
            }
            return $config;
        }
        return null;
    }

    public static function getConfigObject()
    {
        return static::$multisection ? MultisectionConfigFile::getInstance(static::$file) : ConfigFile::getInstance(
            static::$file
        );
    }
}
