<?php

// log management class
class LogMgmt {

    const  LOG_SEPARATOR = "\n=================================[\x03LogEntry\x03]=================================\n";
    const  DATE = "Date";
    const  URL = "FromUrl";
    const  PID = "PID";
    const  DURATION = "Duration";
    const  INFO = "Info";
    const  LOGLVL = "LogLvl";
    const  ROUTE = "Route";
    const  ENDPOINT = "Endpoint";

    // logging level
    const  LVL_OFF = 0; // highest possible rank and is intended to turn off logging.
    const  LVL_ALWAYS = 1; // guarantees logging, provided log lvl > 0.
    const  LVL_FATAL = 2; // designates very severe error events that will presumably lead the application to abort.
    const  LVL_ERROR = 3; // designates error events that might still allow the application to continue running.
    const  LVL_INFO = 4; // designates informational messages that highlight the progress of the application at coarse-grained level.
    const  LVL_DEBUG = 5; // designates fine-grained informational events that are most useful to debug an application.
    const  LVL_TRACE = 6; // designates finer-grained informational events than the DEBUG
    const  LVL_ALL = 6; // lowest possible rank and is intended to turn on all logging.

    // sections
    const  SECTION_HEADERS = "HEADERS";
    const  SECTION_REQUEST = "REQUEST";
    const  SECTION_ARGUMENTS = "ARGUMENTS";
    const  SECTION_DEBUG = "DEBUG";
    const  SECTION_RESPONSE = "RESPONSE";

    // Log record info
    const  LOGREC_LVL = "LogRec";
    const  LOGREC_TXT = "LogText";
    const  LOGREC_SECTION = "LogSection";

    // class members
    private  $currentLogLvl = self::LVL_INFO;
    private  $minLogLvl = self::LVL_ALL;
    private  $route;
    private  $endpoint;
    private  $logFile;
    private  $pendingLines;
    private  $ticksLogStart;
    private  $section;

    public static $logArr =
      array(
        "ALWAYS" => self::LVL_ALWAYS,
        "FATAL" => self::LVL_FATAL,
        "ERROR" => self::LVL_ERROR,
        "INFO" => self::LVL_INFO,
        "DEBUG" => self::LVL_DEBUG,
        "TRACE" => self::LVL_TRACE,
      );

    public function __construct() {
      $this->ticksLogStart = (int)(microtime(true)*1000);
      $this->currentLogLvl = SystemConfig::LOG_LEVEL;
      $this->logFile = SystemConfig::LOG_DIR . DIRECTORY_SEPARATOR . "crmapi.log";
      $this->route = "N/A";
      $this->endpoint = "N/A";
      $this->pendingLines = array();
      $this->section = self::SECTION_HEADERS;
    }

    public function add( $info,  $lvl = null,  $section = null) {
      $section = ($section ? $section : $this->section);
      $lvl = ($lvl ? $lvl : self::LVL_TRACE);
      $this->pendingLines[]= array(self::LOGREC_LVL=>$lvl, self::LOGREC_SECTION=>$section, self::LOGREC_TXT=>"lvl:$lvl; ".print_r($info,true));
      if (SystemConfig::ECHO_LVL_DEBUG_TXT) {
       file_put_contents($this->logFile, "\n" . print_r($info,true), FILE_APPEND | LOCK_EX);
      }
    }

    public function flush($exceptionTxt = false) {
      $duration = (int)(microtime(true)*1000) - $this->ticksLogStart;
      $logTxt = self::LOG_SEPARATOR
        . " " . self::DATE . "=" . date("Y-m-d H:i:s")
        . ", " . self::URL . "=" . (isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : 'localhost')
        . ", " . self::PID . "=" . getmypid()
        . ", " . self::LOGLVL . "=" . $this->currentLogLvl
        . ", " . self::DURATION . "=" . $duration . "ms"
        . ", " . self::ROUTE . "=" . $this->route
        . ", " . self::ENDPOINT . "=" . $this->endpoint
        . ", exceptionTxt=" . $exceptionTxt . ";"
        //. print_r($this->pendingLines,true)
        ;
      foreach($this->pendingLines as $logRec){
        if($logRec[self::LOGREC_LVL] <= $this->currentLogLvl) {
            $logTxt .= "\n" . $logRec[self::LOGREC_TXT];
        } else {
            // $logTxt .= "\n not added: LOGREC_LVL:" . $logRec[self::LOGREC_LVL] . "; currentLogLvl:" . $this->currentLogLvl;
        }
      }
      
      file_put_contents($this->logFile, $logTxt, FILE_APPEND | LOCK_EX);
    }

    public function getCurrentLogLvl()  {
      return $this->currentLogLvl;
    }

    public function setCurrentLogLvl( $lvl) {
      $this->currentLogLvl = $lvl;
    }

    public function getSection()  {
      return $this->section;
    }

    public function setSection( $section) {
      $this->section = $section;
    }

    public function setRoute( $route) {
      $this->route = $route;
      //$this->logFile = SystemConfig::LOG_DIR . DIRECTORY_SEPARATOR . $route . "-" . date("Ymd") . ".log";
      $this->logFile = SystemConfig::LOG_DIR . DIRECTORY_SEPARATOR . "crmapi.log";
    }

    public function setEndpoint( $endpoint) {
      $this->endpoint = $endpoint;
    }
}
