<?php
namespace App\Form\Helper;

use Epygi;
use Mvc;

class Grid extends Mvc\View\AbstractHelper
{
    private $grid = null;

    public function __invoke()
    {
        // form object
        $this->grid = $this->getView()->grid;

        // grid missing!
        if (!($this->grid instanceof Epygi\Grid\Engine)) {
            throw new \Exception('Grid instance missing.  Did you set "grid" in your view?');
        }

        // return reference to this instance
        return $this;
    }

    public function masterCheckbox()
    {
        $xml = new Mvc\Tag('input', 'type', 'checkbox', 'name', 'master', 'value', '1');
        return (string) $xml;
    }

    public function orderClass($field)
    {
        // we are ordering on this field
        if ($this->grid->order->getField() == $field) {
            // are we ordering ASC or DESC?
            return $this->grid->order->getDirection() > 0 ? 'order-down' : 'order-up';
        }

        // not ordering on this field currently
        return 'order-none';
    }

    public function orderLink($field, $label)
    {
        // no field to sort on, use default text output (no link)
        if (!$field) {
            return $label;
        }

        // this column has been selected for ordering!
        $dir = 1;
        $is_on = false;
        if ($this->grid->order->getField() == $field) {
            $dir = ($this->grid->order->getDirection() > 0) ? 0 : 1;
            $is_on = true;
        }

        // generate link
        $xml = new Mvc\Tag('a', 'href', '#', 'data-ocol', $field, 'data-odir', $dir);
        $xml->text($label);

        // add up/down chevron (arrow)
        if ($is_on && $dir > 0) {
            $xml->append('i', 'class', 'fa fa-caret-up', '');
        }
        elseif ($is_on && $dir <= 0) {
            $xml->append('i', 'class', 'fa fa-caret-down', '');
        }
        $xml->pop(); // a
        return (string) $xml;
    }
}