<?php
namespace App\Maintenance;

use Epygi;
use Exception;
use Mvc;

class RebootForm extends Epygi\Form\AbstractForm
{

    public function execute()
    {
        // log message to syslog
        syslog(LOG_INFO, 'Reboot...');
        closelog();

        /*
         * if we are using the redundancy feature, we need to sleep long enough for the system to sync up all
         * the way.  I'm not sure this needs to be done this way.  Perhaps instead we should NOT allow a reboot
         * button to be pressed until 65 seconds after the big even occurred.  Why sleep then reboot?  -- Dante
         */
        if (Mvc\Feature::hasRedundancy()) {
            //    $rc = Epygi\Storage\ConfigFactory::rc();
            //    $keepalive = $rc->getBool('START_KEEPALIVED');
            //    if ($keepalive) {
            //        sleep(65);
            //    }
        }

        // do reboot
        try {
            Epygi\Shell\Command\Reboot::reboot();
        }
        catch (Exception $ex) {
            $this->syserr(_('Unable to reboot device.'));
        }

        // success
        Epygi\View\GlobalError::success('System rebooting!');
        return true;
    }

    protected function onFirstLoad()
    {
        // reset
        $this->clear();
    }

    protected function prepare()
    {
        $this->hasAccessRights= Epygi\Storage\AclDb::hasAccessRights('reboot', Epygi\Auth::getRole());
    }
}