<?php
namespace Epygi\Crypt;

class HmacAuth
{
	private static $tokenType = "hmacauth"; 
	private static $hmacAlg = "sha256";
	private static $secretKey = "";
    function __construct($secret, $tokentype="hmacauth", $hmacalg = "sha256") {
		self::$secretKey=$secret;
		self::$tokenType=$tokentype;
		self::$hmacAlg=$hmacalg;
    }

	private function isValidTimeStamp($timestamp) {
		return (is_numeric($timestamp) && (int) $timestamp == $timestamp) ;
	}

	public function verifyTime($timestamp, $validPeriodSec=60) {
		if($this->isValidTimeStamp($timestamp)) {
			$diff = abs(time() - $timestamp);
			if($diff >= 0 && $diff < $validPeriodSec) {
				return true;
			}
		}

		return false;
	}
	// Get hearder Authorization
	private function getAuthorizationHeader() {
		$headers = null;
		if (isset($_SERVER['Authorization'])) {
			$headers = trim($_SERVER["Authorization"]);
		}
		else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
			$headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
		} elseif (function_exists('apache_request_headers')) {
			$requestHeaders = apache_request_headers();
			// Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
			$requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
			//print_r($requestHeaders);
			if (isset($requestHeaders['Authorization'])) {
				$headers = trim($requestHeaders['Authorization']);
			}
		}
		return $headers;
	}
	
	// Get access token from header
	public function gethmacauthToken() {
		$headers = $this->getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			$matchReg = '/'.self::$tokenType.'\s(\S+)/';
			if (preg_match($matchReg, $headers, $matches)) {
				return $matches[1];
			}
		}
		return null;
	}
	
	private function verifySignature($string_to_verify, $signature) {
		return hash_equals(hash_hmac(self::$hmacAlg, $string_to_verify, self::$secretKey), $signature);
	}
	
	public function verify($string_to_verify, $signature)
	{
		return $this->verifySignature($string_to_verify, $signature);
	}
}

?>
