#!/bin/bash

# Check if an input file is provided as a command-line argument
if [ "$#" -ne 2 ]; then
    echo "Usage: $0 <DHCP default file> <DHCP current file>"
    exit 1
fi

# Assign the input file from the command line argument
dhcpcurrentfile="$2"
dhcpdefaultfile="$1"

if [ ! -f $dhcpcurrentfile ] ; then
    echo "DHCP current file $dhcpcurrentfile does not exists"
    exit 1
fi

if [ ! -f $dhcpdefaultfile ] ; then
    echo "DHCP current file $dhcpdefaultfile does not exists"
    exit 1
fi

dhcp_temporary="/tmp/dhcp_temporary"

IPAddress=$(grep -m 1 "option routers" $dhcpcurrentfile | awk '{print $3}' | tr -d ';')
STR1=$(grep -m 1 "option tftp-server-name" $dhcpdefaultfile | awk '{print $3}' | tr -d ';')
updatedString=$(echo "$STR1" | sed "s|\(.*://\)\?[0-9.]\+\(/\)|\1$IPAddress\2|")
# Define the replacement string
replacement="	option tftp-server-name $updatedString;"
awk '!/option tftp-server-name/ || ++count > 1' $dhcpcurrentfile > $dhcp_temporary
# Add the replacement line before "option routers;"
sed -i "/option routers/i\\$replacement" "$dhcp_temporary"

mv -f $dhcp_temporary $dhcpcurrentfile

exit 0
