#!/bin/bash

DEFAULT_CONF=$1
CURRENT_CONF=$2
EXTRACTED_BLOCK="/tmp/extracted_block"
TEMP_FILE="/tmp/dhcp_temp_config"

# Remove all lines before the first occurrence of "substring" (keeping that line)
echo "" >"$EXTRACTED_BLOCK"
sed -n '/substring/,$p' "$DEFAULT_CONF" | sed '/^}$/d' >> "$EXTRACTED_BLOCK"

if [ ! -s "$EXTRACTED_BLOCK" ]; then
    echo "Error: Could not extract the required block from $DEFAULT_CONF"
    exit 1
fi

DEFAULTIP=$(grep -m 1 "option routers" $DEFAULT_CONF | awk '{print $3}' | tr -d ';')
CURRENTIP=$(grep -m 1 "option routers" $CURRENT_CONF | awk '{print $3}' | tr -d ';')

# Modify IP address in extracted block
sed -i "s|$DEFAULTIP|$CURRENTIP|g" "$EXTRACTED_BLOCK"
	
# Backup the original dhcp configuration file
cp "$CURRENT_CONF" "${CURRENT_CONF}.bak"

# Remove all the subaddress(hardware blocks from current dhcpd configuration
awk '
    /substring\(hardware,/ { 
	in_block = 1;  # Start removing lines
	next;
    }
    /host / && in_block { 
	in_block = 0;  # Stop removing at first "host"
    }
    !in_block { 
	print;  # Print only if we are NOT in the block
    }
    END {
        if (in_block) print "}";  # If no "host" is found after last substring, add "}"
    }
' "$CURRENT_CONF" > "$TEMP_FILE"

# Insert subaddress(hardware blocks from default configuration
sed -i "/authoritative;/r $EXTRACTED_BLOCK" "$TEMP_FILE"
mv $TEMP_FILE $CURRENT_CONF
rm -f $EXTRACTED_BLOCK
exit 0
