<?php
namespace App\Doc;

use Epygi;
use Exception;
use Mvc;

class ConfigViewerForm extends Epygi\Form\AbstractForm
{
    public function execute()
    {
        // do nothing
    }

    protected function onFirstLoad()
    {
        // reset
        $this->clear('auth_id');

        // read file name
        $this->filename = Mvc\Param::request('filename');
    }

    protected function prepare()
    {
        // clean file name
        $this->filename = preg_replace('/\.\./', '', $this->filename);

        // load input file and format as output file
        $abs_file = null;
        $this->input = $this->output = '...';

        $abs_path = null;
        if ($this->filename) {
            try {
                // generate OUTPUT
                $config = Epygi\Storage\ConfigFile::getInstance($this->filename);
                $abs_path = $config->abs_file_path;
                $this->output = (string) $config;
            }
            catch (Exception $ex) {
                $this->output = $ex->getMessage();
            }

            // load INPUT
            if ($abs_path && file_exists($abs_path)) {
                $this->input = file_get_contents($abs_path);
            }
            else {
                $this->input = 'file not found';
            }
        }

        // required
        $this->reqAll('filename');
    }
}