<?php
namespace App\Form\Helper;

use Mvc\Tag;
use Mvc\View\AbstractHelper;

class EpyRow extends AbstractHelper
{
    private $form = null;
    private $xml = null;
    private $field = null;

    public function __invoke()
    {
        // form object
        $this->form = $this->getView()->form;

        // return this instance
        return $this;
    }

    public function close()
    {
        // continue with XML block we were building
        $xml = $this->xml;

        // retrieve captured PHP output buffer and merge
        $buffer = ob_get_clean();
        $xml->raw($buffer);

        // error (as text message)
        $error = $this->form->getMarkedError($this->field);
        if ($error) {
            $xml->append('div', 'class', 'error-block', $error);
        }

        // render xhtml
        echo (string) $xml;
    }

    public function open($field, $label = '')
    {
        $this->field = $field;

        // has error?
        $error = $this->form->getMarkedError($field);
        $css_error = $error ? ' has-error' : '';

        // required?
        $required = $this->form->isRequired($field) || $this->form->isFakeRequired($field);
        $css_required = $required ? ' required' : '';

        $xml = new Tag();

        // generate xml for this for row
        $xml->push('div', 'class', trim('row' . $css_error . $css_required));

        // add label
        if ($label) {
            // add missing colon to end of label
            if (!preg_match('/:$/', $label)) {
                $label .= ':';
            }
            $xml->append('label', 'for', $field, $label);
        }

        // no label, use blank space
        else {
            $xml->push('label', 'for', $field);
            $xml->raw('&nbsp;');
            $xml->pop(); // label
        }

        // control
        $xml->push('div', 'class', 'control');

        // start capturing PHP output into buffer
        $this->xml = $xml;
        ob_start();
    }
}