<?php
namespace App\Form\Helper;

use Mvc\Tag;
use Mvc\View\AbstractHelper;

class EpyWidget extends AbstractHelper
{
    public $buffer = false;
    private $form = null;

    public function __invoke()
    {
        // form object
        $this->form = $this->getView()->form;
        return $this;
    }

    public function h3($text)
    {
        $xml = new Tag('h3', $text);
        return (string) $xml;
    }

    public function hidden($field, $value = array())
    {
        $xml = new Tag();
        $xml->push('input', 'type', 'hidden', 'name', $field, 'id', $field, 'value', $value);
        $xml->pop();
        return (string) $xml;
    }

    public function hint($text)
    {
        $xml = new Tag('span', 'class', 'help-block');
        $xml->text($text);
        return (string) $xml;
    }

    public function input($type, $field, $css_class = null, $attr = array())
    {
        $xml = new Tag();

        // input
        //when used in places other than forms (like in grids, we don't need to get value, just the field so form should be empty
        $value = isset($attr['value']) ? $attr['value'] : ($this->form ? $this->form->getValue($field) : '');
        $css_class = trim('form-control ' . $css_class);
        $xml->push('input', 'type', $type, 'class', $css_class, 'name', $field, 'value', $value);

        // placeholder
        $placeholder = isset($attr['placeholder']) ? $attr['placeholder'] : false;
        $xml->attr('placeholder', $placeholder, $placeholder);

        // required -- turned off required checks in HTML5 cuz it's annoying -- Dante
        // $required = $this->form->isRequired($field);
        // $xml->attr('required', 'required', $required);

        // id
        $id = isset($attr['id']) ? $attr['id'] : false;
        $xml->attr('id', $id, $id);

        // disabled
        $disabled = isset($attr['disabled']) ? $attr['disabled'] : false;
        $xml->attr('disabled', 'disabled', $disabled);

        // style
        $style = isset($attr['style']) ? $attr['style'] : false;
        $xml->attr('style', $style, $style);

        //// autocomplete
        //$autocomplete = isset($attr['autocomplete']) ? $attr['autocomplete'] : false;
        //$xml->attr('autocomplete', $autocomplete, $autocomplete);

        // pattern
        $pattern = isset($attr['pattern']) ? $attr['pattern'] : false;
        $xml->attr('pattern', $pattern, $pattern);

        //allow to use this widget in other pages like grid
        if (is_callable(array($this->form, 'getMarkedError'))) {
            $error = $this->form->getMarkedError($field);
            // error (as input attribute)
            $xml->attr('class', 'error', $error);
        }

        $xml->pop(); // input

        // widget
        return (string) $xml;
    }

    public function ip($field, $attr = array())
    {
        //removed Js validation in favor of server validation
        //$attr['pattern'] = '\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}';
        return $this->input('text', $field, 'ip-control', $attr);
    }

    public function label($field, $text)
    {
        $css = array('wgrid-label');

        // has error?
        if ($this->form->getMarkedError($field)) {
            $css[] = 'has-error';
        }

        // required?
        if ($this->form->isRequired($field) || $this->form->isFakeRequired($field)) {
            $css[] = 'required';
        }

        // generate xml for this for row
        $xml = new Tag();
        $xml->push('div', 'class', join(' ', $css));
        $xml->append('label', 'for', $field, $text);
        $xml->pop(); // div

        return (string) $xml;
    }

    public function password($field, $css_class = null, $attr = array())
    {
        return $this->input('password', $field, $css_class, $attr);
    }

    public function select($field, $options, $first_row = '', $attr = array())
    {
        $xml = new Tag('select', 'name', $field, 'class', 'form-control width-auto');

        if ($attr) {
            foreach ($attr as $k => $v) {
                $xml->attr($k, $v);
            }
        }

        if ($first_row) {
            $xml->append('option', 'value', '', $first_row);
        }

        // options
        $value = $this->form ? $this->form->getValue($field) : null;
        foreach ($options as $opt_value => $opt_label) {
            $xml->push('option', 'value', $opt_value);
            $xml->attr('selected', 'selected', $opt_value == $value);
            $xml->text($opt_label);
            $xml->pop(); // option
        }

        $xml->pop(); // select

        // widget
        return (string) $xml;
    }

    /**
     * Draw a single form submit button.
     *
     * @param $field - field name
     * @param $label - button label
     *
     * @return string - xhtml tag
     */
    public function submitButton($field, $label)
    {
        // submit button
        $xml = new Tag('input', 'type', 'submit', 'class', 'btn btn-default', 'name', $field, 'value', $label);

        // disabled
        //$disabled = isset($attr['disabled']) ? $attr['disabled'] : false;
        //$xml->attr('disabled', 'disabled', $disabled);

        $xml->pop(); // input

        // widget
        return (string) $xml;
    }

    public function text($field, $css_class = null, $attr = array())
    {
        return $this->input('text', $field, $css_class, $attr);
    }
}