<?php
namespace App\Maintenance;

use Epygi;

class PingForm extends Epygi\Form\AbstractForm
{
    public function execute()
    {
        return true;
    }

    protected function onFirstLoad()
    {
        // reset
        $this->clear();
    }

    protected function prepare()
    {
        // required
        //$this->req('target');

        $this->hasAccessRights= Epygi\Storage\AclDb::hasAccessRights('ping', Epygi\Auth::getRole());
        
        // generate URL to our ping command url
        $this->command_url = false;
        if ($this->target) {
            $url = new Epygi\Url('/maintenance/ping-command');
            $url->attr('target', $this->target);
            $this->command_url = (string) $url;
        }
    }
}