<?php
namespace Epygi\Db\Connection;

use Epygi;
use Exception;
use Mvc;
use PDO;

class Extensions extends Epygi\Db\PdoConnection
{
    // connection params
    const CFKEY_DB_DSN = 'extensiondb';

    /**
     * PDO Database connection object.
     * @var $PDO PDO
     */
    private static $PDO = null;

    public static function getConnection($force = false)
    {
        // create connection for the first time
        if ($force || !self::$PDO) {
            // create a new connection
            $dsn = Mvc\Config::getDb(self::CFKEY_DB_DSN);
            $pdo = self::$PDO = new PDO($dsn);

            // set attributes on connection
            $pdo->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }

        // connection is no good, abort!
        if (!self::$PDO) {
            throw new Exception('connection failed!');
        }

        // return connection
        return self::$PDO;
    }
}