<?php
namespace Epygi\Selected;

use Epygi;
use Mvc;

class Extension
{
    const INVALID_URI = '/home';
    const VALID_KEY = 'id';

    private $is_valid = false;
    private $session = null;
    private $data = null;

    private function __construct()
    {
        $this->session = new Mvc\Session(get_called_class());

        // do we have a new ID to use?
        $id = $this->autoSelect();

        // load and validate this ID
        $this->setId($id);
    }

    private function autoSelect()
    {
        // we are logged in as an extension
        if (Epygi\Auth::isExtension() || Epygi\Auth::isRecording() ) {
            return Epygi\Auth::getUsername();
        }

        // we are logged in as a conference
        if (Epygi\Auth::isConference()) {
            return Epygi\Auth::getUsername();
        }

        // we are logged in as a voicemailbox
        if (Epygi\Auth::isVoiceMailBox()) {
            return Epygi\Auth::getUsername();
        }

        // we are an admin or localadmin
        if (Epygi\Auth::isAdmin() || Epygi\Auth::isLocalAdmin( ) ) {
            // "extension_name" or "conference_name" passed as a parameter to the page
            $extension_id = Mvc\Param::request('extension_name', false);
            if (!$extension_id ) {
                $extension_id = Mvc\Param::request('conference_name', false);
                if (!$extension_id)
                    $extension_id = Mvc\Param::request('vmb_name', false);
            }
            //$extension_id = Mvc\Param::request('extension_name', Mvc\Param::request('conference_name', false));

            // save selection
            if ($extension_id) {
                return $extension_id;
            }

	    // commented for SPR 19928
	    ////////////////////////////////////////////////////////
	/*
            // sometimes we use a hidden checked item to pass the param
            $extension_id = Mvc\Param::request('HiddenCheckedItem', false);
            if ($extension_id) {
                return $extension_id;
            }

            /*
             * We are wrapping the CGI pages.  For some reason there is a SmartCheckbox_2realbox=3131 in the
             * HTTP headers and that's the extension ID selection from the Extensions list page.  Well, this CGI
             * needs to support multi-edit behavior, so we can't rely that there will be only ONE item
             * marked as "...realbox" therefore we'll just read the first 'realbox' that is set and assume
             * all other items are at least of the same extension type (right? wrong.) ... we technically
             * can't select the proper extension type now and this is likely all a big mess.
             */
	     /*
            foreach ($_REQUEST as $key => $param) {
                if (preg_match('#realbox$#', $key)) {
                    return $extension_id = $param;
                }
            }
	*/
	////////////////////////////////////////////////////////
        }

        // for all other pages, used the cached value
        $cached = $this->getId() ? $this->getId() : 'someInvalidExt';
        return $cached;
    }

    public function get($key, $default = null)
    {
        return isset($this->data[$key]) ? $this->data[$key] : $default;
    }

    public function getId()
    {
        return $this->session->get('id');
    }

    public static function getInstance($force = false)
    {
        static $instance = null;
        return ($instance && !$force) ? $instance : $instance = new self($force);
    }

    public function getType()
    {
        return $this->get('type');
    }

    public function isConference()
    {
        return $this->getType() == 'conference';
    }

    public function isVoiceMailBox()
    {
        return $this->getType() == 'voicemailbox';
    }

    public function isExtension()
    {
        return $this->getType() == 'extension';
    }

    public function isAcdQueue()
    {
        return $this->getType() == 'acdextension';
    }

    public function isTemplate()
    {
	return $this->getType() == 'template';
    }

    public function isRecording()
    {
	return $this->getType() == 'recordingbox';
    }

    public function isValid()
    {
        return (boolean) $this->is_valid;
    }

    private function load($id)
    {
        // no id to validate
        if (strlen($id) < 1) {
            return array();
        }

        // load extension object
        $ext = new Epygi\Storage\Extension($id);

        // extension is not valid
        if (!$ext->exists()) {
            return array();
        }

        // found this extension!
        return array(
            'id' => $id,
            'type' => $ext->getExtensionType()
        );
    }

    public function rejectUnlessValid()
    {
        if (!$this->is_valid) {
            header('Location: ' . static::INVALID_URI);
            exit;
        }
    }

    public function setId($id)
    {
        // load record from database
        $this->data = $this->load($id);

        // is our key found in the data?
        $this->is_valid = isset($this->data[static::VALID_KEY]);

        // make sure this is a valid entry for this type
        $id = $this->is_valid ? $id : 0;

        // save value in our session
        return $this->session->set('id', $id);
    }
}