<?php
namespace Epygi\Storage;
use Mvc\Feature;
use Mvc\FeatureUtils;

class Sms extends StorageAbstract
{
    public static $smsConf = '/mnt/flashfs/smsprofile';
    public static function GetTwilioSID( )
    {
		if( FeatureUtils::isEnabledSmsForExtensions() ){
			$conf = MultisectionConfigFile::getInstance(static::$smsConf);
			$common_section = $conf->offsetGet("common");
			if($common_section->get("active") == "twilio") {
				$sections = $conf->sections();
				foreach ($sections as $section) {
					if($section->getName() == "twilio" ){
						return $section->get("username");
					}
				}
			}
		}
	return "";
    }
    public static function GetTwilioAuth( )
    {
		if( FeatureUtils::isEnabledSmsForExtensions() ){
			$conf = MultisectionConfigFile::getInstance(static::$smsConf);
			$common_section = $conf->offsetGet("common");
			if($common_section->get("active") == "twilio") {
				$sections = $conf->sections();
				foreach ($sections as $section) {
					if($section->getName() == "twilio" ){
						return $section->get("password");
					}
				}
			}
		}
	return "";
    }
    public static function GetTelnyxPublicKey( )
    {
		if( FeatureUtils::isEnabledSmsForExtensions() ){
			$conf = MultisectionConfigFile::getInstance(static::$smsConf);
			$common_section = $conf->offsetGet("common");
			if($common_section->get("active") == "telnyx") {
				$sections = $conf->sections();
				foreach ($sections as $section) {
					if($section->getName() == "telnyx" ){
						return $section->get("username");
					}
				}
			}
		}
		return "";
    }
    public static function GetClearflyWebhookToken( )
    {
		if( FeatureUtils::isEnabledSmsForExtensions() ){
			$conf = MultisectionConfigFile::getInstance(static::$smsConf);
			$common_section = $conf->offsetGet("common");
			if($common_section->get("active") == "clearfly") {
				$sections = $conf->sections();
				foreach ($sections as $section) {
					if($section->getName() == "clearfly" ){
						return $section->get("webhooktoken");
					}
				}
			}
		}
		return "";
    }	
}